/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.grid;

import java.util.Collection;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.GridFeatureBuilder;
import org.geotools.grid.ortholine.OrthoLineBuilder;
import org.geotools.grid.ortholine.OrthoLineDef;
import org.geotools.grid.ortholine.OrthoLineFeatureBuilder;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Lines {
    public static SimpleFeatureSource createOrthoLines(ReferencedEnvelope bounds, Collection<OrthoLineDef> lineDefs) {
        return Lines.createOrthoLines(bounds, lineDefs, 0.0);
    }

    public static SimpleFeatureSource createOrthoLines(ReferencedEnvelope bounds, Collection<OrthoLineDef> lineDefs, double vertexSpacing) {
        return Lines.createOrthoLines(bounds, lineDefs, vertexSpacing, new OrthoLineFeatureBuilder(bounds.getCoordinateReferenceSystem()));
    }

    public static SimpleFeatureSource createOrthoLines(ReferencedEnvelope bounds, Collection<OrthoLineDef> lineDefs, double vertexSpacing, GridFeatureBuilder lineFeatureBuilder) {
        if (bounds == null || bounds.isEmpty() || bounds.isNull()) {
            throw new IllegalArgumentException("The bounds should not be null or empty");
        }
        if (lineDefs == null || lineDefs.isEmpty()) {
            throw new IllegalArgumentException("One or more line controls must be provided");
        }
        CoordinateReferenceSystem boundsCRS = bounds.getCoordinateReferenceSystem();
        CoordinateReferenceSystem builderCRS = lineFeatureBuilder.getType().getCoordinateReferenceSystem();
        if (boundsCRS != null && builderCRS != null && !CRS.equalsIgnoreMetadata((Object)boundsCRS, (Object)builderCRS)) {
            throw new IllegalArgumentException("Different CRS set for bounds and the feature builder");
        }
        ListFeatureCollection fc = new ListFeatureCollection(lineFeatureBuilder.getType());
        OrthoLineBuilder lineBuilder = new OrthoLineBuilder(bounds);
        lineBuilder.buildGrid(lineDefs, lineFeatureBuilder, vertexSpacing, fc);
        return DataUtilities.source(fc);
    }
}

