/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.render;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class TileCalculator {
    private AffineTransform worldToScreen;
    private Dimension tileSize;
    private Envelope bounds;
    private int numXTiles;
    private int numYTiles;
    private Coordinate worldTileSize;
    private Rectangle rect;
    Set<Point> randomMap;
    Random random = new Random();

    public TileCalculator(AffineTransform worldToScreen, Dimension tileSize) {
        this.worldToScreen = worldToScreen;
        this.tileSize = tileSize;
    }

    public TileCalculator(AffineTransform worldToScreen, Dimension tileSize, Envelope bounds) {
        this.worldToScreen = worldToScreen;
        this.tileSize = tileSize;
        this.bounds = bounds;
        this.reset();
    }

    public int numXTiles() {
        this.validateState();
        return this.numXTiles;
    }

    private void validateState() {
        if (this.bounds == null) {
            throw new IllegalStateException("Bounds must be set before TileCalculator may be used");
        }
        if (this.tileSize == null) {
            throw new IllegalStateException("Tile Size must be set before TileCalculator may be used");
        }
        if (this.worldToScreen == null) {
            throw new IllegalStateException("World to Screen transform must be set before TileCalculator may be used");
        }
    }

    public int numYTiles() {
        this.validateState();
        return this.numYTiles;
    }

    public Envelope getWorldTile(int x, int y) {
        this.validateState();
        double xmin = this.bounds.getMinX() + this.worldTileSize.x * (double)x;
        double ymin = this.bounds.getMinY() + this.worldTileSize.y * (double)y;
        return new Envelope(xmin, Math.min(xmin + this.worldTileSize.x, this.bounds.getMaxX()), ymin, Math.min(ymin + this.worldTileSize.y, this.bounds.getMaxY()));
    }

    public Rectangle getScreenTile(int x, int y) {
        this.validateState();
        int xmin = this.rect.x + this.tileSize.width * x;
        int ymin = this.rect.y + this.tileSize.height * y;
        int width = Math.min(this.tileSize.width, (int)this.rect.getMaxX() - xmin);
        int height = Math.min(this.tileSize.height, (int)this.rect.getMaxY() - ymin);
        return new Rectangle(xmin, ymin, width, height);
    }

    private void reset() {
        double[] points = new double[]{this.bounds.getMinX(), this.bounds.getMinY(), this.bounds.getMaxX(), this.bounds.getMaxY()};
        this.worldToScreen.transform(points, 0, points, 0, 2);
        this.rect = new Rectangle((int)points[0], (int)points[1], Math.abs((int)(points[2] - points[0])), Math.abs((int)(points[3] - points[1])));
        this.numXTiles = (int)Math.ceil(this.rect.getWidth() / this.tileSize.getWidth());
        this.numYTiles = (int)Math.ceil(this.rect.getHeight() / this.tileSize.getHeight());
        this.worldTileSize = new Coordinate(this.bounds.getWidth() / (double)this.numXTiles, this.bounds.getHeight() / (double)this.numYTiles);
    }

    public void resetRandomizer() {
        this.validateState();
        this.randomMap = new HashSet<Point>();
        int x = 0;
        while (x < this.numXTiles) {
            int y = 0;
            while (y < this.numYTiles) {
                this.randomMap.add(new Point(x, y));
                ++y;
            }
            ++x;
        }
    }

    public Envelope getWorldRandom() {
        if (this.randomMap == null) {
            this.validateState();
            this.resetRandomizer();
        }
        if (this.randomMap.isEmpty()) {
            return null;
        }
        int x = this.random.nextInt(this.numXTiles);
        int y = this.random.nextInt(this.numXTiles);
        Point point = new Point(x, y);
        while (!this.randomMap.contains(point)) {
            x = this.random.nextInt(this.numXTiles);
            y = this.random.nextInt(this.numXTiles);
            point = new Point(x, y);
        }
        this.randomMap.remove(point);
        return this.getWorldTile(x, y);
    }

    public Rectangle getScreenRandom() {
        if (this.randomMap == null) {
            this.validateState();
            this.resetRandomizer();
        }
        if (this.randomMap.isEmpty()) {
            return null;
        }
        int x = this.random.nextInt(this.numXTiles);
        int y = this.random.nextInt(this.numXTiles);
        Point point = new Point(x, y);
        while (!this.randomMap.contains(point)) {
            x = this.random.nextInt(this.numXTiles);
            y = this.random.nextInt(this.numXTiles);
            point = new Point(x, y);
        }
        this.randomMap.remove(point);
        return this.getScreenTile(x, y);
    }

    public Envelope getBounds() {
        return this.bounds;
    }

    public void setBounds(Envelope bounds) {
        this.bounds = bounds;
        this.reset();
    }

    public Dimension2D getTileSize() {
        return this.tileSize;
    }

    public void setTileSize(Dimension tileSize) {
        this.tileSize = tileSize;
        this.reset();
    }

    public AffineTransform getWorldToScreen() {
        return this.worldToScreen;
    }

    public void setWorldToScreen(AffineTransform worldToScreen) {
        this.worldToScreen = worldToScreen;
        this.reset();
    }
}

