/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.render;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IStyleBlackboard;
import net.refractions.udig.project.internal.render.Renderer;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.IRenderMetricsFactory;
import org.geotools.util.Range;

public abstract class AbstractRenderMetrics {
    protected final IRenderContext context;
    protected final IRenderMetricsFactory factory;
    private final List<String> expectedStyleIDs;
    protected long latencyMetric = 200L;
    protected long timeToDrawMetric = 600L;
    protected double resolutionMetric = 1.0;
    public static final long LATENCY_MEMORY = 0L;
    public static final long LATENCY_MEMORY_CACHE = 100L;
    public static final long LATENCY_LOCAL = 200L;
    public static final long LATENCY_LOCAL_CACHE = 300L;
    public static final long LATENCY_NETWORK_CACHE = 400L;
    public static final long LATENCY_NETWORK = 500L;
    public static final long DRAW_IMAGE_INDEX = 100L;
    public static final long DRAW_IMAGE_MEMORY = 200L;
    public static final long DRAW_IMAGE_RAW = 300L;
    public static final long DRAW_IMAGE_COMPRESSED = 600L;
    public static final long DRAW_DATA_MEMORY = 400L;
    public static final long DRAW_DATA_INDEX = 500L;
    public static final long DRAW_DATA_RAW = 600L;
    public static final double RES_DENSE = 0.5;
    public static final double RES_PIXEL = 1.0;
    public static final double RES_SPARSE = 42.0;
    private String id;

    public long getTimeToDrawMetric() {
        return this.timeToDrawMetric;
    }

    protected AbstractRenderMetrics(IRenderContext context, IRenderMetricsFactory factory, List<String> expectedStyleIds) {
        this.context = context;
        this.factory = factory;
        this.expectedStyleIDs = expectedStyleIds;
    }

    public abstract Renderer createRenderer();

    public abstract boolean canStyle(String var1, Object var2);

    public boolean canAddLayer(ILayer layer) {
        return false;
    }

    public IRenderContext getRenderContext() {
        return this.context;
    }

    public IRenderMetricsFactory getRenderMetricsFactory() {
        return this.factory;
    }

    public Set<Range<Double>> getValidScaleRanges() {
        return new HashSet<Range<Double>>();
    }

    public long getLatencyMetric() {
        return this.latencyMetric;
    }

    public long getDrawingTimeMetric() {
        return this.timeToDrawMetric;
    }

    public double getResolutionMetric() {
        return this.resolutionMetric;
    }

    public double getRenderAppearanceMetric(IStyleBlackboard blackboard) {
        int numberStylesICanUse = 0;
        for (String styleID : blackboard.keySet()) {
            Object style = blackboard.get(styleID);
            if (!this.expectedStyleIDs.contains(styleID) || !this.canStyle(styleID, style)) continue;
            ++numberStylesICanUse;
        }
        double renderMetric = 1.0;
        if (this.expectedStyleIDs.size() > 0) {
            renderMetric = (double)numberStylesICanUse / (double)this.expectedStyleIDs.size();
        }
        return renderMetric;
    }

    public double getUserAppearanceMetric(IStyleBlackboard blackboard) {
        int numberStylesICanUse = 0;
        for (String styleID : blackboard.keySet()) {
            Object style = blackboard.get(styleID);
            if (!this.expectedStyleIDs.contains(styleID) || !this.canStyle(styleID, style)) continue;
            ++numberStylesICanUse;
        }
        double userMetric = 1.0;
        if (blackboard.keySet().size() > 0) {
            userMetric = (double)numberStylesICanUse / (double)blackboard.keySet().size();
        }
        return userMetric;
    }

    public final List<String> getExpectedStyles() {
        return this.expectedStyleIDs;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AbstractRenderMetrics)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        AbstractRenderMetrics m = (AbstractRenderMetrics)o;
        if (!m.context.equals(this.context)) {
            return false;
        }
        if (this.getLatencyMetric() != m.getLatencyMetric()) {
            return false;
        }
        if (this.getResolutionMetric() != m.getResolutionMetric()) {
            return false;
        }
        return this.getDrawingTimeMetric() == m.getDrawingTimeMetric();
    }
}

