/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.memento;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.project.memento.ParserState;
import net.refractions.udig.project.memento.Tokens;
import org.eclipse.ui.IMemento;

public class UdigMemento
implements IMemento {
    private final Map<String, List<IMemento>> m_children = new HashMap<String, List<IMemento>>();
    private Map<String, String> m_data = new HashMap<String, String>();
    private String m_text;
    private String m_type;

    public UdigMemento createChild(String type) {
        UdigMemento child = new UdigMemento();
        child.m_type = type;
        List<IMemento> list = this.getTypeList(type);
        list.add(child);
        return child;
    }

    private List<IMemento> getTypeList(String type) {
        List<IMemento> list = this.m_children.get(type);
        if (list == null) {
            list = new ArrayList<IMemento>();
            this.m_children.put(type, list);
        }
        return list;
    }

    public IMemento createChild(String type, String id) {
        IMemento found = this.findChild(type, id);
        if (found == null) {
            found = this.createChild(type);
            found.putString("IMemento.internal.id", id);
        }
        return found;
    }

    public IMemento findChild(String type, String id) {
        IMemento[] children = this.getChildren(type);
        IMemento found = null;
        IMemento[] iMementoArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento memento = iMementoArray[n2];
            if (id == null) {
                if (memento.getID() == null) {
                    found = memento;
                    break;
                }
            } else if (id.equals(memento.getID())) {
                found = memento;
                break;
            }
            ++n2;
        }
        return found;
    }

    public IMemento getChild(String type) {
        return this.getTypeList(type).get(0);
    }

    public IMemento[] getChildren(String type) {
        return this.getTypeList(type).toArray(new IMemento[0]);
    }

    public Float getFloat(String key) {
        try {
            return Float.valueOf(this.getString(key));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getID() {
        return this.getString("IMemento.internal.id");
    }

    public Integer getInteger(String key) {
        try {
            return Integer.valueOf(this.getString(key));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getString(String key) {
        return this.m_data.get(key);
    }

    public String getTextData() {
        return this.m_text;
    }

    public void putFloat(String key, float value) {
        this.m_data.put(key, String.valueOf(value));
    }

    public void putInteger(String key, int value) {
        this.m_data.put(key, String.valueOf(value));
    }

    public void putMemento(IMemento memento) {
        if (!(memento instanceof UdigMemento)) {
            throw new IllegalArgumentException(memento.getClass() + " cannot be put into a UdigMemento");
        }
        UdigMemento other = (UdigMemento)memento;
        this.m_children.putAll(other.m_children);
        this.m_data.putAll(other.m_data);
    }

    public void putString(String key, String value) {
        this.m_data.put(key, value);
    }

    public void putTextData(String data) {
        this.m_text = data;
    }

    public void write(OutputStream outputStream, int indent) {
        PrintStream out = new PrintStream(outputStream);
        this.println(out, indent, (Object)((Object)Tokens._memento_) + "{");
        if (this.m_text != null) {
            this.writeText(indent + 1, out);
        }
        if (this.m_data.size() > 0) {
            this.writeData(indent + 1, out);
        }
        if (this.m_children.size() > 0) {
            this.writeChildren(indent + 1, out);
        }
        this.println(out, indent, "}");
    }

    private void writeText(int indent, PrintStream out) {
        this.println(out, indent, (Object)((Object)Tokens._text_) + "{");
        this.println(out, 0, this.m_text);
        this.println(out, indent, "}");
    }

    private void writeData(int indent, PrintStream out) {
        this.println(out, indent, (Object)((Object)Tokens._data_) + "{");
        Set<Map.Entry<String, String>> dataItems = this.m_data.entrySet();
        for (Map.Entry<String, String> entry : dataItems) {
            String value = this.toNullToken(entry.getValue());
            String key = this.toNullToken(entry.getKey());
            this.println(out, indent + 1, "|" + key + "|{");
            this.println(out, 0, value);
            this.println(out, indent + 1, "}");
        }
        this.println(out, indent, "}");
    }

    private String toNullToken(String value) {
        if (value == null) {
            value = Tokens.__null__.name();
        }
        return value;
    }

    private void writeChildren(int indent, PrintStream out) {
        this.println(out, indent, (Object)((Object)Tokens._children_) + "{");
        Set<Map.Entry<String, List<IMemento>>> childEntries = this.m_children.entrySet();
        for (Map.Entry<String, List<IMemento>> entry2 : childEntries) {
            String typeName = this.toNullToken(entry2.getKey());
            this.println(out, indent + 1, String.valueOf(typeName) + "{");
            boolean isFirst = true;
            List<IMemento> mementos = entry2.getValue();
            for (IMemento memento : mementos) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    this.println(out, indent + 2, ",");
                }
                ((UdigMemento)memento).write(out, indent + 2);
            }
            this.println(out, indent + 1, "}");
        }
        this.println(out, indent, "}");
    }

    private void println(PrintStream out, int indent, String string) {
        this.indent(out, indent);
        out.println(string);
    }

    private void indent(PrintStream out, int indent) {
        int i = 0;
        while (i < indent) {
            out.print("  ");
            ++i;
        }
    }

    public static UdigMemento read(InputStream inputStream) throws IOException {
        UdigMemento memento = new UdigMemento();
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        ParserState.OUT.parse(memento, in, null);
        return memento;
    }

    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.write(out, 0);
        return new String(out.toByteArray());
    }

    public static UdigMemento readString(String mementoString) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(mementoString.getBytes());
        return UdigMemento.read(in);
    }

    public String[] getAttributeKeys() {
        return this.m_data.keySet().toArray(new String[0]);
    }

    public Boolean getBoolean(String key) {
        if (this.m_data.containsKey(key)) {
            try {
                return Boolean.parseBoolean(this.m_data.get(key));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    public String getType() {
        return this.m_type;
    }

    public void putBoolean(String key, boolean value) {
        this.m_data.put(key, String.valueOf(value));
    }
}

