/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.memento;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.refractions.udig.project.memento.Tokens;
import net.refractions.udig.project.memento.UdigMemento;

enum ParserState {
    OUT(Tokens._none_){

        @Override
        void parse(UdigMemento memento, BufferedReader reader, String context) throws IOException {
            String line = ParserState.removeWhite(reader.readLine());
            if (line.equals((Object)((Object)Tokens._memento_) + "{")) {
                MEMENTO.parse(memento, reader, null);
            }
        }
    }
    ,
    MEMENTO(Tokens._memento_){

        @Override
        void parse(UdigMemento memento, BufferedReader reader, String context) throws IOException {
            String line = ParserState.removeWhite(reader.readLine());
            while (!line.equals("}")) {
                ParserState[] parserStateArray = ParserState.values();
                int n = parserStateArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ParserState state = parserStateArray[n2];
                    if (line.startsWith(state.token.name())) {
                        state.parse(memento, reader, null);
                        break;
                    }
                    ++n2;
                }
                line = ParserState.removeWhite(reader.readLine());
            }
        }
    }
    ,
    DATA(Tokens._data_){
        final Pattern PATTERN = Pattern.compile("\\s*\\|(.*)\\|.*\\{");

        @Override
        void parse(UdigMemento memento, BufferedReader reader, String context) throws IOException {
            String line = reader.readLine();
            while (!ParserState.removeWhite(line).equals("}")) {
                Matcher matcher = this.PATTERN.matcher(line);
                if (matcher.find()) {
                    String key = ParserState.checkNullToken(matcher.group(1));
                    String value = ParserState.checkNullToken(this.parseValue(reader));
                    memento.putString(key, value);
                }
                line = reader.readLine();
            }
        }
    }
    ,
    CHILDREN(Tokens._children_){

        @Override
        void parse(UdigMemento memento, BufferedReader reader, String context) throws IOException {
            String line = ParserState.removeWhite(reader.readLine());
            while (!line.equals("}")) {
                TYPE.parse(memento, reader, line);
                line = ParserState.removeWhite(reader.readLine());
            }
        }
    }
    ,
    TEXT(Tokens._text_){

        @Override
        void parse(UdigMemento memento, BufferedReader reader, String context) throws IOException {
            memento.putTextData(this.parseValue(reader));
        }
    }
    ,
    TYPE(Tokens._none_){

        @Override
        void parse(UdigMemento memento, BufferedReader reader, String context) throws IOException {
            String typeName = ParserState.checkNullToken(context.substring(0, context.indexOf("{")));
            String line = ParserState.removeWhite(reader.readLine());
            while (!line.equals("}")) {
                if (line.equals((Object)((Object)Tokens._memento_) + "{")) {
                    UdigMemento newMem = memento.createChild(typeName);
                    MEMENTO.parse(newMem, reader, null);
                }
                line = ParserState.removeWhite(reader.readLine());
            }
        }
    };

    private Tokens token;

    private ParserState(Tokens token) {
        this.token = token;
    }

    protected String parseValue(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        StringBuilder val = new StringBuilder();
        boolean isFirst = true;
        while (!ParserState.removeWhite(line).equals("}")) {
            if (isFirst) {
                isFirst = false;
            } else {
                val.append("\n");
            }
            val.append(line);
            line = reader.readLine();
        }
        return val.toString();
    }

    abstract void parse(UdigMemento var1, BufferedReader var2, String var3) throws IOException;

    private static String removeWhite(String line) {
        if (line == null) {
            return "";
        }
        return line.replaceAll("\\s*", "");
    }

    private static String checkNullToken(String value) {
        if (value.equals(Tokens.__null__.name())) {
            value = null;
        }
        return value;
    }

    /* synthetic */ ParserState(String string, int n, Tokens tokens, ParserState parserState) {
        this(tokens);
    }
}

