/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.render.impl;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.aoi.IAOIService;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.render.RenderManager;
import net.refractions.udig.project.internal.render.RenderPackage;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.internal.render.impl.ScaleUtils;
import net.refractions.udig.project.render.IViewportModelListener;
import net.refractions.udig.project.render.ViewportModelEvent;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.render.displayAdapter.MapDisplayEvent;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.ProgressManager;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.joda.time.DateTime;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class ViewportModelImpl
extends EObjectImpl
implements ViewportModel {
    protected static final CoordinateReferenceSystem CRS_EDEFAULT = null;
    protected CoordinateReferenceSystem cRS = DEFAULT_CRS;
    protected boolean cRSESet = false;
    protected static final ReferencedEnvelope BOUNDS_EDEFAULT = NIL_BBOX;
    protected ReferencedEnvelope bounds = BOUNDS_EDEFAULT;
    protected static final Coordinate CENTER_EDEFAULT = null;
    protected static final double HEIGHT_EDEFAULT = 0.0;
    protected static final double WIDTH_EDEFAULT = 0.0;
    protected static final double ASPECT_RATIO_EDEFAULT = 0.0;
    protected static final Coordinate PIXEL_SIZE_EDEFAULT = null;
    protected RenderManager renderManagerInternal;
    protected SortedSet<Double> preferredScaleDenominators;
    private SortedSet<Double> defaultScaleDenominators = null;
    protected EList<DateTime> availableTimesteps;
    protected static final DateTime CURRENT_TIMESTEP_EDEFAULT = null;
    protected DateTime currentTimestep = CURRENT_TIMESTEP_EDEFAULT;
    protected EList<Double> availableElevation;
    protected static final Double CURRENT_ELEVATION_EDEFAULT = null;
    protected Double currentElevation = CURRENT_ELEVATION_EDEFAULT;
    boolean viewer = false;
    private static final double ACCURACY = 1.0E-4;
    private boolean initialized;
    CopyOnWriteArraySet<IViewportModelListener> listeners = new CopyOnWriteArraySet();
    private boolean boundsChanging = false;

    protected ViewportModelImpl() {
    }

    protected EClass eStaticClass() {
        return RenderPackage.Literals.VIEWPORT_MODEL;
    }

    @Override
    public CoordinateReferenceSystem getCRS() {
        return this.cRS;
    }

    @Override
    public void setCRS(CoordinateReferenceSystem newCRS) {
        double scale = this.getScaleDenominator();
        if (newCRS == null) {
            throw new IllegalArgumentException("A CRS cannot be null");
        }
        if (newCRS.equals(this.cRS)) {
            return;
        }
        CoordinateReferenceSystem oldCRS = this.getCRS();
        if (this.getBounds().isNull() || !this.validState()) {
            this.setCRSGen(newCRS);
        } else {
            Coordinate center = this.getCenter();
            DirectPosition2D position = new DirectPosition2D(oldCRS, center.x, center.y);
            try {
                try {
                    this.eSetDeliver(false);
                    this.cRS = newCRS;
                    this.bounds = new ReferencedEnvelope((Envelope)this.bounds, this.cRS);
                    if (oldCRS != DefaultEngineeringCRS.GENERIC_2D && oldCRS != DefaultEngineeringCRS.GENERIC_3D && oldCRS != DefaultEngineeringCRS.CARTESIAN_2D && oldCRS != DefaultEngineeringCRS.CARTESIAN_3D) {
                        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)oldCRS, (CoordinateReferenceSystem)newCRS, (boolean)true);
                        DirectPosition newCenter = transform.transform((DirectPosition)position, (DirectPosition)new DirectPosition2D());
                        this.setCenter(new Coordinate(newCenter.getOrdinate(0), newCenter.getOrdinate(1)));
                        this.setScale(scale);
                    }
                }
                catch (FactoryException e) {
                    throw (RuntimeException)new RuntimeException().initCause(e);
                }
                catch (MismatchedDimensionException e) {
                    throw (RuntimeException)new RuntimeException().initCause(e);
                }
                catch (TransformException e) {
                    throw (RuntimeException)new RuntimeException().initCause(e);
                }
            }
            finally {
                this.eSetDeliver(true);
                this.cRS = oldCRS;
                this.setCRSGen(newCRS);
                this.notifyListeners(new ViewportModelEvent(this, ViewportModelEvent.EventType.CRS, newCRS, oldCRS));
            }
        }
    }

    public void setCRSGen(CoordinateReferenceSystem newCRS) {
        CoordinateReferenceSystem oldCRS = this.cRS;
        this.cRS = newCRS;
        boolean oldCRSESet = this.cRSESet;
        this.cRSESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldCRS, (Object)this.cRS, !oldCRSESet));
        }
    }

    @Override
    public void unsetCRS() {
        CoordinateReferenceSystem oldCRS = this.cRS;
        boolean oldCRSESet = this.cRSESet;
        this.cRS = ViewportModelImpl.getDefaultCRS();
        this.cRSESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 0, (Object)oldCRS, (Object)ViewportModelImpl.getDefaultCRS(), oldCRSESet));
        }
    }

    @Override
    public boolean isSetCRS() {
        return this.cRSESet;
    }

    @Override
    public synchronized ReferencedEnvelope getBounds() {
        if (this.bounds == null) {
            return this.getMapInternal().getBounds(ProgressManager.instance().get(new Object[0]));
        }
        return this.bounds;
    }

    @Override
    public void setBounds(ReferencedEnvelope newBounds) {
        this.setBounds(newBounds, false);
    }

    @Override
    public void setBounds(ReferencedEnvelope newBounds, boolean forceContainBBoxZoom) {
        this.setCRS(newBounds.getCoordinateReferenceSystem());
        this.setBoundsInternal((Envelope)newBounds, forceContainBBoxZoom);
    }

    @Override
    public void setBounds(Envelope newBounds) {
        this.setBoundsInternal(newBounds, false);
    }

    public void setBoundsInternal(Envelope newBounds, boolean forceContainBBoxZoom) {
        Envelope oldBounds;
        Envelope finalBounds = newBounds;
        if (this.getDefaultPreferredScaleDenominators() != this.getPreferredScaleDenominators() && this.validState()) {
            IMapDisplay mapDisplay = this.getRenderManagerInternal().getMapDisplay();
            ReferencedEnvelope referenced = newBounds instanceof ReferencedEnvelope ? (ReferencedEnvelope)newBounds : new ReferencedEnvelope(newBounds, this.getCRS());
            double scale = ScaleUtils.calculateScaleDenominator(referenced, mapDisplay.getDisplaySize(), mapDisplay.getDPI());
            scale = ScaleUtils.calculateClosestScale(this.getPreferredScaleDenominators(), scale, ScaleUtils.zoomClosenessPreference());
            finalBounds = ScaleUtils.calculateBoundsFromScale(scale, mapDisplay.getDisplaySize(), mapDisplay.getDPI(), referenced);
            if (forceContainBBoxZoom && !finalBounds.contains(newBounds)) {
                Iterator tail = this.getPreferredScaleDenominators().tailSet(scale).iterator();
                tail.next();
                Double nextLargest = (Double)tail.next();
                if (nextLargest != null) {
                    finalBounds = ScaleUtils.calculateBoundsFromScale(nextLargest, mapDisplay.getDisplaySize(), mapDisplay.getDPI(), referenced);
                }
            }
        }
        Object object = oldBounds = this.bounds == null ? new Envelope() : this.bounds;
        if (!(this.getBounds().isNull() || Double.isNaN(this.getAspectRatio()) || Double.isNaN(finalBounds.getWidth()) || Double.isNaN(finalBounds.getHeight()))) {
            double nRatio = finalBounds.getWidth() / finalBounds.getHeight();
            if (Double.isNaN(nRatio)) {
                nRatio = 0.0;
            }
            double dRatio = this.getAspectRatio();
            if (this.validState() && Math.abs(nRatio - dRatio) > 1.0E-4) {
                finalBounds.init(finalBounds.getMinX() - 2.0E-7, finalBounds.getMaxX() + 2.0E-7, finalBounds.getMinY(), finalBounds.getMaxY());
                this.zoomToBox(finalBounds);
                return;
            }
        }
        this.bounds = new ReferencedEnvelope(finalBounds, this.getCRS());
        this.fireNotification(oldBounds);
    }

    @Override
    public Coordinate getCenter() {
        return new Coordinate(this.bounds.getMinX() + this.bounds.getWidth() / 2.0, this.bounds.getMinY() + this.bounds.getHeight() / 2.0);
    }

    @Override
    public void setCenter(Coordinate newCenter) {
        double dw = this.getBounds().getWidth() / 2.0;
        double dh = this.getBounds().getHeight() / 2.0;
        this.setBounds(new Envelope(newCenter.x - dw, newCenter.x + dw, newCenter.y - dh, newCenter.y + dh));
    }

    @Override
    public double getHeight() {
        return this.bounds.getHeight();
    }

    @Override
    public void setHeight(double newHeight) {
        this.zoom(this.getHeight() / newHeight);
    }

    @Override
    public double getWidth() {
        return this.getBounds().getWidth();
    }

    @Override
    public void setWidth(double newWidth) {
        this.zoom(this.getWidth() / newWidth);
    }

    @Override
    public double getAspectRatio() {
        if (!this.validState()) {
            return Double.NaN;
        }
        return (double)this.getRenderManagerInternal().getMapDisplay().getWidth() / (double)this.getRenderManagerInternal().getMapDisplay().getHeight();
    }

    private boolean validState() {
        return this.getRenderManagerInternal() != null && this.getRenderManagerInternal().getMapDisplay() != null && this.getRenderManagerInternal().getMapDisplay().getDisplaySize() != null && this.getRenderManagerInternal().getMapDisplay().getWidth() > 0 && this.getRenderManagerInternal().getMapDisplay().getHeight() > 0;
    }

    @Override
    public Map getMapInternal() {
        if (this.eContainerFeatureID() != 7) {
            return null;
        }
        return (Map)this.eContainer();
    }

    public NotificationChain basicSetMapInternal(Map newMapInternal, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newMapInternal, 7, msgs);
        return msgs;
    }

    public void setMapInternalGen(Map newMapInternal) {
        if (newMapInternal != this.eInternalContainer() || this.eContainerFeatureID() != 7 && newMapInternal != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newMapInternal)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newMapInternal != null) {
                msgs = ((InternalEObject)newMapInternal).eInverseAdd((InternalEObject)this, 7, Map.class, msgs);
            }
            if ((msgs = this.basicSetMapInternal(newMapInternal, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)newMapInternal, (Object)newMapInternal));
        }
    }

    public boolean isViewer() {
        return this.viewer;
    }

    public void setViewer(boolean viewer) {
        this.viewer = viewer;
    }

    @Override
    public void setMapInternal(Map newMap) {
        if (this.isViewer()) {
            this.eBasicSetContainer((InternalEObject)newMap, 7);
        } else {
            this.setMapInternalGen(newMap);
        }
    }

    @Override
    public RenderManager getRenderManagerInternal() {
        return this.renderManagerInternal;
    }

    public NotificationChain basicSetRenderManagerInternal(RenderManager newRenderManagerInternal, NotificationChain msgs) {
        RenderManager oldRenderManagerInternal = this.renderManagerInternal;
        this.renderManagerInternal = newRenderManagerInternal;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldRenderManagerInternal, (Object)newRenderManagerInternal);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setRenderManagerInternal(RenderManager newRenderManagerInternal) {
        if (newRenderManagerInternal != this.renderManagerInternal) {
            NotificationChain msgs = null;
            if (this.renderManagerInternal != null) {
                msgs = ((InternalEObject)this.renderManagerInternal).eInverseRemove((InternalEObject)this, 3, RenderManager.class, msgs);
            }
            if (newRenderManagerInternal != null) {
                msgs = ((InternalEObject)newRenderManagerInternal).eInverseAdd((InternalEObject)this, 3, RenderManager.class, msgs);
            }
            if ((msgs = this.basicSetRenderManagerInternal(newRenderManagerInternal, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)newRenderManagerInternal, (Object)newRenderManagerInternal));
        }
    }

    @Override
    public Coordinate getPixelSize() {
        return new Coordinate(this.getXPixelToWorldScale(), this.getYPixelToWorldScale());
    }

    private double getXPixelToWorldScale() {
        if (!this.validState()) {
            return Double.NaN;
        }
        return this.getWidth() / (double)this.getRenderManagerInternal().getMapDisplay().getWidth();
    }

    private double getYPixelToWorldScale() {
        if (!this.validState()) {
            return Double.NaN;
        }
        return this.getHeight() / (double)this.getRenderManagerInternal().getMapDisplay().getHeight();
    }

    @Override
    public void setBounds(double minx, double maxx, double miny, double maxy) {
        this.setBounds(new Envelope(minx, maxx, miny, maxy));
    }

    @Override
    public AffineTransform worldToScreenTransform() {
        if (!this.validState()) {
            return null;
        }
        return this.worldToScreenTransform((Envelope)this.getBounds(), this.getRenderManagerInternal().getMapDisplay().getDisplaySize());
    }

    @Override
    public AffineTransform worldToScreenTransform(Envelope mapExtent, Dimension screenSize) {
        if (!this.validState()) {
            return null;
        }
        return ScaleUtils.worldToScreenTransform(mapExtent, screenSize);
    }

    @Override
    public Point worldToPixel(Coordinate coord) {
        if (!this.validState()) {
            return null;
        }
        return ScaleUtils.worldToPixel(coord, this.getBounds(), this.getRenderManagerInternal().getMapDisplay().getDisplaySize());
    }

    @Override
    public Coordinate pixelToWorld(int x, int y) {
        if (!this.validState()) {
            return null;
        }
        return ScaleUtils.pixelToWorld(x, y, this.getBounds(), this.getRenderManagerInternal().getMapDisplay().getDisplaySize());
    }

    @Override
    public ViewportModel panUsingScreenCoords(int xpixels, int ypixels) {
        if (!this.validState()) {
            return this;
        }
        this.panUsingWorldCoords((double)xpixels * this.getXPixelToWorldScale(), (double)(-ypixels) * this.getYPixelToWorldScale());
        return this;
    }

    @Override
    public ViewportModel panUsingWorldCoords(double x, double y) {
        ReferencedEnvelope bounds = this.getBounds();
        this.setBounds(bounds.getMinX() + x, bounds.getMaxX() + x, bounds.getMinY() + y, bounds.getMaxY() + y);
        return this;
    }

    @Override
    public ViewportModel zoom(double zoom) {
        Coordinate center = this.getCenter();
        this.zoom(zoom, center);
        return this;
    }

    @Override
    public ViewportModel zoom(double zoom, Coordinate fixedPoint) {
        if (fixedPoint == null) {
            fixedPoint = this.getCenter();
        }
        double effectiveZoom = zoom;
        AffineTransform transformer = ScaleUtils.createScaleTransformWithFixedPoint(effectiveZoom, fixedPoint);
        ReferencedEnvelope srcEnvelope = this.getBounds();
        Envelope transformedEnvelope = ScaleUtils.transformEnvelope(srcEnvelope, transformer);
        this.setBounds(transformedEnvelope);
        return this;
    }

    @Override
    public void zoomToExtent() {
        try {
            if (!this.validState()) {
                return;
            }
            ReferencedEnvelope bounds2 = new ReferencedEnvelope(this.getCRS());
            IAOIService aOIService = PlatformGIS.getAOIService();
            ReferencedEnvelope extent = aOIService.getExtent();
            if (extent != null && !extent.isNull() && !extent.isEmpty()) {
                bounds2 = new ReferencedEnvelope(extent);
            } else {
                boolean hasVisibleLayer = false;
                List<ILayer> layers = this.getMap().getMapLayers();
                for (ILayer layer : layers) {
                    ReferencedEnvelope layerBounds = layer.getBounds(ProgressManager.instance().get(new Object[0]), this.getCRS());
                    if (!layer.isVisible() || layerBounds.isNull()) continue;
                    hasVisibleLayer = true;
                    ReferencedEnvelope fitted = ScaleUtils.fitToMinAndMax(layerBounds, layer);
                    if (fitted.getCoordinateReferenceSystem() == bounds2.getCoordinateReferenceSystem()) {
                        bounds2.expandToInclude((Envelope)fitted);
                        continue;
                    }
                    if (bounds2.getCoordinateReferenceSystem() != layerBounds.getCoordinateReferenceSystem()) continue;
                    bounds2.expandToInclude((Envelope)layerBounds);
                }
                if (!hasVisibleLayer) {
                    bounds2 = this.getMap().getBounds(ProgressManager.instance().get(new Object[0]));
                }
            }
            if (bounds2.getCoordinateReferenceSystem() == null || this.getCRS() == null || bounds2.getCoordinateReferenceSystem().equals(this.getCRS())) {
                this.zoomToBox((Envelope)bounds2);
            } else {
                MathTransform transform = null;
                transform = CRS.findMathTransform((CoordinateReferenceSystem)bounds2.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)this.getCRS(), (boolean)true);
                this.zoomToBox(JTS.transform((Envelope)bounds2, (MathTransform)transform));
            }
        }
        catch (FactoryException factoryException) {
            this.zoomToBox(new Envelope(-180.0, 180.0, -90.0, 90.0));
        }
        catch (TransformException transformException) {
            this.zoomToBox(new Envelope(-180.0, 180.0, -90.0, 90.0));
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (cRS: ");
        if (this.cRSESet) {
            result.append(this.cRS);
        } else {
            result.append("<unset>");
        }
        result.append(", bounds: ");
        result.append(this.bounds);
        result.append(", preferredScaleDenominators: ");
        result.append(this.preferredScaleDenominators);
        result.append(", availableTimesteps: ");
        result.append(this.availableTimesteps);
        result.append(", currentTimestep: ");
        result.append(this.currentTimestep);
        result.append(", availableElevation: ");
        result.append(this.availableElevation);
        result.append(", currentElevation: ");
        result.append(this.currentElevation);
        result.append(')');
        return result.toString();
    }

    @Override
    public void sizeChanged(final MapDisplayEvent event) {
        if (event.getSize().width < 1 || event.getSize().height < 1) {
            return;
        }
        Runnable handler = new Runnable(){

            @Override
            public void run() {
                ReferencedEnvelope oldBounds = ViewportModelImpl.this.getBounds();
                if (ViewportModelImpl.this.newSizeIsSmaller(event)) {
                    ViewportModelImpl.this.calculateNewBounds(event, (Envelope)oldBounds);
                    return;
                }
                if (oldBounds.isNull()) {
                    ViewportModelImpl.this.zoomToExtent();
                } else if (ViewportModelImpl.this.oldSizeIsValid(event)) {
                    ViewportModelImpl.this.calculateNewBounds(event, (Envelope)oldBounds);
                    ViewportModelImpl.this.fireNotification((Envelope)oldBounds);
                } else {
                    ViewportModelImpl.this.zoomToBox((Envelope)ViewportModelImpl.this.getBounds());
                }
            }
        };
        if (Display.getCurrent() != null) {
            Thread thread = new Thread(handler);
            thread.setDaemon(true);
            thread.start();
        } else {
            handler.run();
        }
    }

    private void fireNotification(Envelope oldBounds) {
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldBounds, (Object)this.bounds));
            this.notifyListeners(new ViewportModelEvent(this, ViewportModelEvent.EventType.BOUNDS, this.bounds, oldBounds));
        }
    }

    private void calculateNewBounds(MapDisplayEvent event, Envelope oldBounds) {
        double oldXscale = this.getWidth() / (double)event.getOldSize().width;
        double oldYscale = this.getHeight() / (double)event.getOldSize().height;
        double minx = oldBounds.getMinX();
        double maxy = oldBounds.getMaxY();
        double maxx = minx + (double)event.getSize().width * oldXscale;
        double miny = maxy - (double)event.getSize().height * oldYscale;
        this.bounds = new ReferencedEnvelope(minx, maxx, miny, maxy, this.getCRS());
    }

    private boolean oldSizeIsValid(MapDisplayEvent event) {
        return event.getOldSize() != null && event.getOldSize().width != 0 && event.getOldSize().height != 0;
    }

    private boolean newSizeIsSmaller(MapDisplayEvent event) {
        if (event.getOldSize() == null) {
            return false;
        }
        return event.getOldSize().width > event.getSize().width && event.getOldSize().height > event.getSize().height;
    }

    @Override
    public void zoomToBox(Envelope newbbox) {
        this.setInitialized(true);
        if (Math.abs(newbbox.getWidth() / newbbox.getHeight() - this.getAspectRatio()) > 1.0E-4) {
            IMapDisplay display = this.getRenderManagerInternal().getMapDisplay();
            double scaley = newbbox.getHeight() / (double)display.getHeight();
            double scalex = newbbox.getWidth() / (double)display.getWidth();
            double scale = scalex > scaley ? scalex : scaley;
            double height = (double)display.getHeight() * scale;
            double width = (double)display.getWidth() * scale;
            double dw = width / 2.0;
            double dh = height / 2.0;
            Envelope mapBounds = newbbox;
            double x = (mapBounds.getMaxX() + mapBounds.getMinX()) / 2.0;
            double y = (mapBounds.getMaxY() + mapBounds.getMinY()) / 2.0;
            newbbox.init(x - dw, x + dw, y - dh, y + dh);
        }
        this.setBounds(newbbox);
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetMapInternal((Map)otherEnd, msgs);
            }
            case 8: {
                if (this.renderManagerInternal != null) {
                    msgs = ((InternalEObject)this.renderManagerInternal).eInverseRemove((InternalEObject)this, 3, RenderManager.class, msgs);
                }
                return this.basicSetRenderManagerInternal((RenderManager)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                return this.basicSetMapInternal(null, msgs);
            }
            case 8: {
                return this.basicSetRenderManagerInternal(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 7: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 7, Map.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getCRS();
            }
            case 1: {
                return this.getBounds();
            }
            case 2: {
                return this.getCenter();
            }
            case 3: {
                return this.getHeight();
            }
            case 4: {
                return this.getWidth();
            }
            case 5: {
                return this.getAspectRatio();
            }
            case 6: {
                return this.getPixelSize();
            }
            case 7: {
                return this.getMapInternal();
            }
            case 8: {
                return this.getRenderManagerInternal();
            }
            case 9: {
                return this.getPreferredScaleDenominators();
            }
            case 10: {
                return this.getAvailableTimesteps();
            }
            case 11: {
                return this.getCurrentTimestep();
            }
            case 12: {
                return this.getAvailableElevation();
            }
            case 13: {
                return this.getCurrentElevation();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setCRS((CoordinateReferenceSystem)newValue);
                return;
            }
            case 1: {
                this.setBounds((ReferencedEnvelope)newValue);
                return;
            }
            case 2: {
                this.setCenter((Coordinate)newValue);
                return;
            }
            case 3: {
                this.setHeight((Double)newValue);
                return;
            }
            case 4: {
                this.setWidth((Double)newValue);
                return;
            }
            case 7: {
                this.setMapInternal((Map)newValue);
                return;
            }
            case 8: {
                this.setRenderManagerInternal((RenderManager)newValue);
                return;
            }
            case 9: {
                this.setPreferredScaleDenominators((SortedSet)newValue);
                return;
            }
            case 10: {
                this.getAvailableTimesteps().clear();
                this.getAvailableTimesteps().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.setCurrentTimestep((DateTime)newValue);
                return;
            }
            case 12: {
                this.getAvailableElevation().clear();
                this.getAvailableElevation().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.setCurrentElevation((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.unsetCRS();
                return;
            }
            case 1: {
                this.setBounds(BOUNDS_EDEFAULT);
                return;
            }
            case 2: {
                this.setCenter(CENTER_EDEFAULT);
                return;
            }
            case 3: {
                this.setHeight(0.0);
                return;
            }
            case 4: {
                this.setWidth(0.0);
                return;
            }
            case 7: {
                this.setMapInternal(null);
                return;
            }
            case 8: {
                this.setRenderManagerInternal(null);
                return;
            }
            case 9: {
                this.setPreferredScaleDenominators(null);
                return;
            }
            case 10: {
                this.getAvailableTimesteps().clear();
                return;
            }
            case 11: {
                this.setCurrentTimestep(CURRENT_TIMESTEP_EDEFAULT);
                return;
            }
            case 12: {
                this.getAvailableElevation().clear();
                return;
            }
            case 13: {
                this.setCurrentElevation(CURRENT_ELEVATION_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.isSetCRS();
            }
            case 1: {
                return BOUNDS_EDEFAULT == null ? this.bounds != null : !BOUNDS_EDEFAULT.equals((Object)this.bounds);
            }
            case 2: {
                return CENTER_EDEFAULT == null ? this.getCenter() != null : !CENTER_EDEFAULT.equals((Object)this.getCenter());
            }
            case 3: {
                return this.getHeight() != 0.0;
            }
            case 4: {
                return this.getWidth() != 0.0;
            }
            case 5: {
                return this.getAspectRatio() != 0.0;
            }
            case 6: {
                return PIXEL_SIZE_EDEFAULT == null ? this.getPixelSize() != null : !PIXEL_SIZE_EDEFAULT.equals((Object)this.getPixelSize());
            }
            case 7: {
                return this.getMapInternal() != null;
            }
            case 8: {
                return this.renderManagerInternal != null;
            }
            case 9: {
                return this.preferredScaleDenominators != null;
            }
            case 10: {
                return this.availableTimesteps != null && !this.availableTimesteps.isEmpty();
            }
            case 11: {
                return CURRENT_TIMESTEP_EDEFAULT == null ? this.currentTimestep != null : !CURRENT_TIMESTEP_EDEFAULT.equals((Object)this.currentTimestep);
            }
            case 12: {
                return this.availableElevation != null && !this.availableElevation.isEmpty();
            }
            case 13: {
                return CURRENT_ELEVATION_EDEFAULT == null ? this.currentElevation != null : !CURRENT_ELEVATION_EDEFAULT.equals(this.currentElevation);
            }
        }
        return super.eIsSet(featureID);
    }

    public static CoordinateReferenceSystem getDefaultCRS() {
        try {
            ScopedPreferenceStore store = ProjectPlugin.getPlugin().getPreferenceStore();
            int i = store.getInt("defaultCRSPreference");
            if (i == -1) {
                return CRS.decode((String)"EPSG:4326");
            }
            return CRS.decode((String)("EPSG:" + i));
        }
        catch (FactoryException factoryException) {
            return ViewportModel.BAD_DEFAULT;
        }
    }

    public void setFiringEvents(boolean firing) {
        this.eFlags = firing ? (this.eFlags |= 1) : (this.eFlags &= 0xFFFFFFFE);
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Override
    public IMap getMap() {
        return this.getMapInternal();
    }

    @Override
    public double getScaleDenominator() {
        if (!this.validState()) {
            return -1.0;
        }
        RenderManager renderManager = this.getRenderManagerInternal();
        ReferencedEnvelope bounds2 = this.getBounds();
        if (renderManager == null || renderManager.getMapDisplay() == null) {
            return -1.0;
        }
        IMapDisplay display = renderManager.getMapDisplay();
        return ScaleUtils.calculateScaleDenominator(bounds2, display.getDisplaySize(), display.getDPI());
    }

    @Override
    public synchronized SortedSet<Double> getDefaultPreferredScaleDenominators() {
        if (this.defaultScaleDenominators == null) {
            TreeSet<Double> scales = new TreeSet<Double>();
            scales.add(1000000.0);
            scales.add(100000.0);
            scales.add(50000.0);
            scales.add(20000.0);
            scales.add(10000.0);
            scales.add(5000.0);
            scales.add(2500.0);
            scales.add(1000.0);
            this.defaultScaleDenominators = Collections.unmodifiableSortedSet(scales);
        }
        return this.defaultScaleDenominators;
    }

    @Override
    public SortedSet<Double> getPreferredScaleDenominators() {
        if (this.preferredScaleDenominators == null) {
            return this.getDefaultPreferredScaleDenominators();
        }
        return this.preferredScaleDenominators;
    }

    @Override
    public void setPreferredScaleDenominators(SortedSet<Double> newPreferredScaleDenominators) {
        SortedSet<Double> oldPreferredScaleDenominators = this.preferredScaleDenominators;
        this.preferredScaleDenominators = newPreferredScaleDenominators == this.getDefaultPreferredScaleDenominators() ? null : Collections.unmodifiableSortedSet(new TreeSet<Double>(newPreferredScaleDenominators));
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldPreferredScaleDenominators, this.preferredScaleDenominators));
        }
    }

    @Override
    public List<DateTime> getAvailableTimesteps() {
        if (this.availableTimesteps == null) {
            this.availableTimesteps = new EDataTypeUniqueEList(DateTime.class, (InternalEObject)this, 10);
        }
        return this.availableTimesteps;
    }

    @Override
    public DateTime getCurrentTimestep() {
        return this.currentTimestep;
    }

    @Override
    public void setCurrentTimestep(DateTime newCurrentTimestep) {
        DateTime oldCurrentTimestep = this.currentTimestep;
        this.currentTimestep = newCurrentTimestep;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldCurrentTimestep, (Object)this.currentTimestep));
        }
    }

    @Override
    public List<Double> getAvailableElevation() {
        if (this.availableElevation == null) {
            this.availableElevation = new EDataTypeUniqueEList(Double.class, (InternalEObject)this, 12);
        }
        return this.availableElevation;
    }

    @Override
    public Double getCurrentElevation() {
        return this.currentElevation;
    }

    @Override
    public void setCurrentElevation(Double newCurrentElevation) {
        Double oldCurrentElevation = this.currentElevation;
        this.currentElevation = newCurrentElevation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldCurrentElevation, (Object)this.currentElevation));
        }
    }

    @Override
    public void setScale(double scaleDenominator) {
        RenderManager rm = this.getRenderManagerInternal();
        IMapDisplay display = rm.getMapDisplay();
        ReferencedEnvelope newExtents = ScaleUtils.calculateBoundsFromScale(scaleDenominator, display.getDisplaySize(), display.getDPI(), this.getBounds());
        this.setWidth(newExtents.getWidth());
    }

    @Override
    public void setScale(double scaleDenominator, int dpi, int displayWidth, int displayHeight) {
        ReferencedEnvelope newExtents = ScaleUtils.calculateBoundsFromScale(scaleDenominator, new Dimension(displayWidth, displayHeight), dpi, this.getBounds());
        this.setWidth(newExtents.getWidth());
    }

    @Override
    public void addViewportModelListener(IViewportModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeViewportModelListener(IViewportModelListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(ViewportModelEvent event) {
        for (IViewportModelListener listener : this.listeners) {
            try {
                listener.changed(event);
            }
            catch (Throwable t) {
                ProjectPlugin.log("", t);
            }
        }
    }

    @Override
    public void setIsBoundsChanging(boolean changing) {
        this.boundsChanging = changing;
    }

    @Override
    public boolean isBoundsChanging() {
        return this.boundsChanging;
    }
}

