/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.render.impl;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.render.RenderContext;
import net.refractions.udig.project.internal.render.Renderer;
import net.refractions.udig.project.internal.render.RendererDecorator;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.RenderException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.geotools.data.FeatureStore;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class TilingRenderer
implements Renderer,
RendererDecorator {
    private static final double SIGNIFICANT = 1.0E-4;
    protected Renderer child;
    protected ViewportModel oldViewport;
    protected Dimension oldDisplaySize;
    protected int dScreenW;
    protected int dScreenH;
    protected Envelope paintedAreaInWorld;

    public TilingRenderer(Renderer child) {
        this.child = child;
    }

    @Override
    public void render(IProgressMonitor monitor) throws RenderException {
        ScopedPreferenceStore store = ProjectPlugin.getPlugin().getPreferenceStore();
        boolean useTiling = store.getBoolean("tilingRendererActivated");
        if (this.getContext().getGeoResource().canResolve(FeatureStore.class) || !useTiling) {
            Envelope renderBounds = this.getRenderBounds();
            if (renderBounds == null) {
                this.getContext().clearImage();
            } else {
                Point min = this.getContext().worldToPixel(new Coordinate(renderBounds.getMinX(), renderBounds.getMinY()));
                Point max = this.getContext().worldToPixel(new Coordinate(renderBounds.getMaxX(), renderBounds.getMaxY()));
                int width = Math.abs(max.x - min.x);
                int height = Math.abs(max.y - min.y);
                Rectangle paintArea = new Rectangle(Math.min(min.x, max.x), Math.min(min.y, max.y), width, height);
                this.getContext().clearImage(paintArea);
            }
            this.child.render(monitor);
        } else {
            this.checkState();
            this.setNewState();
            this.cacheRenderedImage();
            this.drawCachedTiles();
            this.approximateMissingTiles();
            this.drawNeededTiles(monitor);
            if (monitor.isCanceled()) {
                this.oldViewport = null;
                return;
            }
            this.oldViewport = (ViewportModel)EcoreUtil.copy((EObject)this.getContext().getViewportModelInternal());
            this.oldDisplaySize = this.getContext().getMapDisplay().getDisplaySize();
        }
    }

    private void drawNeededTiles(IProgressMonitor monitor) throws RenderException {
        ReferencedEnvelope currentBounds = this.getContext().getViewportModel().getBounds();
        if (this.paintedAreaInWorld.isNull()) {
            this.child.render(monitor);
            return;
        }
        if (currentBounds.getHeight() - this.paintedAreaInWorld.getHeight() > currentBounds.getWidth() - this.paintedAreaInWorld.getWidth()) {
            this.renderY(monitor, (Envelope)currentBounds, currentBounds.getMinX(), currentBounds.getMaxX());
            this.renderX(monitor, (Envelope)currentBounds, this.paintedAreaInWorld.getMinY(), this.paintedAreaInWorld.getMaxY());
        } else {
            this.renderX(monitor, (Envelope)currentBounds, currentBounds.getMinY(), currentBounds.getMaxY());
            this.update();
            this.renderY(monitor, (Envelope)currentBounds, this.paintedAreaInWorld.getMinX(), this.paintedAreaInWorld.getMaxX());
        }
    }

    private void renderX(IProgressMonitor monitor, Envelope currentBounds, double miny, double maxy) throws RenderException {
        if (this.paintedAreaInWorld.getWidth() < currentBounds.getWidth()) {
            double maxx;
            double minx;
            if (this.paintedAreaInWorld.getMinX() <= currentBounds.getMinX()) {
                minx = currentBounds.getMaxX();
                maxx = this.paintedAreaInWorld.getMaxX();
            } else {
                minx = currentBounds.getMinX();
                maxx = this.paintedAreaInWorld.getMinX();
            }
            Envelope envelope = new Envelope(minx, maxx, miny, maxy);
            if (this.validEnvelope(envelope)) {
                this.child.setRenderBounds(envelope);
                this.child.render(monitor);
            }
        }
    }

    private void renderY(IProgressMonitor monitor, Envelope currentBounds, double minx, double maxx) throws RenderException {
        if (this.paintedAreaInWorld.getHeight() < currentBounds.getHeight()) {
            double maxy;
            double miny;
            if (this.paintedAreaInWorld.getMinY() <= currentBounds.getMinY()) {
                miny = currentBounds.getMaxY();
                maxy = this.paintedAreaInWorld.getMaxY();
            } else {
                miny = currentBounds.getMinY();
                maxy = this.paintedAreaInWorld.getMinY();
            }
            Envelope envelope = new Envelope(minx, maxx, miny, maxy);
            if (this.validEnvelope(envelope)) {
                this.child.setRenderBounds(envelope);
                this.child.render(monitor);
            }
        }
    }

    protected boolean validEnvelope(Envelope envelope) {
        Point lower = this.getContext().worldToPixel(new Coordinate(envelope.getMinX(), envelope.getMinY()));
        Point upper = this.getContext().worldToPixel(new Coordinate(envelope.getMaxX(), envelope.getMaxY()));
        return lower.x != upper.x && lower.y != upper.y;
    }

    private void update() {
        this.setState(2);
    }

    private void approximateMissingTiles() {
    }

    private void drawCachedTiles() {
        if (this.getState() == 1 || this.getState() == 16 || this.getState() == 2) {
            this.getContext().clearImage();
        } else if (!this.isZoomChanged()) {
            this.panImage();
        } else {
            this.getContext().clearImage();
        }
    }

    protected void panImage() {
        if (this.oldViewport == null) {
            return;
        }
        ProjectPlugin.trace("net.refractions.udig.project/debug/render/trace", this.getClass(), "Panning existing image", null);
        ReferencedEnvelope current = this.getContext().getViewportModel().getBounds();
        ReferencedEnvelope old = this.oldViewport.getBounds();
        if (old.equals((Object)current)) {
            return;
        }
        double worldPaintedMinX = old.getMinX();
        double worldPaintedMinY = old.getMinY();
        double worldPaintedMaxX = current.getMaxX();
        double worldPaintedMaxY = current.getMaxY();
        if (Math.abs(old.getMinX() - current.getMinX()) > 1.0E-4) {
            if (old.getMinX() > current.getMinX()) {
                worldPaintedMinX = current.getMaxX();
                worldPaintedMaxX = old.getMinX();
            } else {
                worldPaintedMinX = current.getMinX();
                worldPaintedMaxX = old.getMaxX();
            }
        }
        if (Math.abs(old.getMinY() - current.getMinY()) > 1.0E-4) {
            if (old.getMinY() > current.getMinY()) {
                worldPaintedMinY = old.getMinY();
                worldPaintedMaxY = current.getMaxY();
            } else {
                worldPaintedMinY = current.getMinY();
                worldPaintedMaxY = old.getMaxY();
            }
        }
        this.paintedAreaInWorld = new Envelope(worldPaintedMinX, worldPaintedMaxX, worldPaintedMinY, worldPaintedMaxY);
        AffineTransform at = this.getContext().worldToScreenTransform();
        double[] points = new double[]{old.getMinX(), old.getMaxY()};
        at.transform(points, 0, points, 0, 1);
        double oldminx = points[0];
        double oldminy = points[1];
        BufferedImage image = new BufferedImage(this.oldDisplaySize.width, this.oldDisplaySize.height, 6);
        image.createGraphics().drawImage((Image)this.getContext().getImage(), 0, 0, null);
        this.getContext().clearImage();
        Graphics2D graphics = this.getContext().getImage().createGraphics();
        AffineTransform transform = AffineTransform.getTranslateInstance(oldminx, oldminy);
        graphics.drawRenderedImage(image, transform);
        graphics.dispose();
    }

    private void cacheRenderedImage() {
    }

    private void setNewState() {
        this.paintedAreaInWorld = new Envelope();
    }

    private void checkState() {
        if (this.getState() == 8) {
            throw new IllegalStateException(Messages.TilingRenderer_disposedError);
        }
    }

    @Override
    public void render(Graphics2D graphics, IProgressMonitor monitor) throws RenderException {
        this.checkState();
        this.child.render(graphics, monitor);
    }

    boolean isZoomChanged() {
        Dimension displaySize = this.getContext().getRenderManager().getMapDisplay().getDisplaySize();
        if (this.oldViewport == null) {
            return true;
        }
        ReferencedEnvelope old = this.oldViewport.getBounds();
        ReferencedEnvelope curr = this.getContext().getViewportModel().getBounds();
        if (!displaySize.equals(this.oldDisplaySize)) {
            this.dScreenW = displaySize.width - this.oldDisplaySize.width;
            this.dScreenH = displaySize.height - this.oldDisplaySize.height;
        } else {
            this.dScreenW = -1;
            this.dScreenH = -1;
        }
        if (Math.abs(old.getWidth() - curr.getWidth()) > 1.0E-4 && this.dScreenH == -1 && this.dScreenW == -1) {
            return true;
        }
        return Math.abs(old.getHeight() - curr.getHeight()) > 1.0E-4 && this.dScreenH == -1 && this.dScreenW == -1;
    }

    @Override
    public RenderContext getContext() {
        return (RenderContext)this.child.getContext();
    }

    @Override
    public void dispose() {
        this.checkState();
        this.purgeImageCache();
        this.child.dispose();
        this.setState(8);
    }

    private void purgeImageCache() {
    }

    @Override
    public Renderer getRenderer() {
        return this.child;
    }

    public String toString() {
        return this.child.toString();
    }

    public EList eAdapters() {
        return this.child.eAdapters();
    }

    @Override
    public int getState() {
        return this.child.getState();
    }

    @Override
    public void setState(int newState) {
        this.child.setState(newState);
    }

    @Override
    public String getName() {
        return this.child.getName();
    }

    @Override
    public void setName(String value) {
        this.child.setName(value);
    }

    @Override
    public void setContext(IRenderContext context) {
        this.child.setContext(context);
    }

    public EClass eClass() {
        return this.child.eClass();
    }

    public Resource eResource() {
        return this.child.eResource();
    }

    public EObject eContainer() {
        return this.child.eContainer();
    }

    public EStructuralFeature eContainingFeature() {
        return this.child.eContainingFeature();
    }

    public EReference eContainmentFeature() {
        return this.child.eContainmentFeature();
    }

    public EList eContents() {
        return this.child.eContents();
    }

    public TreeIterator eAllContents() {
        return this.child.eAllContents();
    }

    public boolean eIsProxy() {
        return this.child.eIsProxy();
    }

    public EList eCrossReferences() {
        return this.child.eCrossReferences();
    }

    public Object eInvoke(EOperation operation, EList<?> arguments) throws InvocationTargetException {
        return this.child.eInvoke(operation, arguments);
    }

    public Object eGet(EStructuralFeature feature) {
        return this.child.eGet(feature);
    }

    public Object eGet(EStructuralFeature feature, boolean resolve) {
        return this.child.eGet(feature, resolve);
    }

    public void eSet(EStructuralFeature feature, Object newValue) {
        this.child.eSet(feature, newValue);
    }

    public boolean eIsSet(EStructuralFeature feature) {
        return this.child.eIsSet(feature);
    }

    public void eUnset(EStructuralFeature feature) {
        this.child.eUnset(feature);
    }

    public boolean eDeliver() {
        return this.child.eDeliver();
    }

    public void eSetDeliver(boolean deliver) {
        this.child.eSetDeliver(deliver);
    }

    public void eNotify(Notification notification) {
        this.child.eNotify(notification);
    }

    @Override
    public boolean isCacheable() {
        return this.child.isCacheable();
    }

    @Override
    public Envelope getRenderBounds() {
        return this.child.getRenderBounds();
    }

    @Override
    public void setRenderBounds(Envelope boundsToRender) {
        this.child.setRenderBounds(boundsToRender);
    }

    @Override
    public void setRenderBounds(Rectangle screenArea) {
        this.child.setRenderBounds(screenArea);
    }
}

