/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.render.impl;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.render.CompositeRenderContext;
import net.refractions.udig.project.internal.render.MultiLayerRenderer;
import net.refractions.udig.project.internal.render.RenderExecutor;
import net.refractions.udig.project.internal.render.RenderFactory;
import net.refractions.udig.project.internal.render.RenderListenerAdapter;
import net.refractions.udig.project.internal.render.Renderer;
import net.refractions.udig.project.internal.render.SelectionLayer;
import net.refractions.udig.project.internal.render.impl.CompositeRendererImpl;
import net.refractions.udig.project.internal.render.impl.RenderContextImpl;
import net.refractions.udig.project.render.AbstractRenderMetrics;
import net.refractions.udig.project.render.ILabelPainter;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.RenderException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class TiledCompositeRendererImpl
extends CompositeRendererImpl
implements MultiLayerRenderer {
    private static final Comparator<? super RenderExecutor> comparator = new Comparator<RenderExecutor>(){

        @Override
        public int compare(RenderExecutor e1, RenderExecutor e2) {
            return e1.getContext().getLayer().compareTo(e2.getContext().getLayer());
        }
    };
    private final Set<RenderInfo> childrenRenderers = new HashSet<RenderInfo>();

    protected TiledCompositeRendererImpl() {
    }

    public List<RenderInfo> getChildren() {
        ArrayList<RenderInfo> children = new ArrayList<RenderInfo>();
        for (RenderInfo victim : this.childrenRenderers) {
            children.add(victim);
        }
        return children;
    }

    public List<AbstractRenderMetrics> getChildrenMetrics() {
        ArrayList<AbstractRenderMetrics> children = new ArrayList<AbstractRenderMetrics>();
        for (RenderInfo victim : this.childrenRenderers) {
            children.add(victim.getMetrics());
        }
        return children;
    }

    @Override
    protected RenderExecutor createRenderExecutor(Renderer renderer) {
        final RenderExecutor executor = RenderFactory.eINSTANCE.createRenderExecutor(renderer);
        executor.eAdapters().add((Object)new RenderListenerAdapter(){

            @Override
            protected void renderDisposed(Notification msg) {
                EObject obj = (EObject)this.getTarget();
                obj.eAdapters().remove((Object)this);
            }

            @Override
            protected void renderDone() {
                TiledCompositeRendererImpl.this.setState(4);
            }

            @Override
            protected void renderRequest() {
                TiledCompositeRendererImpl.this.setRenderBounds(executor.getRenderBounds());
                TiledCompositeRendererImpl.this.setState(16);
            }

            @Override
            protected void renderStarting() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void renderUpdate() {
                TiledCompositeRendererImpl tiledCompositeRendererImpl = TiledCompositeRendererImpl.this;
                synchronized (tiledCompositeRendererImpl) {
                    TiledCompositeRendererImpl.this.setState(2);
                }
            }
        });
        return executor;
    }

    @Override
    public synchronized void dispose() {
        for (RenderInfo renderer : this.childrenRenderers) {
            renderer.getExecutor().dispose();
        }
        this.childrenRenderers.clear();
    }

    @Override
    public CompositeRenderContext getContext() {
        return super.getContext();
    }

    public void setContext(CompositeRenderContext context) {
        super.setContext(context);
    }

    @Override
    public IRenderContext getIContext() {
        throw new UnsupportedOperationException("Cannot get the context for a tile composite thing.");
    }

    @Override
    public Collection<RenderExecutor> getRenderExecutors() {
        ArrayList<RenderExecutor> executors = new ArrayList<RenderExecutor>();
        for (RenderInfo renderExecutor : this.childrenRenderers) {
            executors.add(renderExecutor.getExecutor());
        }
        return executors;
    }

    private boolean isFullAlphaUsed(RenderExecutor executor) {
        Object object = this.getContext().getMap().getBlackboard().get("MYLAR");
        if (object == null || !((Boolean)object).booleanValue()) {
            return true;
        }
        if (executor.getContext() instanceof CompositeRenderContext) {
            CompositeRenderContext context = (CompositeRenderContext)executor.getContext();
            return context.getLayers().contains(this.getContext().getSelectedLayer());
        }
        return executor.getContext().getLayer() == this.getContext().getSelectedLayer();
    }

    @Override
    public void refreshImage() throws RenderException {
        this.refreshImage(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void refreshImage(boolean paintLabels) throws RenderException {
        if (this.getContext().getMapDisplay() == null) {
            return;
        }
        CompositeRenderContext compositeRenderContext = this.getContext();
        synchronized (compositeRenderContext) {
            Graphics g = null;
            try {
                try {
                    TreeSet<? super RenderExecutor> executors;
                    Object background;
                    BufferedImage current = this.getContext().getImage();
                    BufferedImage copy = new BufferedImage(current.getWidth(), current.getHeight(), current.getType());
                    g = (Graphics2D)copy.getGraphics();
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    IMap map = this.getContext().getMap();
                    Object object = map.getBlackboard().get("mapBackgroundColor");
                    if (object == null) {
                        ScopedPreferenceStore store = ProjectPlugin.getPlugin().getPreferenceStore();
                        background = PreferenceConverter.getColor((IPreferenceStore)store, (String)"backgroundColor");
                        map.getBlackboard().put("mapBackgroundColor", new Color(background.red, background.green, background.blue));
                        object = map.getBlackboard().get("mapBackgroundColor");
                    }
                    ((Graphics2D)g).setBackground((Color)object);
                    g.clearRect(0, 0, copy.getWidth(), copy.getHeight());
                    background = this.childrenRenderers;
                    synchronized (background) {
                        executors = new TreeSet<RenderExecutor>(comparator);
                        executors.addAll(this.getRenderExecutors());
                    }
                    ILabelPainter cache = this.getContext().getLabelPainter();
                    for (RenderExecutor renderExecutor : executors) {
                        if (!renderExecutor.getContext().isVisible()) {
                            if (!paintLabels || renderExecutor.getContext().getLayer() instanceof SelectionLayer) continue;
                            cache.disableLayer(renderExecutor.getContext().getLayer().getID().toString());
                            continue;
                        }
                        if (renderExecutor.getState() == 1 || renderExecutor.getState() == 32 || renderExecutor.getState() == 16) continue;
                        if (this.isFullAlphaUsed(renderExecutor)) {
                            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 1.0f));
                        } else {
                            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.5f));
                        }
                        ((Graphics2D)g).drawRenderedImage(renderExecutor.getContext().getImage(), IDENTITY);
                    }
                    if (paintLabels) {
                        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        ((Graphics2D)g).setRenderingHints(renderingHints);
                        Dimension displaySize = this.getContext().getImageSize();
                        cache.end((Graphics2D)g, new Rectangle(displaySize));
                    }
                    ((RenderContextImpl)((Object)this.getContext())).setImage(copy);
                }
                catch (IllegalStateException illegalStateException) {
                    this.stopRendering();
                    if (g != null) {
                        g.dispose();
                    }
                    return;
                }
            }
            finally {
                if (g != null) {
                    g.dispose();
                }
            }
        }
    }

    @Override
    public void render(Graphics2D destination, IProgressMonitor monitor) throws RenderException {
        for (RenderInfo renderinfo : this.childrenRenderers) {
            renderinfo.getRenderer().setState(32);
        }
        for (RenderInfo renderinfo : this.childrenRenderers) {
            renderinfo.getExecutor().render();
        }
    }

    @Override
    public void render(IProgressMonitor monitor) throws RenderException {
        if (this.childrenRenderers.size() == 0) {
            this.setState(4);
        }
        for (RenderInfo renderinfo : this.childrenRenderers) {
            renderinfo.getExecutor().setRenderBounds((Envelope)this.getRenderBounds());
            renderinfo.getExecutor().render();
        }
    }

    @Override
    public void stopRendering() {
        for (RenderExecutor element : this.getRenderExecutors()) {
            element.stopRendering();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(AbstractRenderMetrics childtoremove) {
        ArrayList<RenderInfo> toRemove = new ArrayList<RenderInfo>();
        Set<RenderInfo> set = this.childrenRenderers;
        synchronized (set) {
            for (RenderInfo child : this.childrenRenderers) {
                if (!child.getMetrics().equals(childtoremove)) continue;
                child.getExecutor().dispose();
                toRemove.add(child);
            }
        }
        this.childrenRenderers.removeAll(toRemove);
    }

    public void removeChildren(Collection<AbstractRenderMetrics> childrentoremove) {
        for (AbstractRenderMetrics child : childrentoremove) {
            this.removeChild(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllChildren() {
        ArrayList<RenderInfo> toRemove = new ArrayList<RenderInfo>();
        Set<RenderInfo> set = this.childrenRenderers;
        synchronized (set) {
            for (RenderInfo child : this.childrenRenderers) {
                child.getExecutor().dispose();
                toRemove.add(child);
            }
        }
        this.childrenRenderers.removeAll(toRemove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(AbstractRenderMetrics metrics) {
        Set<RenderInfo> set = this.childrenRenderers;
        synchronized (set) {
            Renderer render = metrics.createRenderer();
            render.setContext(metrics.getRenderContext());
            RenderExecutor executor = this.createRenderExecutor(render);
            RenderInfo ri = new RenderInfo(executor, metrics);
            this.childrenRenderers.add(ri);
        }
    }

    public void addChildren(Collection<AbstractRenderMetrics> metrics) {
        for (AbstractRenderMetrics abstractRenderMetrics : metrics) {
            this.addChild(abstractRenderMetrics);
        }
    }

    public class RenderInfo {
        private RenderExecutor executor;
        private AbstractRenderMetrics metrics;

        public RenderInfo(RenderExecutor executor, AbstractRenderMetrics metrics) {
            this.executor = executor;
            this.metrics = metrics;
        }

        public AbstractRenderMetrics getMetrics() {
            return this.metrics;
        }

        public RenderExecutor getExecutor() {
            return this.executor;
        }

        public Renderer getRenderer() {
            return this.getExecutor().getRenderer();
        }
    }
}

