/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.render.impl;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.text.MessageFormat;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.render.RenderPackage;
import net.refractions.udig.project.internal.render.Renderer;
import net.refractions.udig.project.internal.render.SelectionLayer;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.RenderException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class RendererImpl
extends EObjectImpl
implements Renderer {
    protected static final int STATE_EDEFAULT = 1;
    protected int state = 1;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected volatile IRenderContext context = null;
    private volatile ReferencedEnvelope renderbounds;

    protected RendererImpl() {
    }

    protected EClass eStaticClass() {
        return RenderPackage.Literals.RENDERER;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            ILayer layer = this.getContext().getLayer();
            if (layer == null) {
                return "";
            }
            if (layer instanceof SelectionLayer) {
                return MessageFormat.format(Messages.RendererImpl_selectionFor, layer.getName());
            }
            return layer.getName();
        }
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void setState(int newState) {
        int oldState = this.state;
        this.state = newState;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, oldState, this.state));
        }
    }

    @Override
    public IRenderContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(IRenderContext newContext) {
        ProjectPlugin.trace("net.refractions.udig.project/debug/render/trace", this.getClass(), "RenderContext changed. \nOld:" + this.context + "\nNew:" + newContext, null);
        this.context = newContext;
    }

    @Override
    public abstract void render(Graphics2D var1, IProgressMonitor var2) throws RenderException;

    @Override
    public abstract void render(IProgressMonitor var1) throws RenderException;

    @Override
    public void dispose() {
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getState();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getContext();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setState((Integer)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setContext((IRenderContext)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setState(1);
                return;
            }
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setContext(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.state != 1;
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return this.context != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (state: ");
        result.append(this.state);
        result.append(", name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public synchronized void setRenderBounds(Envelope boundsToRender) {
        if (boundsToRender == null) {
            this.renderbounds = null;
        } else if (boundsToRender instanceof ReferencedEnvelope) {
            ReferencedEnvelope referencedEnvelope = (ReferencedEnvelope)boundsToRender;
            if (referencedEnvelope.getCoordinateReferenceSystem() == null) {
                throw new IllegalArgumentException("The provided referenced envelope does not have a CRS, did you mean getContext().getCRS()?");
            }
            this.renderbounds = referencedEnvelope;
        } else {
            ReferencedEnvelope referencedEnvelope;
            CoordinateReferenceSystem crs = this.getContext().getCRS();
            if (crs == null) {
                throw new IllegalArgumentException("We cannot determine the CRS for the provided envelope, please supply a ReferencedEnvelope");
            }
            this.renderbounds = referencedEnvelope = new ReferencedEnvelope(boundsToRender, crs);
        }
    }

    @Override
    public synchronized void setRenderBounds(Rectangle screenArea) {
        Coordinate min = this.getContext().pixelToWorld(screenArea.x, screenArea.y);
        Coordinate max = this.getContext().pixelToWorld(screenArea.width + screenArea.x, screenArea.height + screenArea.y);
        ReferencedEnvelope worldArea = new ReferencedEnvelope(min.x, max.x, min.y, max.y, this.getContext().getCRS());
        this.setRenderBounds((Envelope)worldArea);
    }

    public synchronized ReferencedEnvelope getRenderBounds() {
        return this.renderbounds;
    }
}

