/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.render.impl;

import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.core.internal.ExtensionPointProcessor;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.render.RenderManager;
import net.refractions.udig.project.internal.render.SelectionLayer;
import net.refractions.udig.project.internal.render.impl.CompositeRenderContextImpl;
import net.refractions.udig.project.internal.render.impl.InternalRenderMetricsFactory;
import net.refractions.udig.project.internal.render.impl.RenderContextImpl;
import net.refractions.udig.project.render.IMultiLayerRenderer;
import net.refractions.udig.project.render.IRenderMetricsFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

public class RendererExtensionProcessor
implements ExtensionPointProcessor {
    Layer layer;
    List<InternalRenderMetricsFactory.InternalRenderMetrics> rFactories = new ArrayList<InternalRenderMetricsFactory.InternalRenderMetrics>();
    private Map map;
    private RenderManager rm;

    public RendererExtensionProcessor(Layer layer, Map map, RenderManager rm) {
        this.layer = layer;
        this.rm = rm;
        this.map = map;
    }

    public void process(IExtension extension, IConfigurationElement element) {
        try {
            IRenderMetricsFactory createExecutableExtension = (IRenderMetricsFactory)element.createExecutableExtension("class");
            InternalRenderMetricsFactory metricsFactory = new InternalRenderMetricsFactory(createExecutableExtension, element);
            List<IGeoResource> data = this.layer.getGeoResources();
            for (IGeoResource resource : data) {
                RenderContextImpl context;
                try {
                    context = IMultiLayerRenderer.class.isAssignableFrom(metricsFactory.getRendererType()) ? new CompositeRenderContextImpl() : new RenderContextImpl(this.layer instanceof SelectionLayer);
                }
                catch (Throwable throwable) {
                    context = new RenderContextImpl(this.layer instanceof SelectionLayer);
                }
                context.setMapInternal(this.map);
                context.setRenderManagerInternal(this.rm);
                context.setLayerInternal(this.layer);
                context.setGeoResourceInternal(resource);
                InternalRenderMetricsFactory.InternalRenderMetrics metrics = metricsFactory.createMetrics(context);
                metrics.delegate.setId(String.valueOf(element.getNamespaceIdentifier()) + "." + element.getAttribute("id"));
                this.rFactories.add(metrics);
            }
        }
        catch (CoreException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
    }

    public List<InternalRenderMetricsFactory.InternalRenderMetrics> getRFactories() {
        return this.rFactories;
    }
}

