/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.render.impl;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.render.CompositeRenderContext;
import net.refractions.udig.project.internal.render.ExecutorVisitor;
import net.refractions.udig.project.internal.render.RenderExecutor;
import net.refractions.udig.project.internal.render.RenderFactory;
import net.refractions.udig.project.internal.render.RenderManager;
import net.refractions.udig.project.internal.render.RenderPackage;
import net.refractions.udig.project.internal.render.Renderer;
import net.refractions.udig.project.internal.render.RendererCreator;
import net.refractions.udig.project.internal.render.SelectionLayer;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.internal.render.impl.RenderContextImpl;
import net.refractions.udig.project.internal.render.impl.RenderExecutorComposite;
import net.refractions.udig.project.internal.render.impl.RenderExecutorMultiLayer;
import net.refractions.udig.project.internal.render.impl.RendererCreatorImpl;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.IRenderManager;
import net.refractions.udig.project.render.IRenderer;
import net.refractions.udig.project.render.Tile;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.NotificationChainImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class RenderManagerImpl
extends EObjectImpl
implements RenderManager {
    protected RenderExecutor renderExecutor;
    protected RendererCreator rendererCreator;
    protected static final IMapDisplay MAP_DISPLAY_EDEFAULT = null;
    protected IMapDisplay mapDisplay = MAP_DISPLAY_EDEFAULT;
    protected Map mapInternal;
    protected ViewportModel viewportModelInternal;
    protected volatile boolean disposed = false;
    boolean viewer = false;
    protected volatile boolean renderingEnabled = true;

    protected RenderManagerImpl() {
        this.rendererCreator = new RendererCreatorImpl();
        RenderContextImpl context = new RenderContextImpl(){

            @Override
            public Map getMapInternal() {
                return RenderManagerImpl.this.getMapInternal();
            }

            @Override
            public Map getMap() {
                return RenderManagerImpl.this.getMapInternal();
            }

            @Override
            public RenderManager getRenderManagerInternal() {
                return RenderManagerImpl.this;
            }

            @Override
            public IRenderManager getRenderManager() {
                return RenderManagerImpl.this;
            }
        };
        this.rendererCreator.setContext(context);
    }

    protected EClass eStaticClass() {
        return RenderPackage.Literals.RENDER_MANAGER;
    }

    public void printRenderStack() {
        this.checkState();
        if (this.getRenderExecutor() != null) {
            final StringBuffer msg = new StringBuffer();
            this.getRenderExecutor().visit(new ExecutorVisitor(){
                int i = 0;

                @Override
                public void visit(RenderExecutor executor) {
                    ++this.i;
                    String layername = executor.getContext().getLayer().getID().toString();
                    if (executor.getContext().getLayer() instanceof SelectionLayer) {
                        layername = String.valueOf(layername) + "<Selection>";
                    }
                    msg.append("\n" + this.i + " - " + layername);
                }

                @Override
                public void visit(RenderExecutorMultiLayer executor) {
                    for (ILayer layer : executor.getContext().getLayers()) {
                        ++this.i;
                        String layername = layer.getID().toString();
                        if (layer instanceof SelectionLayer) {
                            layername = String.valueOf(layername) + "<Selection>";
                        }
                        msg.append("\n" + this.i + " - " + layername);
                    }
                }

                @Override
                public void visit(RenderExecutorComposite executor) {
                    for (RenderExecutor renderer : executor.getRenderer().getRenderExecutors()) {
                        renderer.visit(this);
                    }
                }
            });
            ProjectPlugin.log(msg.toString(), null);
        }
    }

    @Override
    public Map getMapInternal() {
        if (this.mapInternal != null && this.mapInternal.eIsProxy()) {
            InternalEObject oldMapInternal = (InternalEObject)this.mapInternal;
            this.mapInternal = (Map)this.eResolveProxy(oldMapInternal);
            if (this.mapInternal != oldMapInternal && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 2, (Object)oldMapInternal, (Object)this.mapInternal));
            }
        }
        return this.mapInternal;
    }

    public Map basicGetMapInternal() {
        return this.mapInternal;
    }

    public NotificationChain basicSetMapInternal(Map newMapInternal, NotificationChain msgs) {
        Map oldMapInternal = this.mapInternal;
        this.mapInternal = newMapInternal;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldMapInternal, (Object)newMapInternal);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setMapInternalGen(Map newMapInternal) {
        if (newMapInternal != this.mapInternal) {
            NotificationChain msgs = null;
            if (this.mapInternal != null) {
                msgs = ((InternalEObject)this.mapInternal).eInverseRemove((InternalEObject)this, 10, Map.class, msgs);
            }
            if (newMapInternal != null) {
                msgs = ((InternalEObject)newMapInternal).eInverseAdd((InternalEObject)this, 10, Map.class, msgs);
            }
            if ((msgs = this.basicSetMapInternal(newMapInternal, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newMapInternal, (Object)newMapInternal));
        }
    }

    public boolean isViewer() {
        this.checkState();
        return this.viewer;
    }

    public void setViewer(boolean viewer) {
        this.checkState();
        this.viewer = viewer;
    }

    @Override
    public void setMapInternal(Map newMap) {
        this.checkState();
        if (this.isViewer()) {
            this.basicSetMapInternal(newMap, (NotificationChain)new NotificationChainImpl());
        } else {
            this.setMapInternalGen(newMap);
        }
    }

    @Override
    public IMapDisplay getMapDisplay() {
        return this.mapDisplay;
    }

    @Override
    public void setMapDisplay(IMapDisplay newMapDisplay) {
        IMapDisplay oldMapDisplay = this.mapDisplay;
        this.mapDisplay = newMapDisplay;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldMapDisplay, (Object)this.mapDisplay));
        }
    }

    @Override
    public RendererCreator getRendererCreator() {
        this.checkState();
        return this.rendererCreator;
    }

    @Override
    public ViewportModel getViewportModelInternal() {
        this.checkState();
        return this.viewportModelInternal;
    }

    public NotificationChain basicSetViewportModelInternal(ViewportModel newViewportModelInternal, NotificationChain msgs) {
        ViewportModel oldViewportModelInternal = this.viewportModelInternal;
        this.viewportModelInternal = newViewportModelInternal;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldViewportModelInternal, (Object)newViewportModelInternal);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setViewportModelInternal(ViewportModel newViewportModelInternal) {
        if (newViewportModelInternal != this.viewportModelInternal) {
            NotificationChain msgs = null;
            if (this.viewportModelInternal != null) {
                msgs = ((InternalEObject)this.viewportModelInternal).eInverseRemove((InternalEObject)this, 8, ViewportModel.class, msgs);
            }
            if (newViewportModelInternal != null) {
                msgs = ((InternalEObject)newViewportModelInternal).eInverseAdd((InternalEObject)this, 8, ViewportModel.class, msgs);
            }
            if ((msgs = this.basicSetViewportModelInternal(newViewportModelInternal, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newViewportModelInternal, (Object)newViewportModelInternal));
        }
    }

    @Override
    public RenderExecutor getRenderExecutor() {
        this.checkState();
        if (this.renderExecutor == null) {
            this.setRenderExecutor(RenderFactory.eINSTANCE.createRenderExecutor());
        }
        return this.renderExecutor;
    }

    @Override
    public void setRenderExecutor(RenderExecutor newRenderExecutor) {
        RenderExecutor oldRenderExecutor = this.renderExecutor;
        this.renderExecutor = newRenderExecutor;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldRenderExecutor, (Object)this.renderExecutor));
        }
    }

    @Override
    public void dispose() {
        this.checkState();
        if (this.renderExecutor != null) {
            ((RenderContextImpl)this.renderExecutor.getContext()).dispose();
            this.getRenderExecutor().dispose();
        }
        this.mapDisplay = null;
        this.renderExecutor = null;
        this.getMapInternal().setRenderManagerInternal(null);
        this.disposed = true;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                if (this.mapInternal != null) {
                    msgs = ((InternalEObject)this.mapInternal).eInverseRemove((InternalEObject)this, 10, Map.class, msgs);
                }
                return this.basicSetMapInternal((Map)otherEnd, msgs);
            }
            case 3: {
                if (this.viewportModelInternal != null) {
                    msgs = ((InternalEObject)this.viewportModelInternal).eInverseRemove((InternalEObject)this, 8, ViewportModel.class, msgs);
                }
                return this.basicSetViewportModelInternal((ViewportModel)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return this.basicSetMapInternal(null, msgs);
            }
            case 3: {
                return this.basicSetViewportModelInternal(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getRenderExecutor();
            }
            case 1: {
                return this.getMapDisplay();
            }
            case 2: {
                if (resolve) {
                    return this.getMapInternal();
                }
                return this.basicGetMapInternal();
            }
            case 3: {
                return this.getViewportModelInternal();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setRenderExecutor((RenderExecutor)newValue);
                return;
            }
            case 1: {
                this.setMapDisplay((IMapDisplay)newValue);
                return;
            }
            case 2: {
                this.setMapInternal((Map)newValue);
                return;
            }
            case 3: {
                this.setViewportModelInternal((ViewportModel)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setRenderExecutor(null);
                return;
            }
            case 1: {
                this.setMapDisplay(MAP_DISPLAY_EDEFAULT);
                return;
            }
            case 2: {
                this.setMapInternal(null);
                return;
            }
            case 3: {
                this.setViewportModelInternal(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.renderExecutor != null;
            }
            case 1: {
                return MAP_DISPLAY_EDEFAULT == null ? this.mapDisplay != null : !MAP_DISPLAY_EDEFAULT.equals(this.mapDisplay);
            }
            case 2: {
                return this.mapInternal != null;
            }
            case 3: {
                return this.viewportModelInternal != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public void checkState() throws IllegalStateException {
        if (this.disposed) {
            throw new IllegalStateException("RenderManager is disposed");
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (mapDisplay: ");
        result.append(this.mapDisplay);
        result.append(')');
        return result.toString();
    }

    @Override
    public void refresh(ILayer layer, Envelope bounds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refresh(Envelope bounds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refreshImage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refreshSelection(ILayer layer, Envelope bounds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMap getMap() {
        this.checkState();
        return this.getMapInternal();
    }

    @Override
    public List<IRenderer> getRenderers() {
        this.checkState();
        final ArrayList<IRenderer> renderers = new ArrayList<IRenderer>();
        this.getRenderExecutor().visit(new ExecutorVisitor(){

            @Override
            public void visit(RenderExecutor executor) {
                if (!(executor.getContext().getLayer() instanceof SelectionLayer)) {
                    Renderer renderer = executor.getRenderer();
                    renderers.add(renderer);
                }
            }

            @Override
            public void visit(RenderExecutorMultiLayer executor) {
                renderers.add(executor.getRenderer());
            }

            @Override
            public void visit(RenderExecutorComposite executor) {
                for (RenderExecutor currentExecutor : executor.getRenderer().getRenderExecutors()) {
                    currentExecutor.visit(this);
                }
            }
        });
        Collections.sort(renderers, new Comparator<IRenderer>(){

            @Override
            public int compare(IRenderer arg0, IRenderer arg1) {
                return arg0.getContext().getLayer().compareTo(arg1.getContext().getLayer());
            }
        });
        return renderers;
    }

    @Override
    public void stopRendering() {
        this.checkState();
        if (this.getRenderExecutor() != null) {
            this.getRenderExecutor().stopRendering();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public RenderedImage getImage() {
        if (this.renderExecutor == null || this.renderExecutor.getState() == 1 || this.getRenderExecutor().getContext() == null) {
            return null;
        }
        return this.getRenderExecutor().getContext().getImage();
    }

    @Override
    public void clearSelection(ILayer layer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disableRendering() {
        this.renderingEnabled = false;
    }

    @Override
    public void enableRendering() {
        this.renderingEnabled = true;
    }

    @Override
    public boolean isRenderingEnabled() {
        return this.renderingEnabled;
    }

    @Override
    public boolean areLayersRelatedByContext(ILayer layer, ILayer contained) {
        if (layer == contained) {
            return true;
        }
        Iterator<IRenderer> iterator = this.getRenderers().iterator();
        while (iterator.hasNext()) {
            IRenderContext context = iterator.next().getContext();
            if (context instanceof CompositeRenderContext) {
                if (!((CompositeRenderContext)context).getLayers().contains(layer)) continue;
                return ((CompositeRenderContext)context).getLayers().contains(contained);
            }
            if (context.getLayer() != layer) continue;
            return false;
        }
        return false;
    }

    @Override
    public Collection<ReferencedEnvelope> computeTileBounds(ReferencedEnvelope viewBounds, double worldunitsperpixel) {
        return null;
    }

    @Override
    public java.util.Map<ReferencedEnvelope, Tile> getTiles(Collection<ReferencedEnvelope> bounds) {
        return null;
    }
}

