/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.render.impl;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.render.RenderExecutor;
import net.refractions.udig.project.internal.render.RenderManager;
import net.refractions.udig.project.internal.render.Renderer;
import net.refractions.udig.project.internal.render.SelectionLayer;
import net.refractions.udig.project.internal.render.impl.CompositeRendererImpl;
import net.refractions.udig.project.internal.render.impl.RenderExecutorImpl;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class RenderJob
extends Job {
    protected volatile IProgressMonitor monitor;
    protected RenderExecutor executor;
    protected ReferencedEnvelope bounds;
    private Queue<ReferencedEnvelope> requests = new LinkedBlockingQueue<ReferencedEnvelope>();

    public RenderJob(RenderExecutor executor) {
        super(Messages.RenderExecutorImpl_title);
        this.executor = executor;
        this.init();
    }

    protected void init() {
        this.setRule(new RenderJobRule());
        this.setSystem(true);
    }

    public RenderExecutor getExecutor() {
        return this.executor;
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    protected void startRendering(Envelope bounds2, IProgressMonitor monitor) throws Throwable {
        Envelope bounds = bounds2;
        IRenderContext context2 = this.getExecutor().getContext();
        if (bounds == null || bounds.contains((Envelope)context2.getViewportModel().getBounds())) {
            bounds = null;
        }
        this.clearBounds(bounds);
        if (this.executor.getRenderer().getState() != 16) {
            this.executor.getRenderer().setRenderBounds(bounds);
        }
        monitor.beginTask(Messages.RenderExecutorImpl_1, -1);
        if (context2.getLayer() != null) {
            this.initializeLabelPainter(context2);
        }
        this.executor.getRenderer().render((IProgressMonitor)new SubProgressMonitor(monitor, 0));
    }

    protected void clearBounds(Envelope bounds2) {
        RenderExecutorImpl.clearImage((Envelope)this.bounds, this.getExecutor());
    }

    protected void initializeLabelPainter(IRenderContext context2) {
        if (!(context2.getLayer() instanceof SelectionLayer)) {
            String layerId = this.getLayerId(context2);
            context2.getLabelPainter().clear(layerId);
            context2.getLabelPainter().startLayer(layerId);
        }
    }

    private String getLayerId(IRenderContext context2) {
        String layerId = context2.getLayer().getID().toString();
        if (context2.getLayer() instanceof SelectionLayer) {
            layerId = String.valueOf(layerId) + "-Selection";
        }
        return layerId;
    }

    protected void finalizeLabelPainter(IRenderContext context2) {
        String layerId = this.getLayerId(context2);
        IMapDisplay mapDisplay = context2.getMapDisplay();
        if (mapDisplay == null) {
            return;
        }
        Dimension displaySize = context2.getImageSize();
        Graphics2D graphics = context2.getImage().createGraphics();
        try {
            context2.getLabelPainter().endLayer(layerId, graphics, new Rectangle(0, 0, displaySize.width, displaySize.height));
        }
        finally {
            graphics.dispose();
        }
    }

    protected void handleException(Throwable renderError) {
        this.finalizeLabelPainter(this.executor.getContext());
        try {
            ProjectPlugin.getPlugin().log(renderError);
            if (renderError.getCause() instanceof NullPointerException) {
                this.handleNullPointerException(renderError);
            } else {
                this.handleUnknownError(renderError);
            }
        }
        catch (Exception exception) {
            ProjectPlugin.log(renderError.getLocalizedMessage(), renderError);
        }
    }

    private void handleNullPointerException(Throwable renderError) {
        this.executor.getContext().setStatus(4);
        this.executor.getContext().setStatusMessage(Messages.RenderExecutorImpl_2);
    }

    private void handleUnknownError(Throwable renderError) {
        this.executor.getContext().setStatus(2);
        this.executor.getContext().setStatusMessage(String.valueOf(Messages.RenderExecutorImpl_1) + renderError.getLocalizedMessage());
    }

    protected void postRendering() {
        this.finalizeLabelPainter(this.executor.getContext());
        if (this.monitor.isCanceled()) {
            this.executor.getRenderer().setState(64);
            this.executor.setState(64);
            return;
        }
        this.executor.getRenderer().setState(4);
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (!((RenderManager)this.getExecutor().getContext().getRenderManager()).isRenderingEnabled()) {
            return Status.OK_STATUS;
        }
        this.setThread(Thread.currentThread());
        this.monitor = monitor;
        while (!this.requests.isEmpty() && !monitor.isCanceled()) {
            try {
                this.bounds = this.combineRequests();
                if (this.bounds.isNull() || this.bounds.isEmpty()) {
                    System.out.println("We combined requests down to nothing?");
                    continue;
                }
                this.startRendering((Envelope)this.bounds, monitor);
                this.postRendering();
            }
            catch (Throwable renderError) {
                this.handleException(renderError);
                renderError.printStackTrace();
                this.getExecutor().getRenderer().setState(4);
            }
        }
        return Status.OK_STATUS;
    }

    private synchronized ReferencedEnvelope combineRequests() throws TransformException, FactoryException {
        CoordinateReferenceSystem targetCRS = this.getExecutor().getContext().getCRS();
        ReferencedEnvelope bounds = new ReferencedEnvelope(targetCRS);
        try {
            for (ReferencedEnvelope env : this.requests) {
                CoordinateReferenceSystem envCRS = env.getCoordinateReferenceSystem();
                if (env.isNull() || env.isEmpty() || envCRS == null) {
                    System.out.println("We are skipping an empty request");
                    continue;
                }
                if (envCRS != DefaultEngineeringCRS.GENERIC_2D && envCRS != DefaultEngineeringCRS.GENERIC_3D && envCRS != DefaultEngineeringCRS.CARTESIAN_2D && envCRS != DefaultEngineeringCRS.CARTESIAN_3D && !CRS.equalsIgnoreMetadata((Object)envCRS, (Object)targetCRS)) {
                    env = env.transform(targetCRS, true);
                }
                if (bounds.isNull()) {
                    bounds.init((Envelope)env);
                    continue;
                }
                bounds.include((BoundingBox)env);
            }
        }
        finally {
            this.requests.clear();
        }
        return bounds;
    }

    public boolean belongsTo(Object family) {
        if (this.executor.getContext() == null) {
            return false;
        }
        return family == this.executor.getContext().getRenderManager();
    }

    public void setBounds(ReferencedEnvelope bounds) {
        this.bounds = bounds;
    }

    public synchronized void addRequest(ReferencedEnvelope envelope) {
        if (envelope == null) {
            this.requests.add(this.getExecutor().getContext().getImageBounds());
        } else {
            if (envelope.getCoordinateReferenceSystem() == null) {
                throw new IllegalArgumentException("You have asked us to draw a region of the screen without a CRS. Did you intend the viewport CRS?");
            }
            if (envelope.isNull()) {
                throw new IllegalArgumentException("The provided envelope had isNull true");
            }
            if (envelope.isEmpty()) {
                throw new IllegalArgumentException("The provided envelope was empty");
            }
            this.requests.add(envelope);
        }
        this.schedule();
    }

    private class RenderJobRule
    implements ISchedulingRule {
        private RenderJobRule() {
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (!(rule instanceof RenderJobRule)) {
                return false;
            }
            RenderJobRule other = (RenderJobRule)rule;
            if (other == this) {
                return true;
            }
            if (this.getRenderer() instanceof CompositeRendererImpl) {
                return false;
            }
            return other.getRenderer().getClass().equals(this.getRenderer().getClass()) && !this.isCanceled() && !other.isCanceled() && this.isUsingLocalResources(this.getRenderer()) && this.isUsingLocalResources(other.getRenderer());
        }

        private boolean isUsingLocalResources(Renderer renderer) {
            try {
                return renderer.getContext().getGeoResource().getIdentifier().toString().startsWith("file:/");
            }
            catch (Exception exception) {
                return false;
            }
        }

        public boolean contains(ISchedulingRule rule) {
            return this.isConflicting(rule);
        }

        Renderer getRenderer() {
            return RenderJob.this.executor.getRenderer();
        }

        boolean isCanceled() {
            if (RenderJob.this.getMonitor() != null) {
                return RenderJob.this.getMonitor().isCanceled();
            }
            return false;
        }
    }
}

