/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.render.impl;

import com.vividsolutions.jts.geom.Envelope;
import java.text.MessageFormat;
import java.util.Collection;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.render.ExecutorVisitor;
import net.refractions.udig.project.internal.render.RenderExecutor;
import net.refractions.udig.project.internal.render.Renderer;
import net.refractions.udig.project.internal.render.impl.CompositeRendererImpl;
import net.refractions.udig.project.internal.render.impl.RenderExecutorImpl;
import net.refractions.udig.project.internal.render.impl.RenderExecutorMultiLayer;
import net.refractions.udig.project.internal.render.impl.RenderJob;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.RenderException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notification;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class RenderExecutorComposite
extends RenderExecutorMultiLayer {
    private boolean inUpdate = false;
    private volatile Thread redraw;
    Job refreshJob;
    int timeout = 0;

    static boolean isRendering(CompositeRendererImpl renderer2) {
        Collection<RenderExecutor> executors = renderer2.getRenderExecutors();
        for (RenderExecutor executor : executors) {
            if (!executor.getContext().isVisible() || executor.getState() != 2 && executor.getState() != 32 && executor.getState() != 16) continue;
            return true;
        }
        return false;
    }

    public RenderExecutorComposite() {
        this.renderJob = new CompositeRendererJob(this);
    }

    @Override
    protected RenderExecutorImpl.LayerListener getLayerListener() {
        return new RenderExecutorImpl.LayerListener(this){

            @Override
            public void notifyChanged(Notification msg) {
            }
        };
    }

    @Override
    public CompositeRendererImpl getRenderer() {
        return (CompositeRendererImpl)this.renderer;
    }

    @Override
    protected RenderExecutorImpl.RendererListener getRendererListener() {
        return new CompositeRendererListener(this);
    }

    @Override
    protected String getRenderJobName() {
        return MessageFormat.format(Messages.RenderExecutorImpl_message, this.getContext().getMap().getName());
    }

    public synchronized void refresh() {
        if (this.refreshJob == null) {
            this.refreshJob = new Job(this.getRenderJobName()){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ((CompositeRendererJob)RenderExecutorComposite.this.renderJob).incrementalUpdate();
                    }
                    catch (Exception e) {
                        ProjectPlugin.log(null, e);
                    }
                    return Status.OK_STATUS;
                }
            };
            this.refreshJob.setSystem(false);
            this.refreshJob.setPriority(10);
        }
        this.refreshJob.schedule();
    }

    protected void registerFeatureListener() {
    }

    @Override
    public synchronized void render() {
        RedrawJob runnable = new RedrawJob();
        runnable.bounds = this.getRenderBounds();
        if (this.redraw != null) {
            this.redraw.interrupt();
        }
        this.redraw = new Thread(runnable);
        this.redraw.start();
    }

    protected synchronized void resetTimeout() {
        this.timeout = 0;
    }

    @Override
    protected void resyncState(Renderer renderer) {
    }

    @Override
    public void setRenderer(Renderer newRenderer) {
        this.renderJob.setSystem(false);
        super.setRendererInternal(newRenderer);
    }

    @Override
    public void stopRendering() {
        for (RenderExecutor executor : this.getRenderer().getRenderExecutors()) {
            executor.stopRendering();
        }
        super.stopRendering();
    }

    @Override
    public void visit(ExecutorVisitor visitor) {
        visitor.visit(this);
    }

    protected static class CompositeRendererJob
    extends RenderJob {
        private static final int TIMEOUT = 20000;

        public CompositeRendererJob(RenderExecutorComposite executor) {
            super(executor);
            this.setPriority(10);
        }

        @Override
        protected void clearBounds(Envelope bounds2) {
        }

        @Override
        protected void finalizeLabelPainter(IRenderContext context2) {
        }

        @Override
        public RenderExecutorComposite getExecutor() {
            return (RenderExecutorComposite)this.executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void incrementalUpdate() throws InterruptedException, RenderException {
            this.getExecutor().resetTimeout();
            RenderExecutorComposite renderExecutorComposite = this.getExecutor();
            synchronized (renderExecutorComposite) {
                this.getExecutor().inUpdate = true;
            }
            CompositeRendererImpl renderer2 = this.getExecutor().getRenderer();
            long start = System.currentTimeMillis();
            RenderExecutorComposite renderExecutorComposite2 = this.getExecutor();
            synchronized (renderExecutorComposite2) {
                while (this.getMonitor() != null && !this.getMonitor().isCanceled() && RenderExecutorComposite.isRendering(renderer2) && this.getExecutor().timeout < 20000) {
                    this.getExecutor().wait(400L);
                    long now = System.currentTimeMillis();
                    this.getExecutor().timeout = (int)(now - start);
                    if (!RenderExecutorComposite.isRendering(renderer2)) continue;
                    renderer2.refreshImage(false);
                    this.getExecutor().setState(2);
                }
            }
            if (ProjectPlugin.getPlugin().isDebugging()) {
                String message = "Time taken to render is: " + (System.currentTimeMillis() - start) / 1000L + "seconds";
                ProjectPlugin.trace("net.refractions.udig.project/debug/render/trace", ((Object)((Object)this)).getClass(), message, null);
            }
            renderExecutorComposite2 = this.getExecutor();
            synchronized (renderExecutorComposite2) {
                if (this.getMonitor() != null && !this.getMonitor().isCanceled()) {
                    renderer2.refreshImage();
                }
                this.getExecutor().setState(4);
                this.getExecutor().inUpdate = false;
            }
        }

        @Override
        protected void init() {
        }

        @Override
        protected void initializeLabelPainter(IRenderContext context2) {
        }

        @Override
        protected void postRendering() {
            if (this.monitor.isCanceled()) {
                this.executor.getRenderer().setState(64);
                for (RenderExecutor renderer : ((CompositeRendererImpl)this.executor.getRenderer()).getRenderExecutors()) {
                    if (!renderer.getContext().isVisible() || this.executor.getState() == 4) continue;
                    renderer.getContext().setStatus(4);
                    renderer.getContext().setStatusMessage("Timed out while rendering this layer.  Seems to have blocked, check that the server is up");
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void startRendering(Envelope bounds, IProgressMonitor monitor) throws Throwable {
            RenderExecutorComposite renderExecutorComposite = this.getExecutor();
            synchronized (renderExecutorComposite) {
                this.getExecutor().inUpdate = true;
            }
            super.startRendering(bounds, monitor);
            this.incrementalUpdate();
        }
    }

    protected static class CompositeRendererListener
    extends RenderExecutorMultiLayer.MultiLayerRendererListener {
        CompositeRendererListener(RenderExecutorComposite executor) {
            super(executor);
        }

        RenderExecutorComposite getExecutor() {
            return (RenderExecutorComposite)this.executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void stateChanged(Notification msg) {
            switch (msg.getNewIntValue()) {
                case 2: {
                    this.getExecutor().resetTimeout();
                    RenderExecutorComposite renderExecutorComposite = this.getExecutor();
                    synchronized (renderExecutorComposite) {
                        this.getExecutor().setState(2);
                        return;
                    }
                }
                case 4: {
                    try {
                        RenderExecutorComposite renderExecutorComposite = this.getExecutor();
                        synchronized (renderExecutorComposite) {
                            if (!this.getExecutor().inUpdate) {
                                this.getExecutor().getRenderer().refreshImage();
                                this.executor.setState(4);
                            }
                            if (RenderExecutorComposite.isRendering(this.getExecutor().getRenderer()) && (this.getExecutor().renderJob.getMonitor() == null || !this.getExecutor().renderJob.getMonitor().isCanceled())) return;
                            this.getExecutor().notifyAll();
                            return;
                        }
                    }
                    catch (RenderException e) {
                        ProjectPlugin.log("", e);
                    }
                    return;
                }
                case 16: {
                    boolean oldValue = this.executor.eDeliver();
                    this.executor.eSetDeliver(false);
                    this.executor.setState(msg.getNewIntValue());
                    this.executor.eSetDeliver(oldValue);
                    ((RenderExecutorComposite)this.executor).refresh();
                    return;
                }
                case 32: {
                    boolean oldValue2 = this.executor.eDeliver();
                    this.executor.eSetDeliver(false);
                    this.executor.setState(msg.getNewIntValue());
                    this.executor.eSetDeliver(oldValue2);
                }
            }
        }
    }

    class RedrawJob
    implements Runnable {
        ReferencedEnvelope bounds;

        RedrawJob() {
        }

        @Override
        public void run() {
            RenderExecutorComposite.this.stopRendering();
            if (!Thread.currentThread().isInterrupted()) {
                this.runRenderJob();
            }
        }

        void runRenderJob() {
            RenderExecutorComposite.this.dirty = false;
            if (RenderExecutorComposite.this.getContext().getMapDisplay() == null || RenderExecutorComposite.this.getContext().getMapDisplay().getWidth() < 1 || RenderExecutorComposite.this.getContext().getMapDisplay().getHeight() < 1) {
                return;
            }
            if (RenderExecutorComposite.this.getState() == 8) {
                throw new RuntimeException("attempted to run a disposed renderer");
            }
            RenderExecutorComposite.clearImage((Envelope)this.bounds, RenderExecutorComposite.this);
            RenderExecutorComposite.this.renderJob.setName(RenderExecutorComposite.this.getRenderJobName());
            RenderExecutorComposite.this.renderJob.addRequest(this.bounds);
            if (!Thread.currentThread().isInterrupted()) {
                RenderExecutorComposite.this.redraw = null;
            }
        }
    }
}

