/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.render.impl;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.media.jai.JAI;
import javax.media.jai.TileCache;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.impl.AbstractContextImpl;
import net.refractions.udig.project.internal.render.RenderContext;
import net.refractions.udig.project.internal.render.SelectionLayer;
import net.refractions.udig.project.internal.render.impl.ScaleUtils;
import net.refractions.udig.project.internal.render.impl.UDIGLabelCache;
import net.refractions.udig.project.render.ILabelPainter;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.lite.LabelCache;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;

public class RenderContextImpl
extends AbstractContextImpl
implements RenderContext {
    protected volatile BufferedImage image = null;
    protected Dimension imagesize = null;
    protected ReferencedEnvelope imageBounds = null;
    public static final BufferedImage dummyImage = new BufferedImage(1, 1, 6);
    private static final String LABEL_PAINTER = "LABEL_PAINTER";
    protected Layer layerInternal = null;
    protected IGeoResource geoResourceInternal = null;
    private boolean selection;
    protected TileCache tempCache;
    private ILabelPainter labelPainterLocal;

    public RenderContextImpl() {
    }

    public RenderContextImpl(boolean selection) {
        this.selection = selection;
    }

    public RenderContextImpl(RenderContextImpl impl) {
        super(impl);
        this.setGeoResourceInternal(impl.getGeoResourceInternal());
        this.setLayerInternal(impl.getLayerInternal());
        if (impl.imagesize != null) {
            this.imagesize = new Dimension(impl.imagesize);
        }
        this.imageBounds = impl.imageBounds;
    }

    @Override
    public synchronized TileCache getTileCache() {
        if (this.tempCache == null) {
            this.tempCache = JAI.createTileCache();
            this.tempCache.setMemoryCapacity(0x1000000L);
            this.tempCache.setMemoryThreshold(0.75f);
        }
        return this.tempCache;
    }

    @Override
    public void setImageSize(Dimension d) {
        this.imagesize = d;
    }

    @Override
    public BufferedImage getImage() {
        Dimension size = this.getImageSize();
        if (size == null || size.width < 1 || size.height < 1) {
            return dummyImage;
        }
        return this.getImage(size.width, size.height);
    }

    public synchronized void setImage(BufferedImage bi) {
        this.image = bi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized BufferedImage getImage(int width, int height) {
        if (width < 1 || height < 1) {
            return dummyImage;
        }
        if (this.image == null || this.image.getWidth() < width || this.image.getHeight() < height) {
            RenderContextImpl renderContextImpl = this;
            synchronized (renderContextImpl) {
                if (this.image == null || this.image.getWidth() < width || this.image.getHeight() < height) {
                    this.image = new BufferedImage(width, height, 2);
                }
            }
        }
        return this.image;
    }

    @Override
    public Query getQuery(ILayer layer) {
        return layer.getQuery(this.selection);
    }

    @Override
    public int getZorder() {
        if (this.getLayer() == null) {
            return 0;
        }
        return this.getLayer().getZorder();
    }

    @Override
    public boolean isVisible() {
        return this.getLayer().isVisible();
    }

    @Override
    public Layer getLayerInternal() {
        return this.layerInternal;
    }

    @Override
    public void setLayerInternal(Layer newLayerInternal) {
        this.layerInternal = newLayerInternal;
    }

    @Override
    public IGeoResource getGeoResourceInternal() {
        return this.geoResourceInternal;
    }

    @Override
    public void setGeoResourceInternal(IGeoResource newGeoResourceInternal) {
        this.geoResourceInternal = newGeoResourceInternal;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[layer: ");
        if (this.layerInternal instanceof SelectionLayer) {
            result.append("Selection ");
        }
        result.append(this.layerInternal == null ? "null" : this.layerInternal.getName());
        result.append(", geoResource: ");
        result.append(this.geoResourceInternal == null ? "null" : this.geoResourceInternal.getIdentifier().toString());
        result.append(']');
        return result.toString();
    }

    @Override
    public boolean hasContent(Point screenLocation) {
        BufferedImage image = this.getImage();
        int alpha = image.getAlphaRaster().getSample(screenLocation.x, screenLocation.y, 0);
        return alpha > 0;
    }

    @Override
    public BufferedImage copyImage(Rectangle rectangle) {
        return null;
    }

    @Override
    public int compareTo(RenderContext o) {
        if (o == null) {
            return 1;
        }
        if (o == this) {
            return 0;
        }
        int result = this.getLayer().compareTo(o.getLayer());
        if (result == 0 && this.getRenderManager() != o.getRenderManager()) {
            return 1;
        }
        return result;
    }

    @Override
    public void init(RenderContext renderContext) {
        this.setMapInternal(renderContext.getMapInternal());
        this.setRenderManagerInternal(renderContext.getRenderManagerInternal());
        this.setLayerInternal(renderContext.getLayerInternal());
        this.setGeoResourceInternal(renderContext.getGeoResourceInternal());
    }

    @Override
    public void clearImage() {
        this.clearImage(new Rectangle(0, 0, this.getImageSize().width, this.getImageSize().height));
    }

    @Override
    public Query getFeatureQuery() {
        Not newFilter;
        Query query = this.getLayer().getQuery(this.getLayer() instanceof SelectionLayer);
        if (query.getFilter() == Filter.EXCLUDE) {
            return query;
        }
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Object editFilter = this.getLayer().getBlackboard().get("EDIT_FILTER_CACHE");
        if (!(editFilter instanceof Filter)) {
            return query;
        }
        if (editFilter instanceof Id && ((Id)editFilter).getIDs().isEmpty()) {
            return query;
        }
        try {
            if (query.getFilter() == Filter.INCLUDE) {
                newFilter = ff.not((Filter)editFilter);
            } else {
                editFilter = ff.not((Filter)editFilter);
                newFilter = ff.and(query.getFilter(), (Filter)editFilter);
            }
        }
        catch (IllegalFilterException illegalFilterException) {
            return query;
        }
        Query newQuery = new Query(query);
        newQuery.setFilter((Filter)newFilter);
        return newQuery;
    }

    @Override
    public synchronized void clearImage(Rectangle paintArea) {
        if (ProjectPlugin.isDebugging("net.refractions.udig.project/debug/render/trace")) {
            ProjectPlugin.trace(this.getClass(), "", null);
        }
        Graphics2D graphics = this.getImage().createGraphics();
        graphics.setBackground(new Color(0, 0, 0, 0));
        graphics.clearRect(paintArea.x, paintArea.y, paintArea.width, paintArea.height);
        graphics.dispose();
    }

    @Override
    public void setStatus(int status) {
        if (this.layerInternal != null && !(this.layerInternal instanceof SelectionLayer)) {
            this.layerInternal.setStatus(status);
        }
    }

    @Override
    public ILayer getLayer() {
        return this.getLayerInternal();
    }

    @Override
    public IGeoResource getGeoResource() {
        return this.getGeoResourceInternal();
    }

    @Override
    public int getStatus() {
        if (this.getLayer() == null) {
            return -1;
        }
        return this.getLayer().getStatus();
    }

    @Override
    public String getStatusMessage() {
        if (this.getLayer() == null) {
            return null;
        }
        return this.getLayer().getStatusMessage();
    }

    @Override
    public void setStatusMessage(String message) {
        if (this.getLayerInternal() != null) {
            this.getLayerInternal().setStatusMessage(message);
        }
    }

    public void dispose() {
        this.image = null;
        if (this.tempCache != null) {
            this.tempCache.flush();
            this.tempCache = null;
        }
    }

    @Override
    public RenderContextImpl copy() {
        return new RenderContextImpl(this);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.geoResourceInternal == null ? 0 : this.geoResourceInternal.hashCode());
        result = 31 * result + (this.layerInternal == null ? 0 : this.layerInternal.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RenderContextImpl)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RenderContextImpl other = (RenderContextImpl)obj;
        if (this.geoResourceInternal == null ? other.geoResourceInternal != null : !this.geoResourceInternal.equals((Object)other.geoResourceInternal)) {
            return false;
        }
        if (this.layerInternal == null ? other.layerInternal != null : !this.layerInternal.equals(other.layerInternal)) {
            return false;
        }
        if (this.imagesize == null) {
            if (other.imagesize != null) {
                return false;
            }
        } else {
            if (other.imagesize == null) {
                return false;
            }
            if (this.imagesize.height != other.imagesize.height || this.imagesize.width != other.imagesize.width) {
                return false;
            }
        }
        return !(this.imageBounds == null ? other.imageBounds != null : !this.imageBounds.equals((Object)other.imageBounds));
    }

    public void setLabelPainterLocal(ILabelPainter labelPainter) {
        this.labelPainterLocal = labelPainter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILabelPainter getLabelPainter() {
        String string = LABEL_PAINTER;
        synchronized (LABEL_PAINTER) {
            if (this.labelPainterLocal != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.labelPainterLocal;
            }
            ILabelPainter labelPainter = (ILabelPainter)this.getMap().getBlackboard().get(LABEL_PAINTER);
            if (labelPainter == null) {
                LabelCacheImpl defaultLabelCache = new LabelCacheImpl();
                labelPainter = new UDIGLabelCache((LabelCache)defaultLabelCache);
                this.getMap().getBlackboard().put(LABEL_PAINTER, labelPainter);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return labelPainter;
        }
    }

    public synchronized void setLabelPainter(ILabelPainter labelPainter) {
        this.getMap().getBlackboard().put(LABEL_PAINTER, labelPainter);
    }

    @Override
    public ReferencedEnvelope getImageBounds() {
        if (this.imageBounds == null) {
            return this.getViewportModel().getBounds();
        }
        return this.imageBounds;
    }

    @Override
    public Dimension getImageSize() {
        if (this.imagesize == null) {
            IMapDisplay mapDisplay = this.getMapDisplay();
            if (mapDisplay == null) {
                return null;
            }
            return mapDisplay.getDisplaySize();
        }
        return this.imagesize;
    }

    @Override
    public void setImageBounds(ReferencedEnvelope bounds) {
        this.imageBounds = bounds;
    }

    @Override
    public Coordinate pixelToWorld(int x, int y) {
        return ScaleUtils.pixelToWorld(x, y, this.getImageBounds(), this.getImageSize());
    }

    @Override
    public AffineTransform worldToScreenTransform() {
        return ScaleUtils.worldToScreenTransform((Envelope)this.getImageBounds(), this.getImageSize());
    }

    @Override
    public Point worldToPixel(Coordinate coord) {
        return ScaleUtils.worldToPixel(coord, this.getImageBounds(), this.getImageSize());
    }

    @Override
    public MathTransform2D worldToScreenMathTransform() {
        GeneralMatrix matrix = new GeneralMatrix(this.worldToScreenTransform());
        try {
            return (MathTransform2D)ReferencingFactoryFinder.getMathTransformFactory(null).createAffineTransform((Matrix)matrix);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

