/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.render.impl;

import java.io.IOException;
import java.util.Set;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IStyleBlackboard;
import net.refractions.udig.project.internal.render.Renderer;
import net.refractions.udig.project.render.AbstractRenderMetrics;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.IRenderMetricsFactory;
import net.refractions.udig.project.render.IRenderer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.geotools.util.Range;

public class InternalRenderMetricsFactory
implements IRenderMetricsFactory {
    final IRenderMetricsFactory delegate;
    private IConfigurationElement element;

    public InternalRenderMetricsFactory(IRenderMetricsFactory delegate, IConfigurationElement element) {
        this.delegate = delegate;
        this.element = element;
    }

    @Override
    public boolean canRender(IRenderContext context) throws IOException {
        return this.delegate.canRender(context);
    }

    @Override
    public InternalRenderMetrics createMetrics(IRenderContext context) {
        return new InternalRenderMetrics(this.delegate.createMetrics(context), this.element);
    }

    @Override
    public Class<? extends IRenderer> getRendererType() {
        return this.delegate.getRendererType();
    }

    public static class InternalRenderMetrics
    extends AbstractRenderMetrics {
        final AbstractRenderMetrics delegate;
        private String name;
        private String description;
        private String id;

        public InternalRenderMetrics(AbstractRenderMetrics delegate, IConfigurationElement element) {
            super(delegate.getRenderContext(), delegate.getRenderMetricsFactory(), delegate.getExpectedStyles());
            this.delegate = delegate;
            this.name = element.getAttribute("name");
            this.id = String.valueOf(element.getNamespaceIdentifier()) + "." + element.getAttribute("id");
            IConfigurationElement[] descChild = element.getChildren("description");
            if (descChild.length > 0) {
                this.description = descChild[0].getValue();
            }
        }

        @Override
        public boolean canAddLayer(ILayer layer) {
            return this.delegate.canAddLayer(layer);
        }

        @Override
        public boolean canStyle(String styleID, Object value) {
            return this.delegate.canStyle(styleID, value);
        }

        @Override
        public Renderer createRenderer() {
            return this.delegate.createRenderer();
        }

        @Override
        public IRenderContext getRenderContext() {
            return this.delegate.getRenderContext().copy();
        }

        @Override
        public IRenderMetricsFactory getRenderMetricsFactory() {
            return this.delegate.getRenderMetricsFactory();
        }

        public String getDescription() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public Set<Range<Double>> getValidScaleRanges() {
            return this.delegate.getValidScaleRanges();
        }

        @Override
        public long getDrawingTimeMetric() {
            return this.delegate.getDrawingTimeMetric();
        }

        @Override
        public long getLatencyMetric() {
            return this.delegate.getLatencyMetric();
        }

        @Override
        public double getResolutionMetric() {
            return this.delegate.getResolutionMetric();
        }

        @Override
        public double getRenderAppearanceMetric(IStyleBlackboard blackboard) {
            return this.delegate.getRenderAppearanceMetric(blackboard);
        }

        @Override
        public double getUserAppearanceMetric(IStyleBlackboard blackboard) {
            return this.delegate.getUserAppearanceMetric(blackboard);
        }
    }
}

