/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.render.impl;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.render.CompositeRenderContext;
import net.refractions.udig.project.internal.render.MultiLayerRenderer;
import net.refractions.udig.project.internal.render.RenderContext;
import net.refractions.udig.project.internal.render.RenderExecutor;
import net.refractions.udig.project.internal.render.RenderFactory;
import net.refractions.udig.project.internal.render.RenderListenerAdapter;
import net.refractions.udig.project.internal.render.RenderManager;
import net.refractions.udig.project.internal.render.Renderer;
import net.refractions.udig.project.internal.render.RendererCreator;
import net.refractions.udig.project.internal.render.SelectionLayer;
import net.refractions.udig.project.internal.render.impl.CompositeContextListener;
import net.refractions.udig.project.internal.render.impl.CompositeRenderContextImpl;
import net.refractions.udig.project.internal.render.impl.RenderContextImpl;
import net.refractions.udig.project.internal.render.impl.RendererImpl;
import net.refractions.udig.project.render.ILabelPainter;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.RenderException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class CompositeRendererImpl
extends RendererImpl
implements MultiLayerRenderer {
    private static final Comparator<? super RenderExecutor> comparator = new Comparator<RenderExecutor>(){

        @Override
        public int compare(RenderExecutor e1, RenderExecutor e2) {
            return e1.getContext().getLayer().compareTo(e2.getContext().getLayer());
        }
    };
    public static final String copyright = "uDig - User Friendly Desktop Internet GIS client\nhttp://udig.refractions.net\n(C) 2004-2012, Refractions Research Inc.\n\n\nAll rights reserved. This program and the accompanying materials\nare made available under the terms of the Eclipse Public License v1.0\n(http://www.eclipse.org/legal/epl-v10.html), and the Refractions BSD\nLicense v1.0 (http://udig.refractions.net/files/bsd3-v10.html).\n";
    static final AffineTransform IDENTITY = new AffineTransform();
    CompositeContextListener contextListener = new CompositeContextListener(){

        private void add(List<RenderContext> contexts) {
            ArrayList<RenderExecutor> renderers = new ArrayList<RenderExecutor>();
            for (RenderContext context : contexts) {
                if (CompositeRendererImpl.this.findExecutor(context) != null) continue;
                Renderer renderer = CompositeRendererImpl.this.getRendererCreator(context).getRenderer(context);
                renderers.add(CompositeRendererImpl.this.createRenderExecutor(renderer));
            }
            if (!renderers.isEmpty()) {
                CompositeRendererImpl.this.getRenderExecutors().addAll(renderers);
            }
        }

        @Override
        public void notifyChanged(CompositeRenderContext context, List<RenderContext> contexts, boolean added) {
            if (added) {
                this.add(contexts);
            } else {
                this.remove(contexts);
            }
        }

        private void remove(List<RenderContext> contexts) {
            for (RenderContext context : contexts) {
                RenderExecutor executor = CompositeRendererImpl.this.findExecutor(context);
                if (executor == null) continue;
                CompositeRendererImpl.this.getRenderExecutors().remove(executor);
                executor.dispose();
            }
        }
    };
    RendererCreator rendererCreator = null;
    private final Set<RenderExecutor> renderExecutors = new CopyOnWriteArraySet<RenderExecutor>();

    protected CompositeRendererImpl() {
    }

    public List<Renderer> children() {
        ArrayList<Renderer> children = new ArrayList<Renderer>();
        for (RenderExecutor victim : this.getRenderExecutors()) {
            children.add(victim.getRenderer());
        }
        return children;
    }

    protected RenderExecutor createRenderExecutor(Renderer renderer) {
        final RenderExecutor executor = RenderFactory.eINSTANCE.createRenderExecutor(renderer);
        executor.eAdapters().add((Object)new RenderListenerAdapter(){

            @Override
            protected void renderDisposed(Notification msg) {
                EObject obj = (EObject)this.getTarget();
                obj.eAdapters().remove((Object)this);
            }

            @Override
            protected void renderDone() {
                CompositeRendererImpl.this.setState(4);
            }

            @Override
            protected void renderRequest() {
                CompositeRendererImpl.this.setRenderBounds(executor.getRenderBounds());
                CompositeRendererImpl.this.setState(16);
            }

            @Override
            protected void renderStarting() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void renderUpdate() {
                CompositeRendererImpl compositeRendererImpl = CompositeRendererImpl.this;
                synchronized (compositeRendererImpl) {
                    CompositeRendererImpl.this.setState(2);
                }
            }
        });
        return executor;
    }

    @Override
    public synchronized void dispose() {
        for (RenderExecutor renderer : this.getRenderExecutors()) {
            renderer.dispose();
        }
        this.getRenderExecutors().clear();
    }

    protected RenderExecutor findExecutor(IRenderContext context) {
        for (RenderExecutor executor : this.getRenderExecutors()) {
            if (!executor.getRenderer().getContext().equals(context)) continue;
            return executor;
        }
        return null;
    }

    @Override
    public CompositeRenderContext getContext() {
        return (CompositeRenderContext)super.getContext();
    }

    public List getIChildren() {
        return this.children();
    }

    public IRenderContext getIContext() {
        return this.getContext();
    }

    RendererCreator getRendererCreator(IRenderContext context) {
        this.rendererCreator = ((RenderManager)context.getRenderManager()).getRendererCreator();
        this.rendererCreator.setContext((RenderContext)context);
        return this.rendererCreator;
    }

    public Collection<RenderExecutor> getRenderExecutors() {
        return this.renderExecutors;
    }

    private boolean isFullAlphaUsed(RenderExecutor executor) {
        Object object = this.getContext().getMap().getBlackboard().get("MYLAR");
        if (object == null || !((Boolean)object).booleanValue()) {
            return true;
        }
        if (executor.getContext() instanceof CompositeRenderContext) {
            CompositeRenderContext context = (CompositeRenderContext)executor.getContext();
            return context.getLayers().contains(this.getContext().getSelectedLayer());
        }
        return executor.getContext().getLayer() == this.getContext().getSelectedLayer();
    }

    @Override
    public void refreshImage() throws RenderException {
        this.refreshImage(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshImage(boolean paintLabels) throws RenderException {
        if (this.getContext().getMapDisplay() == null) {
            return;
        }
        CompositeRenderContext compositeRenderContext = this.getContext();
        synchronized (compositeRenderContext) {
            Graphics g = null;
            try {
                try {
                    TreeSet<? super RenderExecutor> executors;
                    Object background;
                    BufferedImage current = this.getContext().getImage();
                    BufferedImage copy = new BufferedImage(current.getWidth(), current.getHeight(), current.getType());
                    g = (Graphics2D)copy.getGraphics();
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    IMap map = this.getContext().getMap();
                    Object object = map.getBlackboard().get("mapBackgroundColor");
                    if (object == null) {
                        ScopedPreferenceStore store = ProjectPlugin.getPlugin().getPreferenceStore();
                        background = PreferenceConverter.getColor((IPreferenceStore)store, (String)"backgroundColor");
                        map.getBlackboard().put("mapBackgroundColor", new Color(background.red, background.green, background.blue));
                        object = map.getBlackboard().get("mapBackgroundColor");
                    }
                    ((Graphics2D)g).setBackground((Color)object);
                    g.clearRect(0, 0, copy.getWidth(), copy.getHeight());
                    background = this.renderExecutors;
                    synchronized (background) {
                        executors = new TreeSet<RenderExecutor>(comparator);
                        executors.addAll(this.getRenderExecutors());
                    }
                    ILabelPainter cache = this.getContext().getLabelPainter();
                    for (RenderExecutor renderExecutor : executors) {
                        if (!renderExecutor.getContext().isVisible()) {
                            if (!paintLabels || renderExecutor.getContext().getLayer() instanceof SelectionLayer) continue;
                            cache.disableLayer(renderExecutor.getContext().getLayer().getID().toString());
                            continue;
                        }
                        if (renderExecutor.getState() == 1 || renderExecutor.getState() == 32 || renderExecutor.getState() == 16) continue;
                        if (this.isFullAlphaUsed(renderExecutor)) {
                            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 1.0f));
                        } else {
                            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.5f));
                        }
                        ((Graphics2D)g).drawRenderedImage(renderExecutor.getContext().getImage(), IDENTITY);
                    }
                    if (paintLabels) {
                        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        ((Graphics2D)g).setRenderingHints(renderingHints);
                        Dimension displaySize = this.getContext().getMapDisplay().getDisplaySize();
                        try {
                            cache.end((Graphics2D)g, new Rectangle(displaySize));
                        }
                        catch (Throwable t) {
                            ProjectPlugin.trace(CompositeRenderContextImpl.class, "painting labels failed", t);
                        }
                    }
                    ((RenderContextImpl)((Object)this.getContext())).setImage(copy);
                }
                catch (IllegalStateException illegalStateException) {
                    this.stopRendering();
                    if (g != null) {
                        g.dispose();
                    }
                    return;
                }
            }
            finally {
                if (g != null) {
                    g.dispose();
                }
            }
        }
    }

    @Override
    public void render(Graphics2D destination, IProgressMonitor monitor) throws RenderException {
        for (RenderExecutor executor : this.renderExecutors) {
            executor.getRenderer().setState(32);
        }
        for (RenderExecutor executor : this.renderExecutors) {
            executor.render();
        }
    }

    @Override
    public void render(IProgressMonitor monitor) throws RenderException {
        if (this.getRenderExecutors().size() == 0) {
            this.setState(4);
        }
        for (RenderExecutor renderExecutor : this.getRenderExecutors()) {
            renderExecutor.setRenderBounds((Envelope)this.getRenderBounds());
            renderExecutor.render();
        }
    }

    @Override
    public void setContext(IRenderContext newContext) {
        if (this.context != null) {
            ((CompositeRenderContext)this.context).removeListener(this.contextListener);
        }
        if (newContext != null) {
            CompositeRenderContext compositeRenderContext = (CompositeRenderContext)newContext;
            compositeRenderContext.addListener(this.contextListener);
            for (IRenderContext context : compositeRenderContext.getContexts()) {
                if (this.findExecutor(context) != null) continue;
                Renderer renderer = this.getRendererCreator(context).getRenderer((RenderContext)context);
                this.getRenderExecutors().add(this.createRenderExecutor(renderer));
            }
            super.setContext(newContext);
        }
    }

    public void stopRendering() {
        for (RenderExecutor element : this.getRenderExecutors()) {
            element.stopRendering();
        }
    }
}

