/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.render.impl;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IStyleBlackboard;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.render.MultiLayerRenderer;
import net.refractions.udig.project.render.AbstractRenderMetrics;
import org.geotools.util.Range;

public class AbstractRenderMetricsSorter
implements Comparator<AbstractRenderMetrics>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Layer> layersCopy;
    protected final double WEIGHT_RENDER_APPEARANCE_METRIC = 0.2;
    protected final double WEIGHT_USER_APPEARANCE_METRIC = 0.25;
    protected final double WEIGHT_SCALERANGE_METRIC = 0.15;
    protected final double WEIGHT_LATENCY_METRIC = 0.1;
    protected final double WEIGHT_DRAWING_TIME_METRIC = 0.1;
    protected final double WEIGHT_RESOLUTION_METRIC = 0.1;
    protected final double WEIGHT_MULTILAYER_METRIC = 0.1;
    protected final long MAXIMUM_LATENCY = 120000L;
    protected final long MAXIMUM_DRAWINGTIME = 120000L;

    public AbstractRenderMetricsSorter(List<Layer> layers) {
        this.layersCopy = layers;
    }

    public List<Layer> getLayers() {
        return this.layersCopy;
    }

    @Override
    public int compare(AbstractRenderMetrics o1, AbstractRenderMetrics o2) {
        if (!this.canRender(o1)) {
            if (!this.canRender(o2)) {
                return 0;
            }
            return 1;
        }
        if (!this.canRender(o2)) {
            return -1;
        }
        return this.compareMetrics(o1, o2);
    }

    private boolean canRender(AbstractRenderMetrics o1) {
        block3: {
            try {
                if (o1.getRenderMetricsFactory() != null) break block3;
                ProjectPlugin.log(o1 + " is not implemented correctly.  getRenderMetricsFactory returns null.  " + "Consider extending AbstractRenderMetrics");
                return false;
            }
            catch (Throwable e) {
                ProjectPlugin.log("Error while calling CanRender() on " + o1.toString(), e);
                return false;
            }
        }
        return o1.getRenderMetricsFactory().canRender(o1.getRenderContext());
    }

    private int compareMetrics(AbstractRenderMetrics o1, AbstractRenderMetrics o2) {
        double r2;
        int first = -1;
        int last = 1;
        int perferredMapRenderer = this.rateUsingBlackboardSettings(o1, o1.getRenderContext().getMap().getBlackboard());
        if (perferredMapRenderer > 0) {
            return first;
        }
        if (perferredMapRenderer < 0) {
            return last;
        }
        double r1 = this.rate(o1);
        if (r1 > (r2 = this.rate(o2))) {
            return last;
        }
        if (r1 < r2) {
            return first;
        }
        return 0;
    }

    private double rate(AbstractRenderMetrics metrics) {
        ILayer layer = metrics.getRenderContext().getLayer();
        IStyleBlackboard style = layer.getStyleBlackboard();
        double renderAppearanceMetric = 1.0 - metrics.getUserAppearanceMetric(style);
        double userAppearanceMetric = 1.0 - metrics.getRenderAppearanceMetric(style);
        double latencyMetric = metrics.getLatencyMetric();
        latencyMetric /= 120000.0;
        double drawingTimeMetric = metrics.getDrawingTimeMetric();
        drawingTimeMetric /= 120000.0;
        double width = metrics.getRenderContext().getMapDisplay().getWidth();
        double resolutionMetric = metrics.getResolutionMetric();
        double diff = Math.abs(resolutionMetric - 1.0);
        resolutionMetric = diff == 0.0 ? 0.0 : diff / width;
        int multiLayerMetric = 1 - this.rateMultiLayerRenderer(metrics);
        double scaleRangeMetric = 1 - this.rateScaleRange(metrics);
        double rating = renderAppearanceMetric * 0.2;
        rating += userAppearanceMetric * 0.25;
        rating += latencyMetric * 0.1;
        rating += drawingTimeMetric * 0.1;
        rating += resolutionMetric * 0.1;
        rating += (double)multiLayerMetric * 0.1;
        return rating += scaleRangeMetric * 0.15;
    }

    private int rateScaleRange(AbstractRenderMetrics metrics) {
        Set<Range<Double>> scales = metrics.getValidScaleRanges();
        for (Range<Double> range : scales) {
            if (!range.contains((Comparable)Double.valueOf(metrics.getRenderContext().getViewportModel().getScaleDenominator()))) continue;
            return 1;
        }
        return 0;
    }

    private int rateUsingBlackboardSettings(AbstractRenderMetrics metrics, IBlackboard blackboard) {
        String rendererId = metrics.getId();
        if (rendererId == null) {
            return 0;
        }
        String preferredRenderer = blackboard.getString("PREFERRED_RENDERER_ID");
        String lastResortRenderer = blackboard.getString("LAST_RESORT_RENDERER_ID");
        if (rendererId.equals(preferredRenderer)) {
            return 1;
        }
        if (rendererId.equals(lastResortRenderer)) {
            return -1;
        }
        return 0;
    }

    private int rateMultiLayerRenderer(AbstractRenderMetrics metrics) {
        if (MultiLayerRenderer.class.isAssignableFrom(metrics.getRenderMetricsFactory().getRendererType())) {
            int indexOf = this.getLayers().indexOf(metrics.getRenderContext().getLayer());
            if (indexOf > 0 && metrics.canAddLayer(this.getLayers().get(indexOf - 1))) {
                return 1;
            }
            if (indexOf < this.getLayers().size() - 1 && metrics.canAddLayer(this.getLayers().get(indexOf + 1))) {
                return 1;
            }
        }
        return 0;
    }
}

