/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.render;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.StyleContent;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.ProjectPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.function.FilterFunction_geometryType;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.UserLayer;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Fill;

public class SelectionStyleContent
extends StyleContent {
    public static final String ID = "net.refractions.udig.project.selectionStyle";
    private static final StyleBuilder builder = new StyleBuilder();
    private static final StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
    private static final String fTypeName = "fTypeName";
    private StyleBuilder styleBuilder = new StyleBuilder();

    private static Color getSelectionColor() {
        ScopedPreferenceStore store = ProjectPlugin.getPlugin().getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"P_SELECTION_COLOR");
        return new Color(rgb.red, rgb.green, rgb.blue);
    }

    private static Color getSelectionColor2() {
        ScopedPreferenceStore store = ProjectPlugin.getPlugin().getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"P_SELECTION2_COLOR");
        return new Color(rgb.red, rgb.green, rgb.blue, 75);
    }

    public SelectionStyleContent() {
        super(ID);
    }

    public Class getStyleClass() {
        return Style.class;
    }

    @Override
    public void save(IMemento momento, Object value) {
        Style style = (Style)value;
        momento.putString(fTypeName, style.getFeatureTypeStyles()[0].getFeatureTypeName());
    }

    @Override
    public Object load(IMemento momento) {
        return null;
    }

    @Override
    public Object createDefaultStyle(IGeoResource resource, Color colour, IProgressMonitor monitor) {
        return null;
    }

    public static Style createDefaultStyle(Layer layer) {
        SimpleFeatureType schema = layer.getSchema();
        return SelectionStyleContent.createDefaultStyle(schema);
    }

    private static Style createDefaultStyle(SimpleFeatureType schema) {
        Style style = builder.createStyle();
        SelectionStyleContent ssc = new SelectionStyleContent();
        if (schema == null) {
            return null;
        }
        GeometryDescriptor geom = schema.getGeometryDescriptor();
        if (SelectionStyleContent.isLine(geom)) {
            ssc.getDefaultRule(style).setSymbolizers(SelectionStyleContent.createLineSymbolizers(ssc));
        } else if (SelectionStyleContent.isPoint(geom)) {
            int size = SelectionStyleContent.queryPointSize(style);
            PointSymbolizer sym = ssc.createPointSymbolizer(SelectionStyleContent.getSelectionColor(), size);
            Symbolizer[] symbolizers = new Symbolizer[]{sym};
            ssc.getDefaultRule(style).setSymbolizers(symbolizers);
        } else if (SelectionStyleContent.isPolygon(geom)) {
            ssc.getDefaultRule(style).setSymbolizers(SelectionStyleContent.createPolygonSymbolizarts(ssc));
        } else {
            try {
                int size = SelectionStyleContent.queryPointSize(style);
                ssc.createGeometrySLD(SelectionStyleContent.getSelectionColor2(), SelectionStyleContent.getSelectionColor(), schema.getGeometryDescriptor().getName().getLocalPart(), style, size);
            }
            catch (Exception e) {
                ProjectPlugin.log("", e);
                ssc.getDefaultRule(style).setSymbolizers(new Symbolizer[]{ssc.createLineSymbolizer(SelectionStyleContent.getSelectionColor2(), false), ssc.createLineSymbolizer(SelectionStyleContent.getSelectionColor(), true)});
            }
        }
        SelectionStyleContent.createDefaultStyledLayerDescriptor(style);
        return style;
    }

    private static int queryPointSize(Object style) {
        Mark mark;
        PointSymbolizer pointSymbolizer;
        int size = 6;
        if (style instanceof Style && (pointSymbolizer = SLD.pointSymbolizer((Style)((Style)style))) != null && (mark = SLD.mark((PointSymbolizer)pointSymbolizer)) != null) {
            size = SLD.size((Mark)mark);
        }
        if (style instanceof FeatureTypeStyle && (pointSymbolizer = SLD.pointSymbolizer((FeatureTypeStyle)((FeatureTypeStyle)style))) != null && (mark = SLD.mark((PointSymbolizer)pointSymbolizer)) != null) {
            size = SLD.size((Mark)mark);
        }
        return size;
    }

    private static Symbolizer[] createLineSymbolizers(SelectionStyleContent ssc) {
        return new Symbolizer[]{ssc.createLineSymbolizer(SelectionStyleContent.getSelectionColor2(), false, 3, 0.5), ssc.createLineSymbolizer(SelectionStyleContent.getSelectionColor(), true)};
    }

    private static Symbolizer[] createPolygonSymbolizarts(SelectionStyleContent ssc) {
        return new Symbolizer[]{ssc.createPolygonSymbolizer(SelectionStyleContent.getSelectionColor(), true), ssc.createLineSymbolizer(SelectionStyleContent.getSelectionColor2(), false, 3, 0.5), ssc.createLineSymbolizer(SelectionStyleContent.getSelectionColor(), false, 1, 1.0)};
    }

    private PropertyIsEqualTo createGeometryFunctionFilter(String geomXPath, Object geometryClassSimpleName) throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        FilterFunction_geometryType geomTypeExpr = new FilterFunction_geometryType();
        List<Expression> params = Arrays.asList(factory.property(geomXPath));
        geomTypeExpr.setParameters(params);
        PropertyIsEqualTo filter = factory.equals((Expression)geomTypeExpr, (Expression)factory.literal(geometryClassSimpleName));
        return filter;
    }

    private void createGeometrySLD(Color colour, Color colour2, String geomXPath, Style style, int size) throws IllegalFilterException {
        Rule rule = this.getDefaultRule(style);
        PropertyIsEqualTo filter = this.createGeometryFunctionFilter(geomXPath, Point.class.getSimpleName());
        rule.setFilter((Filter)filter);
        Symbolizer[] pointSymbolizers = new Symbolizer[]{this.createPointSymbolizer(colour, size)};
        rule.setSymbolizers(pointSymbolizers);
        this.getDefaultFeatureTypeStyle(style).addRule(rule);
        rule = this.styleBuilder.createRule(new Symbolizer[0]);
        filter = this.createGeometryFunctionFilter(geomXPath, MultiPoint.class.getSimpleName());
        rule.setFilter((Filter)filter);
        rule.setSymbolizers(pointSymbolizers);
        this.getDefaultFeatureTypeStyle(style).addRule(rule);
        rule = this.styleBuilder.createRule(new Symbolizer[0]);
        filter = this.createGeometryFunctionFilter(geomXPath, LineString.class.getSimpleName());
        rule.setFilter((Filter)filter);
        Symbolizer[] lineSymbolizers = SelectionStyleContent.createLineSymbolizers(this);
        rule.setSymbolizers(lineSymbolizers);
        this.getDefaultFeatureTypeStyle(style).addRule(rule);
        rule = this.styleBuilder.createRule(new Symbolizer[0]);
        filter = this.createGeometryFunctionFilter(geomXPath, LinearRing.class.getSimpleName());
        rule.setFilter((Filter)filter);
        rule.setSymbolizers(lineSymbolizers);
        this.getDefaultFeatureTypeStyle(style).addRule(rule);
        rule = this.styleBuilder.createRule(new Symbolizer[0]);
        filter = this.createGeometryFunctionFilter(geomXPath, MultiLineString.class.getSimpleName());
        rule.setFilter((Filter)filter);
        rule.setSymbolizers(lineSymbolizers);
        this.getDefaultFeatureTypeStyle(style).addRule(rule);
        rule = this.styleBuilder.createRule(new Symbolizer[0]);
        filter = this.createGeometryFunctionFilter(geomXPath, Polygon.class.getSimpleName());
        rule.setFilter((Filter)filter);
        Symbolizer[] polygonSymbolizers = SelectionStyleContent.createPolygonSymbolizarts(this);
        rule.setSymbolizers(polygonSymbolizers);
        this.getDefaultFeatureTypeStyle(style).addRule(rule);
        rule = this.styleBuilder.createRule(new Symbolizer[0]);
        filter = this.createGeometryFunctionFilter(geomXPath, MultiPolygon.class.getSimpleName());
        rule.setFilter((Filter)filter);
        rule.setSymbolizers(polygonSymbolizers);
        this.getDefaultFeatureTypeStyle(style).addRule(rule);
    }

    public Rule getDefaultRule(Style style) {
        FeatureTypeStyle ftStyle = this.getDefaultFeatureTypeStyle(style);
        if (ftStyle.getRules() == null || ftStyle.getRules().length == 0) {
            Rule rule = this.styleBuilder.createRule(new Symbolizer[0]);
            ftStyle.addRule(rule);
            return rule;
        }
        return ftStyle.getRules()[0];
    }

    public FeatureTypeStyle getDefaultFeatureTypeStyle(Style style) {
        style.featureTypeStyles();
        FeatureTypeStyle[] styles = style.getFeatureTypeStyles();
        if (styles == null || styles.length == 0 || styles[0].getRules().length == 0) {
            FeatureTypeStyle ftStyle = this.styleBuilder.createFeatureTypeStyle("default", new Rule[0]);
            style.addFeatureTypeStyle(ftStyle);
            return ftStyle;
        }
        return styles[0];
    }

    protected PointSymbolizer createPointSymbolizer(Color colour, int size) {
        org.geotools.styling.Fill fill = this.styleBuilder.createFill(Color.YELLOW, 0.0);
        Stroke stroke = builder.createStroke(colour, 2.0);
        Mark mark = this.styleBuilder.createMark("square", fill, stroke);
        Graphic graph2 = this.styleBuilder.createGraphic(null, mark, null, 1.0, (double)size, 0.0);
        PointSymbolizer symb = this.styleBuilder.createPointSymbolizer(graph2);
        symb.getGraphic().setMarks(new Mark[]{mark});
        return symb;
    }

    protected LineSymbolizer createLineSymbolizer(Color colour, boolean dashed) {
        return this.createLineSymbolizer(colour, dashed, 1, 1.0);
    }

    protected LineSymbolizer createLineSymbolizer(Color colour, boolean dashed, int thickness, double opacity) {
        LineSymbolizer symbolizer = this.styleBuilder.createLineSymbolizer();
        Stroke stroke = builder.createStroke(colour, (double)thickness, opacity);
        symbolizer.setStroke((org.opengis.style.Stroke)stroke);
        return symbolizer;
    }

    protected PolygonSymbolizer createPolygonSymbolizer(Color colour, boolean dashed) {
        PolygonSymbolizer symbolizer = this.styleBuilder.createPolygonSymbolizer();
        org.geotools.styling.Fill fill = this.styleBuilder.createFill();
        fill.setColor(this.styleBuilder.colorExpression(colour));
        fill.setOpacity(this.styleBuilder.literalExpression(0.5));
        symbolizer.setFill((Fill)fill);
        return symbolizer;
    }

    @Override
    public Object load(URL url, IProgressMonitor monitor) throws IOException {
        return null;
    }

    private static StyledLayerDescriptor createDefaultStyledLayerDescriptor(Style style) {
        StyledLayerDescriptor sld = styleFactory.createStyledLayerDescriptor();
        UserLayer layer = styleFactory.createUserLayer();
        sld.addStyledLayer((StyledLayer)layer);
        layer.addUserStyle(style);
        return sld;
    }

    public static final boolean isPolygon(SimpleFeatureType featureType) {
        if (featureType == null) {
            return false;
        }
        return SelectionStyleContent.isPolygon(featureType.getGeometryDescriptor());
    }

    public static final boolean isPolygon(GeometryDescriptor geometryType) {
        if (geometryType == null) {
            return false;
        }
        Class type = geometryType.getType().getBinding();
        return Polygon.class.isAssignableFrom(type) || MultiPolygon.class.isAssignableFrom(type);
    }

    public static final boolean isLine(SimpleFeatureType featureType) {
        if (featureType == null) {
            return false;
        }
        return SelectionStyleContent.isLine(featureType.getGeometryDescriptor());
    }

    public static final boolean isLine(GeometryDescriptor geometryType) {
        if (geometryType == null) {
            return false;
        }
        Class type = geometryType.getType().getBinding();
        return LineString.class.isAssignableFrom(type) || MultiLineString.class.isAssignableFrom(type);
    }

    public static final boolean isPoint(SimpleFeatureType featureType) {
        if (featureType == null) {
            return false;
        }
        return SelectionStyleContent.isPoint(featureType.getGeometryDescriptor());
    }

    public static final boolean isPoint(GeometryDescriptor geometryType) {
        if (geometryType == null) {
            return false;
        }
        Class type = geometryType.getType().getBinding();
        return Point.class.isAssignableFrom(type) || MultiPoint.class.isAssignableFrom(type);
    }
}

