/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.property;

import java.net.URL;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolveChangeListener;
import net.refractions.udig.catalog.objectproperty.ObjectPropertyCatalogListener;
import net.refractions.udig.project.BlackboardEvent;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.IBlackboardListener;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.ui.operations.AbstractPropertyValue;
import net.refractions.udig.ui.operations.PropertyValue;
import org.geotools.data.FeatureSource;

public class FeatureSourceResourceProperty
extends AbstractPropertyValue<ILayer>
implements PropertyValue<ILayer> {
    private volatile AtomicBoolean isEvaluating = new AtomicBoolean(false);
    private Set<URL> ids = new CopyOnWriteArraySet<URL>();

    public boolean canCacheResult() {
        return false;
    }

    public boolean isBlocking() {
        return false;
    }

    public boolean isTrue(final ILayer object, String value) {
        this.isEvaluating.set(true);
        try {
            boolean canResolve;
            object.getBlackboard().addListener(new IBlackboardListener(){

                @Override
                public void blackBoardChanged(BlackboardEvent event) {
                    if (event.getKey().equals("net.refractions.udig.project.view")) {
                        FeatureSourceResourceProperty.this.notifyListeners(object);
                    }
                }

                @Override
                public void blackBoardCleared(IBlackboard source) {
                    FeatureSourceResourceProperty.this.notifyListeners(object);
                }
            });
            IGeoResource resource = object.findGeoResource(FeatureSource.class);
            if (resource != null && this.ids.add(resource.getIdentifier())) {
                CatalogPlugin.getDefault().getLocalCatalog().addCatalogListener((IResolveChangeListener)new ObjectPropertyCatalogListener((Object)object, resource, this.isEvaluating, (AbstractPropertyValue)this));
            }
            boolean bl = canResolve = resource.canResolve(FeatureSource.class);
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
        finally {
            this.isEvaluating.set(false);
        }
    }
}

