/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.interceptor;

import java.awt.Color;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.xml.transform.TransformerException;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.internal.ui.FilterTextTransfer;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IResourceInterceptor;
import net.refractions.udig.project.StyleContent;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.ui.ProgressManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IMemento;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.view.DefaultView;
import org.geotools.feature.SchemaException;
import org.geotools.filter.FilterFilter;
import org.geotools.filter.FilterHandler;
import org.geotools.filter.FilterTransformer;
import org.geotools.gml.GMLFilterDocument;
import org.geotools.gml.GMLFilterGeometry;
import org.geotools.gml.GMLHandlerGeometry;
import org.geotools.gml.GMLHandlerJTS;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ShowViewInterceptor
implements IResourceInterceptor<FeatureSource<SimpleFeatureType, SimpleFeature>> {
    public static final String KEY = "net.refractions.udig.project.view";

    public static boolean isFilter(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Filter) {
            Filter filter = (Filter)value;
            return filter != Filter.INCLUDE;
        }
        if (value instanceof Query) {
            Query query = (Query)value;
            if (query == Query.ALL) {
                return false;
            }
            if (query.getFilter() == Filter.INCLUDE && query.getPropertyNames() == Query.ALL_NAMES) {
                return false;
            }
            return !Query.ALL.equals((Object)query);
        }
        return false;
    }

    @Override
    public FeatureSource<SimpleFeatureType, SimpleFeature> run(ILayer layer, FeatureSource<SimpleFeatureType, SimpleFeature> resource, Class<? super FeatureSource<SimpleFeatureType, SimpleFeature>> requestedType) {
        Object prop = layer.getStyleBlackboard().get(KEY);
        if (prop == null) {
            prop = layer.getBlackboard().get(KEY);
        }
        if (!ShowViewInterceptor.isFilter(prop)) {
            return resource;
        }
        if (prop instanceof Filter || prop instanceof Query) {
            try {
                IGeoResource geoResource = layer.findGeoResource(FeatureSource.class);
                IService service = geoResource.service(ProgressManager.instance().get(new Object[0]));
                if (service != null) {
                    DefaultView view;
                    DataStore ds = (DataStore)service.resolve(DataStore.class, ProgressManager.instance().get(new Object[0]));
                    if (ds == null) {
                        return resource;
                    }
                    String typeName = ((SimpleFeatureType)resource.getSchema()).getTypeName();
                    Query query = prop instanceof Filter ? new Query(typeName, (Filter)prop) : (Query)prop;
                    if (!layer.getStyleBlackboard().contains(KEY)) {
                        layer.getStyleBlackboard().put(KEY, query);
                    }
                    if (!typeName.equals(query.getTypeName())) {
                        query = ShowViewInterceptor.createQuery(query.getFilter(), query.getCoordinateSystem(), query.getCoordinateSystemReproject(), query.getHandle(), query.getMaxFeatures(), query.getNamespace(), query.getPropertyNames(), typeName);
                    }
                    if (requestedType.isInstance(view = new DefaultView((SimpleFeatureSource)resource, query))) {
                        return view;
                    }
                    return null;
                }
            }
            catch (IOException e) {
                ProjectPlugin.log("Error getting view", e);
            }
            catch (SchemaException e) {
                ProjectPlugin.log("Error getting view", e);
            }
        }
        return resource;
    }

    private static Query createQuery(Filter filter, CoordinateReferenceSystem crs, CoordinateReferenceSystem reproject, String handle, Integer maxFeature, URI namespace, String[] propertyNames, String typeName) {
        Query query = new Query();
        if (namespace != null) {
            query = new Query(typeName, namespace, filter, maxFeature.intValue(), propertyNames, handle);
        }
        if (crs != null) {
            query.setCoordinateSystem(crs);
        }
        if (reproject != null) {
            query.setCoordinateSystemReproject(reproject);
        }
        if (filter != null) {
            query.setFilter(filter);
        }
        if (handle != null) {
            query.setHandle(handle);
        }
        if (maxFeature != null) {
            query.setMaxFeatures(maxFeature.intValue());
        }
        if (propertyNames != null) {
            query.setPropertyNames(propertyNames);
        }
        if (typeName != null) {
            query.setTypeName(typeName);
        }
        return query;
    }

    public static class ViewStyleContent
    extends StyleContent {
        private static final String CRS = "CRS";
        private static final String REPOJECT = "REPOJECT";
        private static final String HANDLE = "HANDLE";
        private static final String MAX_FEATURES = "MAX_FEATURES";
        private static final String NAMESPACE = "NAMESPACE";
        private static final String TYPENAME = "TYPENAME";
        private static final String PROPERTY_NAMES = "PROPERTY_NAMES";

        public ViewStyleContent() {
            super(ShowViewInterceptor.KEY);
        }

        @Override
        public Object createDefaultStyle(IGeoResource resource, Color colour, IProgressMonitor monitor) throws IOException {
            return null;
        }

        public Class<? extends Object> getStyleClass() {
            return Query.class;
        }

        @Override
        public Object load(IMemento memento) {
            URI namespace;
            String textData = memento.getTextData();
            Object filter = textData == null || textData.trim().length() == 0 ? Filter.INCLUDE : this.readFilter(this.decode(textData));
            CoordinateReferenceSystem crs = this.readCRS(memento.getString(CRS));
            CoordinateReferenceSystem reproject = this.readCRS(memento.getString(REPOJECT));
            String handle = this.decode(memento.getString(HANDLE));
            Integer maxFeature = memento.getInteger(MAX_FEATURES);
            try {
                String uriString = this.decode(memento.getString(NAMESPACE));
                namespace = uriString != null ? new URI(uriString) : null;
            }
            catch (URISyntaxException uRISyntaxException) {
                namespace = null;
            }
            String propNameString = this.decode(memento.getString(PROPERTY_NAMES));
            String[] propertyNames = propNameString != null ? propNameString.split(",") : Query.ALL_NAMES;
            String typeName = this.decode(memento.getString(TYPENAME));
            Query query = ShowViewInterceptor.createQuery((Filter)filter, crs, reproject, handle, maxFeature, namespace, propertyNames, typeName);
            return query;
        }

        private CoordinateReferenceSystem readCRS(String string) {
            try {
                return org.geotools.referencing.CRS.parseWKT((String)this.decode(string));
            }
            catch (Exception exception) {
                return null;
            }
        }

        private Filter readFilter(String textData) {
            if ("all".equals(textData)) {
                return Filter.EXCLUDE;
            }
            InputSource input = new InputSource(new StringReader(textData));
            FilterTextTransfer.SimpleFilterHandler simpleFilterHandler = new FilterTextTransfer.SimpleFilterHandler();
            FilterFilter filterFilter = new FilterFilter((FilterHandler)simpleFilterHandler, null);
            GMLFilterGeometry filterGeometry = new GMLFilterGeometry((GMLHandlerJTS)filterFilter);
            GMLFilterDocument filterDocument = new GMLFilterDocument((GMLHandlerGeometry)filterGeometry);
            try {
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setContentHandler((ContentHandler)filterDocument);
                reader.parse(input);
            }
            catch (Exception exception) {
                return Filter.INCLUDE;
            }
            return simpleFilterHandler.getFilter();
        }

        @Override
        public Object load(URL url, IProgressMonitor monitor) throws IOException {
            return null;
        }

        @Override
        public void save(IMemento memento, Object value) {
            Query viewRestriction;
            Filter filter;
            if (value instanceof Filter) {
                filter = (Filter)value;
                viewRestriction = new Query("Feature", filter);
            } else {
                viewRestriction = value instanceof Query ? (Query)value : Query.ALL;
            }
            filter = viewRestriction.getFilter();
            CoordinateReferenceSystem crs = viewRestriction.getCoordinateSystem();
            CoordinateReferenceSystem reproject = viewRestriction.getCoordinateSystemReproject();
            String handle = viewRestriction.getHandle();
            int maxFeature = viewRestriction.getMaxFeatures();
            URI namespace = viewRestriction.getNamespace();
            String[] propertyNames = viewRestriction.getPropertyNames();
            String typeName = viewRestriction.getTypeName();
            StringBuilder propertyNamesString = new StringBuilder();
            if (propertyNames != null) {
                String[] stringArray = propertyNames;
                int n = propertyNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    propertyNamesString.append(string);
                    propertyNamesString.append(',');
                    ++n2;
                }
            }
            if (filter != null) {
                FilterTransformer transformer = new FilterTransformer();
                try {
                    if (filter == Filter.EXCLUDE) {
                        memento.putTextData("all");
                    } else {
                        memento.putTextData(this.encode(transformer.transform(filter)));
                    }
                }
                catch (TransformerException transformerException) {
                    throw new RuntimeException("Unable to convert filter to string I couldn't save the view query");
                }
            }
            if (crs != null) {
                memento.putString(CRS, this.encode(crs.toWKT()));
            }
            if (reproject != null) {
                memento.putString(REPOJECT, this.encode(reproject.toWKT()));
            }
            if (handle != null) {
                memento.putString(HANDLE, this.encode(handle));
            }
            if (maxFeature != Integer.MAX_VALUE) {
                memento.putInteger(MAX_FEATURES, new Integer(maxFeature).intValue());
            }
            if (namespace != null) {
                memento.putString(NAMESPACE, this.encode(namespace.toString()));
            }
            if (typeName != null) {
                memento.putString(TYPENAME, this.encode(typeName));
            }
            if (propertyNames != null) {
                memento.putString(PROPERTY_NAMES, this.encode(propertyNamesString.toString()));
            }
        }

        private String encode(String toEncode) {
            if (toEncode == null) {
                return null;
            }
            try {
                return URLEncoder.encode(toEncode, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return toEncode;
            }
        }

        private String decode(String toDecode) {
            if (toDecode == null) {
                return null;
            }
            try {
                return URLDecoder.decode(toDecode, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return toDecode;
            }
        }
    }
}

