/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.impl;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTWriter;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.Interaction;
import net.refractions.udig.project.internal.EditManager;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.impl.UDIGStore;
import org.geotools.data.DataAccess;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.Transaction;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;

public class UDIGFeatureStore
implements FeatureStore<FeatureType, Feature>,
UDIGStore {
    FeatureStore<FeatureType, Feature> wrapped;
    ILayer layer;

    public UDIGFeatureStore(FeatureStore<FeatureType, Feature> featureStore, ILayer layer) {
        this.wrapped = featureStore;
        this.layer = layer;
    }

    public Name getName() {
        return this.wrapped.getName();
    }

    public ResourceInfo getInfo() {
        return this.wrapped.getInfo();
    }

    public void removeFeatures(Filter filter) throws IOException {
        this.setTransactionInternal();
        this.wrapped.removeFeatures(filter);
    }

    @Deprecated
    public void modifyFeatures(AttributeDescriptor[] descriptors, Object[] values, Filter filter) throws IOException {
        this.setTransactionInternal();
        this.wrapped.modifyFeatures(descriptors, values, filter);
    }

    public void modifyFeatures(Name[] names, Object[] values, Filter filter) throws IOException {
        this.setTransactionInternal();
        this.wrapped.modifyFeatures(names, values, filter);
    }

    public void modifyFeatures(Name name, Object value, Filter filter) throws IOException {
        this.setTransactionInternal();
        this.wrapped.modifyFeatures(name, value, filter);
    }

    @Deprecated
    public void modifyFeatures(AttributeDescriptor attribute, Object value, Filter selectFilter) throws IOException {
        Geometry geom;
        this.setTransactionInternal();
        if (value instanceof Geometry && !(geom = (Geometry)value).isValid()) {
            WKTWriter writer = new WKTWriter();
            String wkt = writer.write(geom);
            String where = selectFilter.toString();
            if (selectFilter instanceof Id) {
                Id id = (Id)selectFilter;
                where = id.getIDs().toString();
            }
            String msg = "Modify fetures (WHERE " + where + ") failed with invalid geometry:" + wkt;
            ProjectPlugin.log(msg);
            throw new IOException(msg);
        }
        this.wrapped.modifyFeatures(attribute, value, selectFilter);
    }

    public void setFeatures(FeatureReader<FeatureType, Feature> features) throws IOException {
        this.setTransactionInternal();
        this.wrapped.setFeatures(features);
    }

    public void setTransaction(Transaction transaction) {
        throw new IllegalArgumentException(String.valueOf(Messages.UDIGFeatureStore_0) + Messages.UDIGFeatureStore_1);
    }

    @Override
    public void editComplete() {
        this.wrapped.setTransaction(Transaction.AUTO_COMMIT);
    }

    private void setTransactionInternal() {
        if (!this.layer.getInteraction(Interaction.EDIT)) {
            String message = "Attempted to open a transaction on a non-editable layer (Aborted)";
            IllegalStateException illegalStateException = new IllegalStateException(message);
            ProjectPlugin.log(message, illegalStateException);
            throw illegalStateException;
        }
        EditManager editManager = (EditManager)this.layer.getMap().getEditManager();
        Transaction transaction = editManager.getTransaction();
        if (this.wrapped.getTransaction() == Transaction.AUTO_COMMIT) {
            this.wrapped.setTransaction(transaction);
        } else if (this.wrapped.getTransaction() != transaction) {
            String msg = "Layer transaction already set " + this.wrapped.getTransaction();
            IllegalStateException illegalStateException = new IllegalStateException(msg);
            ProjectPlugin.log(msg, illegalStateException);
            throw illegalStateException;
        }
    }

    @Override
    public void startTransaction() {
        if (this.wrapped.getTransaction() == Transaction.AUTO_COMMIT) {
            Transaction transaction = ((EditManager)this.layer.getMap().getEditManager()).getTransaction();
            this.wrapped.setTransaction(transaction);
        }
    }

    public Transaction getTransaction() {
        return this.wrapped.getTransaction();
    }

    public DataAccess<FeatureType, Feature> getDataStore() {
        return this.wrapped.getDataStore();
    }

    public void addFeatureListener(FeatureListener listener) {
        this.wrapped.addFeatureListener(listener);
    }

    public void removeFeatureListener(FeatureListener listener) {
        this.wrapped.removeFeatureListener(listener);
    }

    public FeatureCollection<FeatureType, Feature> getFeatures(Query query) throws IOException {
        return this.wrapped.getFeatures(query);
    }

    public FeatureCollection<FeatureType, Feature> getFeatures(Filter filter) throws IOException {
        return this.wrapped.getFeatures(filter);
    }

    public FeatureCollection<FeatureType, Feature> getFeatures() throws IOException {
        return this.wrapped.getFeatures();
    }

    public FeatureType getSchema() {
        return this.wrapped.getSchema();
    }

    public ReferencedEnvelope getBounds() throws IOException {
        return this.wrapped.getBounds();
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        return this.wrapped.getBounds(query);
    }

    public int getCount(Query query) throws IOException {
        return this.wrapped.getCount(query);
    }

    public List<FeatureId> addFeatures(FeatureCollection<FeatureType, Feature> features) throws IOException {
        this.setTransactionInternal();
        return this.wrapped.addFeatures(features);
    }

    @Override
    public boolean sameSource(Object source) {
        return source == this.wrapped || source == this;
    }

    public FeatureStore<?, ?> wrapped() {
        return this.wrapped;
    }

    public Set<RenderingHints.Key> getSupportedHints() {
        return this.wrapped.getSupportedHints();
    }

    public QueryCapabilities getQueryCapabilities() {
        return this.wrapped.getQueryCapabilities();
    }
}

