/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.Lock;
import net.refractions.udig.ui.UDIGDisplaySafeLock;
import org.eclipse.emf.common.util.EList;

public class SynchronizedEList<T>
implements EList<T> {
    private EList<T> wrapped;
    Lock lock = new UDIGDisplaySafeLock();

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public SynchronizedEList(EList<T> list) {
        this.wrapped = list;
    }

    public void add(int arg0, T arg1) {
        this.lock.lock();
        try {
            this.wrapped.add(arg0, arg1);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean add(T arg0) {
        this.lock.lock();
        try {
            boolean bl = this.wrapped.add(arg0);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean addAll(Collection<? extends T> arg0) {
        this.lock.lock();
        try {
            boolean bl = this.wrapped.addAll(arg0);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean addAll(int arg0, Collection<? extends T> arg1) {
        this.lock.lock();
        try {
            boolean bl = this.wrapped.addAll(arg0, arg1);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            this.wrapped.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean contains(Object arg0) {
        this.lock.lock();
        try {
            boolean bl = this.wrapped.contains(arg0);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean containsAll(Collection<?> arg0) {
        this.lock.lock();
        try {
            boolean bl = this.wrapped.containsAll(arg0);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean equals(Object arg0) {
        this.lock.lock();
        try {
            boolean bl = this.wrapped.equals(arg0);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public T get(int arg0) {
        this.lock.lock();
        try {
            Object object = this.wrapped.get(arg0);
            return (T)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int hashCode() {
        this.lock.lock();
        try {
            int n = this.wrapped.hashCode();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int indexOf(Object arg0) {
        this.lock.lock();
        try {
            int n = this.wrapped.indexOf(arg0);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.wrapped.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Iterator<T> iterator() {
        return this.listIterator();
    }

    public int lastIndexOf(Object arg0) {
        this.lock.lock();
        try {
            int n = this.wrapped.lastIndexOf(arg0);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    public ListIterator<T> listIterator(int arg0) {
        return new ListIterator<T>(){
            ListIterator<T> iter;
            {
                this.iter = SynchronizedEList.this.wrapped.listIterator();
            }

            @Override
            public boolean hasNext() {
                SynchronizedEList.this.lock();
                try {
                    boolean bl = this.iter.hasNext();
                    return bl;
                }
                finally {
                    SynchronizedEList.this.unlock();
                }
            }

            @Override
            public T next() {
                SynchronizedEList.this.lock();
                try {
                    Object t = this.iter.next();
                    return t;
                }
                finally {
                    SynchronizedEList.this.unlock();
                }
            }

            @Override
            public void remove() {
                SynchronizedEList.this.lock();
                try {
                    this.iter.remove();
                }
                finally {
                    SynchronizedEList.this.unlock();
                }
            }

            @Override
            public void add(T o) {
                SynchronizedEList.this.lock();
                try {
                    this.iter.add(o);
                }
                finally {
                    SynchronizedEList.this.unlock();
                }
            }

            @Override
            public boolean hasPrevious() {
                SynchronizedEList.this.lock();
                try {
                    boolean bl = this.iter.hasPrevious();
                    return bl;
                }
                finally {
                    SynchronizedEList.this.unlock();
                }
            }

            @Override
            public int nextIndex() {
                SynchronizedEList.this.lock();
                try {
                    int n = this.iter.nextIndex();
                    return n;
                }
                finally {
                    SynchronizedEList.this.unlock();
                }
            }

            @Override
            public T previous() {
                SynchronizedEList.this.lock();
                try {
                    Object t = this.iter.previous();
                    return t;
                }
                finally {
                    SynchronizedEList.this.unlock();
                }
            }

            @Override
            public int previousIndex() {
                SynchronizedEList.this.lock();
                try {
                    int n = this.iter.previousIndex();
                    return n;
                }
                finally {
                    SynchronizedEList.this.unlock();
                }
            }

            @Override
            public void set(T o) {
                SynchronizedEList.this.lock();
                try {
                    this.iter.set(o);
                }
                finally {
                    SynchronizedEList.this.unlock();
                }
            }
        };
    }

    public T move(int arg0, int arg1) {
        this.lock.lock();
        try {
            Object object = this.wrapped.move(arg0, arg1);
            return (T)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void move(int arg0, T arg1) {
        this.lock.lock();
        try {
            this.wrapped.move(arg0, arg1);
        }
        finally {
            this.lock.unlock();
        }
    }

    public T remove(int arg0) {
        this.lock.lock();
        try {
            Object object = this.wrapped.remove(arg0);
            return (T)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean remove(Object arg0) {
        this.lock.lock();
        try {
            boolean bl = this.wrapped.remove(arg0);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean removeAll(Collection<?> arg0) {
        this.lock.lock();
        try {
            boolean bl = this.wrapped.removeAll(arg0);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean retainAll(Collection<?> arg0) {
        this.lock.lock();
        try {
            boolean bl = this.wrapped.retainAll(arg0);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public T set(int arg0, T arg1) {
        this.lock.lock();
        try {
            Object object = this.wrapped.set(arg0, arg1);
            return (T)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.wrapped.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<T> subList(int arg0, int arg1) {
        this.lock.lock();
        try {
            List list = this.wrapped.subList(arg0, arg1);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Object[] toArray() {
        this.lock.lock();
        try {
            Object[] objectArray = this.wrapped.toArray();
            return objectArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    public <E> E[] toArray(E[] arg0) {
        this.lock.lock();
        try {
            Object[] objectArray = this.wrapped.toArray((Object[])arg0);
            return objectArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static <T> EList<T> create(EList<T> adapters) {
        return new SynchronizedEList<T>(adapters);
    }
}

