/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import net.refractions.udig.core.internal.ExtensionPointProcessor;
import net.refractions.udig.core.internal.ExtensionPointUtil;
import net.refractions.udig.project.BlackboardEvent;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.IBlackboardListener;
import net.refractions.udig.project.StyleContent;
import net.refractions.udig.project.internal.ProjectFactory;
import net.refractions.udig.project.internal.ProjectPackage;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.project.internal.StyleEntry;
import net.refractions.udig.ui.UDIGDisplaySafeLock;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class StyleBlackboardImpl
extends EObjectImpl
implements StyleBlackboard {
    protected EList<StyleEntry> content;
    Lock contentLock = new UDIGDisplaySafeLock();
    protected HashMap<String, StyleContent> id2content = new HashMap();
    CopyOnWriteArraySet<IBlackboardListener> listeners = new CopyOnWriteArraySet();

    protected StyleBlackboardImpl() {
    }

    protected EClass eStaticClass() {
        return ProjectPackage.Literals.STYLE_BLACKBOARD;
    }

    @Override
    public List<StyleEntry> getContent() {
        if (this.content == null) {
            this.content = new EObjectContainmentEList(StyleEntry.class, (InternalEObject)this, 0);
        }
        return this.content;
    }

    @Override
    public Object get(String styleId) {
        StyleEntry entry = this.getEntry(styleId);
        if (entry == null) {
            return null;
        }
        return this.getObject(entry);
    }

    private StyleEntry getEntry(String styleId) {
        StyleEntry entry = null;
        this.contentLock.lock();
        try {
            for (StyleEntry se : this.getContent()) {
                if (!se.getID().equals(styleId)) continue;
                entry = se;
                break;
            }
        }
        finally {
            this.contentLock.unlock();
        }
        return entry;
    }

    @Override
    public Object lookup(Class<?> theClass) {
        StyleEntry entry = null;
        this.contentLock.lock();
        try {
            for (StyleEntry se : this.getContent()) {
                try {
                    if (se.getStyleClass() == null) {
                        StyleContent styleContent = this.getStyleContent(se.getID());
                        if (styleContent == null) continue;
                        Class<?> type = styleContent.getStyleClass();
                        if (type == null) {
                            se.getStyle();
                            type = styleContent.getStyleClass();
                            if (type == null) continue;
                        }
                        se.setStyleClass(type);
                    }
                    if (!theClass.isAssignableFrom(se.getStyleClass())) continue;
                    entry = se;
                    break;
                }
                catch (Throwable t) {
                    ProjectPlugin.log("Style " + se.getID() + " not restored:" + t.getLocalizedMessage(), t);
                }
            }
        }
        finally {
            this.contentLock.unlock();
        }
        if (entry == null) {
            return null;
        }
        return this.getObject(entry);
    }

    protected Object getObject(StyleEntry styleEntry) {
        if (styleEntry.getStyle() == null) {
            try {
                StyleContent styleContent = this.getStyleContent(styleEntry.getID());
                String mementoString = styleEntry.getMemento();
                if (mementoString != null) {
                    XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(mementoString));
                    Object style = styleContent.load((IMemento)memento);
                    styleEntry.setStyle(style);
                    if (style != null) {
                        styleEntry.setStyleClass(style.getClass());
                    }
                }
            }
            catch (WorkbenchException e) {
                ProjectPlugin.getPlugin().log(String.valueOf(styleEntry.getID()) + ":" + (Object)((Object)e));
                e.printStackTrace();
            }
        }
        return styleEntry.getStyle();
    }

    @Override
    public boolean contains(String styleId) {
        return this.get(styleId) != null;
    }

    @Override
    public void put(String styleId, Object style) {
        Object oldValue = this.remove(styleId);
        StyleEntry se = ProjectFactory.eINSTANCE.createStyleEntry();
        se.setID(styleId);
        se.setStyle(style);
        this.content.add((Object)se);
        StyleContent styleContent = this.getStyleContent(styleId);
        if (styleContent == null) {
            return;
        }
        try {
            XMLMemento memento = XMLMemento.createWriteRoot((String)"styleEntry");
            styleContent.save((IMemento)memento, style);
            StringWriter writer = new StringWriter();
            memento.save((Writer)writer);
            se.setMemento(writer.getBuffer().toString());
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BlackboardEvent event = new BlackboardEvent(this, styleId, oldValue, style);
        for (IBlackboardListener l : this.listeners) {
            try {
                l.blackBoardChanged(event);
            }
            catch (Exception e) {
                ProjectPlugin.log("", e);
            }
        }
    }

    @Override
    public void put(URL url, IProgressMonitor monitor) {
        this.createStyleEntry(url, monitor);
    }

    private StyleContent getStyleContent(String styleId) {
        StyleContent styleContent = this.id2content.get(styleId);
        if (styleContent == null) {
            this.loadStyleContent(styleId);
            styleContent = this.id2content.get(styleId);
        }
        return styleContent;
    }

    private void loadStyleContent(final String styleId) {
        this.id2content.put(styleId, StyleContent.DEFAULT);
        ExtensionPointProcessor p = new ExtensionPointProcessor(){
            boolean found = false;

            public void process(IExtension extension, IConfigurationElement element) throws Exception {
                if (!this.found && element.getAttribute("id").equals(styleId)) {
                    this.found = true;
                    StyleContent styleContent = (StyleContent)element.createExecutableExtension("class");
                    StyleBlackboardImpl.this.id2content.put(styleId, styleContent);
                }
            }
        };
        ExtensionPointUtil.process((Plugin)ProjectPlugin.getPlugin(), (String)"net.refractions.udig.project.style", (ExtensionPointProcessor)p);
    }

    private Object createStyleEntry(URL url, IProgressMonitor monitor) {
        URLProcessor p = new URLProcessor(url, monitor);
        ExtensionPointUtil.process((Plugin)ProjectPlugin.getPlugin(), (String)"net.refractions.udig.project.style", (ExtensionPointProcessor)p);
        if (p.style != null) {
            this.put(p.id, p.style);
        }
        return p.style;
    }

    @Override
    public Object remove(String styleId) {
        Object style = null;
        this.contentLock.lock();
        try {
            Iterator<StyleEntry> seItr = this.getContent().iterator();
            while (seItr.hasNext()) {
                StyleEntry se = seItr.next();
                if (!se.getID().equals(styleId)) continue;
                style = se.getStyle();
                seItr.remove();
            }
        }
        finally {
            this.contentLock.unlock();
        }
        return style;
    }

    @Override
    public Object clone() {
        StyleBlackboardImpl clone;
        try {
            clone = (StyleBlackboardImpl)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            clone = (StyleBlackboardImpl)ProjectFactory.eINSTANCE.createStyleBlackboard();
        }
        clone.content = null;
        this.contentLock.lock();
        try {
            for (StyleEntry styleEntry : this.getContent()) {
                StyleEntry styleEntryClone = ProjectFactory.eINSTANCE.createStyleEntry();
                String ID2 = styleEntry.getID();
                styleEntryClone.setID(ID2);
                styleEntryClone.setMemento(styleEntry.getMemento());
                Object style = styleEntry.getStyle();
                if (style instanceof String) {
                    styleEntryClone.setStyle(style);
                } else if (style instanceof Serializable) {
                    try {
                        Serializable cfr_ignored_0 = (Serializable)style;
                        ByteArrayOutputStream save = new ByteArrayOutputStream();
                        ObjectOutputStream out = new ObjectOutputStream(save);
                        out.writeObject(style);
                        out.close();
                        byte[] data = save.toByteArray();
                        ByteArrayInputStream restore = new ByteArrayInputStream(data);
                        ObjectInputStream in = new ObjectInputStream(restore);
                        Object copy = in.readObject();
                        in.close();
                        styleEntryClone.setStyle(copy);
                    }
                    catch (Throwable t) {
                        ProjectPlugin.trace(StyleBlackboardImpl.class, "Unable to copy style " + ID2 + ":" + style, t);
                    }
                } else {
                    styleEntryClone.setStyle(style);
                    ProjectPlugin.trace(StyleBlackboardImpl.class, "Unable to copy style " + ID2 + ":" + style, null);
                }
                clone.getContent().add(styleEntryClone);
            }
        }
        finally {
            this.contentLock.unlock();
        }
        return clone;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getContent()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getContent();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getContent().clear();
                this.getContent().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getContent().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.content != null && !this.content.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public Float getFloat(String key) {
        Object value;
        if (this.contains(key) && (value = this.get(key)) instanceof Float) {
            return (Float)value;
        }
        return null;
    }

    @Override
    public Integer getInteger(String key) {
        Object value;
        if (this.contains(key) && (value = this.get(key)) instanceof Integer) {
            return (Integer)value;
        }
        return null;
    }

    @Override
    public String getString(String key) {
        Object value;
        if (this.contains(key) && (value = this.get(key)) instanceof String) {
            return (String)value;
        }
        return null;
    }

    @Override
    public void putFloat(String key, float value) {
        this.put(key, Float.valueOf(value));
    }

    @Override
    public void putInteger(String key, int value) {
        this.put(key, value);
    }

    @Override
    public void putString(String key, String value) {
        this.put(key, value);
    }

    @Override
    public void clear() {
        if (this.content == null) {
            return;
        }
        this.content.clear();
        for (IBlackboardListener l : this.listeners) {
            try {
                l.blackBoardCleared(this);
            }
            catch (Exception e) {
                ProjectPlugin.log("", e);
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public boolean addListener(IBlackboardListener listener) {
        return this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(IBlackboardListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void setSelected(String[] ids) {
        List<String> idList = Arrays.asList(ids);
        this.contentLock.lock();
        try {
            List<StyleEntry> entries = this.getContent();
            for (StyleEntry entry : entries) {
                if (idList.contains(entry.getID())) {
                    entry.setSelected(true);
                    continue;
                }
                entry.setSelected(false);
            }
        }
        finally {
            this.contentLock.unlock();
        }
    }

    @Override
    public boolean isSelected(String styleId) {
        StyleEntry entry = this.getEntry(styleId);
        return entry != null && entry.isSelected();
    }

    @Override
    public void addAll(IBlackboard blackboard) {
        Set<String> keySet = blackboard.keySet();
        for (String key : keySet) {
            this.put(key, blackboard.get(key));
        }
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        for (StyleEntry entry : this.content) {
            if (entry == null) continue;
            keys.add(entry.getID());
        }
        return keys;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("StyleBlackBoardImpl: ");
        buf.append(this.content.size());
        buf.append(" entries");
        for (StyleEntry entry : this.content) {
            buf.append("\n\t");
            buf.append(entry.getID());
            buf.append("=");
            buf.append(entry.getStyle());
        }
        return buf.toString();
    }

    class URLProcessor
    implements ExtensionPointProcessor {
        boolean found = false;
        Object style = null;
        String id;
        URL url;
        IProgressMonitor monitor;

        public URLProcessor(URL url, IProgressMonitor monitor) {
            this.url = url;
            this.monitor = monitor;
        }

        public void process(IExtension extension, IConfigurationElement element) throws Exception {
            if (this.found) {
                return;
            }
            StyleContent styleContent = (StyleContent)element.createExecutableExtension("class");
            this.style = styleContent.load(this.url, this.monitor);
            if (this.style != null) {
                this.id = styleContent.getId();
                StyleBlackboardImpl.this.id2content.put(styleContent.getId(), styleContent);
                this.found = true;
            }
        }
    }
}

