/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.project.IProject;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.ProjectFactory;
import net.refractions.udig.project.internal.ProjectPackage;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.ProjectRegistry;
import net.refractions.udig.project.internal.impl.SynchronizedEList;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;

public class ProjectRegistryImpl
extends EObjectImpl
implements ProjectRegistry {
    protected Project currentProject;
    protected List projects = null;
    private static ResourceSetImpl resourceSet;
    private static ProjectRegistry projectRegistry;

    protected ProjectRegistryImpl() {
    }

    protected EClass eStaticClass() {
        return ProjectPackage.Literals.PROJECT_REGISTRY;
    }

    @Override
    public List<Project> getProjects() {
        if (this.projects == null) {
            this.projects = new EObjectResolvingEList(Project.class, (InternalEObject)this, 1);
        }
        Iterator iter = this.projects.iterator();
        while (iter.hasNext()) {
            Project project = (Project)iter.next();
            if (project.eResource() != null) continue;
            iter.remove();
        }
        return this.projects;
    }

    @Override
    public Project getDefaultProject() {
        String projectName = Messages.ProjectRegistry_defaultName;
        String path = new File(String.valueOf(Platform.getLocation().toString()) + File.separatorChar + projectName).getAbsolutePath();
        this.currentProject = this.getProject(path);
        return this.currentProject;
    }

    @Override
    public Project getCurrentProject() {
        Project p = this.getCurrentProjectGen();
        if (p == null && this.getProjects().size() > 0) {
            p = this.getProjects().get(0);
        }
        if (p == null) {
            p = this.getDefaultProject();
        }
        return p;
    }

    public Project getCurrentProjectGen() {
        if (this.currentProject != null && this.currentProject.eIsProxy()) {
            InternalEObject oldCurrentProject = (InternalEObject)this.currentProject;
            this.currentProject = (Project)this.eResolveProxy(oldCurrentProject);
            if (this.currentProject != oldCurrentProject && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 0, (Object)oldCurrentProject, (Object)this.currentProject));
            }
        }
        return this.currentProject;
    }

    public Project basicGetCurrentProject() {
        return this.currentProject;
    }

    @Override
    public void setCurrentProject(Project newCurrentProject) {
        Project oldCurrentProject = this.currentProject;
        this.currentProject = newCurrentProject;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldCurrentProject, (Object)this.currentProject));
        }
    }

    public NotificationChain eSetResource(Resource.Internal resource, NotificationChain notifications) {
        if (resource == null || resource.getResourceSet() != resourceSet || resourceSet == null) {
            throw new AssertionError();
        }
        return super.eSetResource(resource, notifications);
    }

    @Override
    public Project getProject(URI uri) {
        try {
            if (this.findProject(uri) != null) {
                return this.findProject(uri);
            }
            URI projectURI = URI.createURI((String)uri.toString());
            final ProjectRegistry registry = ProjectRegistryImpl.getProjectRegistry();
            Resource registryResource = registry.eResource();
            if (registryResource == null) {
                System.out.println("Registery was unable to load");
                throw new Error(Messages.ProjectRegistryImpl_load_error);
            }
            URI registryURI = registryResource.getURI();
            projectURI.deresolve(registryURI, true, true, true);
            ResourceSet registeryResourceSet = registryResource.getResourceSet();
            Resource projectResource = registeryResourceSet.createResource(projectURI);
            try {
                projectResource.load(null);
            }
            catch (IOException iOException) {}
            Project incomingProject = null;
            if (projectResource.getContents().isEmpty()) {
                File file;
                if (projectURI.isFile() && (file = new File(projectURI.toFileString())).exists() && !file.delete()) {
                    throw new NullPointerException("Unable to load " + uri + " file was empty");
                }
                incomingProject = this.createProject(uri, projectResource);
            } else {
                EList contents = projectResource.getContents();
                for (EObject eObject : contents) {
                    if (!(eObject instanceof Project)) continue;
                    incomingProject = (Project)eObject;
                    break;
                }
                if (incomingProject == null) {
                    throw new NullPointerException("Unable to load " + uri + " - does not contain a project");
                }
            }
            final Project newProject = incomingProject;
            PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        ProjectRegistryImpl.this.setCurrentProject(newProject);
                        registry.getProjects().add(newProject);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            return newProject;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Project findProject(URI uri) {
        List<Project> projects = this.getProjects();
        for (Project project : projects) {
            if (!ProjectRegistryImpl.isURIEqual(project.eResource().getURI(), uri)) continue;
            return project;
        }
        return null;
    }

    public static boolean isURIEqual(URI uri, URI uri2) {
        if (uri.equals((Object)uri2)) {
            return true;
        }
        String uriString = uri.toString();
        String uri2String = uri2.toString();
        uriString = ProjectRegistryImpl.replaceBackSlashes(uriString);
        uri2String = ProjectRegistryImpl.replaceBackSlashes(uri2String);
        uriString = uriString.replace("://", ":/");
        uri2String = uri2String.replace("://", ":/");
        return uriString.equals(uri2String);
    }

    private static String replaceBackSlashes(String uriString) {
        StringBuffer buffer = new StringBuffer(uriString.length());
        int i = 0;
        while (i < uriString.length()) {
            char charAt = uriString.charAt(i);
            if (charAt == '\\') {
                buffer.append('/');
            } else {
                buffer.append(charAt);
            }
            ++i;
        }
        return buffer.toString();
    }

    private Project createProject(URI uri, Resource resource) {
        Project tmpProject = ProjectFactory.eINSTANCE.createProject();
        String path = uri.toFileString();
        int start = path.indexOf(File.separator) != -1 ? path.lastIndexOf(File.separator) : 0;
        int end = path.indexOf(46) != -1 ? path.lastIndexOf(46) : path.length() - 1;
        tmpProject.setName(path.substring(start + 1, end));
        resource.getContents().add((Object)tmpProject);
        resource.setModified(true);
        return tmpProject;
    }

    @Override
    public Project getProject(String projectPath) {
        URL url;
        if (projectPath.startsWith("file:")) {
            try {
                url = new URL(projectPath);
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("Unable to turn " + projectPath + " into a URL to load");
                return null;
            }
        } else {
            File file = new File(projectPath);
            url = URLUtils.fileToURL((File)file);
        }
        String uriText = String.valueOf(url.toExternalForm()) + File.separatorChar + "project.uprj";
        URI uri = URI.createURI((String)uriText);
        Project project = this.getProject(uri);
        return project;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                if (resolve) {
                    return this.getCurrentProject();
                }
                return this.basicGetCurrentProject();
            }
            case 1: {
                return this.getProjects();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setCurrentProject((Project)newValue);
                return;
            }
            case 1: {
                this.getProjects().clear();
                this.getProjects().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setCurrentProject(null);
                return;
            }
            case 1: {
                this.getProjects().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.currentProject != null;
            }
            case 1: {
                return this.projects != null && !this.projects.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public IProject getDefaultIProject() {
        return this.getDefaultProject();
    }

    public IProject getCurrentIProject() {
        return this.getCurrentProject();
    }

    public void setICurrentProject(IProject value) {
        this.setCurrentProject((Project)value);
    }

    public IProject getIProject(String projectPath) {
        return this.getProject(projectPath);
    }

    public List getIProjects() {
        return this.getProjects();
    }

    private static synchronized ProjectRegistry load() {
        ProjectRegistry projectRegistry = null;
        try {
            IPath registrypath = Platform.getLocation().append(".projectRegistry");
            URI uri = URI.createURI((String)("file://" + registrypath.toOSString()));
            projectRegistry = ProjectRegistryImpl.backwardsCompatibility(projectRegistry, registrypath, uri);
            if (projectRegistry == null) {
                resourceSet = new ResourceSetImpl();
                if (registrypath.toFile().exists()) {
                    Resource resource = resourceSet.getResource(uri, true);
                    resourceSet.eSetDeliver(false);
                    projectRegistry = (ProjectRegistry)resource.getContents().get(0);
                    if (projectRegistry == null) {
                        projectRegistry = ProjectFactory.eINSTANCE.createProjectRegistry();
                        resource.getContents().add((Object)projectRegistry);
                    }
                } else {
                    Resource resource = resourceSet.createResource(uri);
                    if (resource == null) {
                        throw new Exception("Unable to load or create ProjectRegistry resource");
                    }
                    projectRegistry = new ProjectRegistryImpl();
                    resource.getContents().add((Object)projectRegistry);
                }
            }
        }
        catch (Exception exception) {
            ProjectPlugin.INSTANCE.log(exception);
        }
        if (projectRegistry == null) {
            ProjectPlugin.log("Error getting project from resource");
        } else {
            final ProjectRegistry registry = projectRegistry;
            projectRegistry.eAdapters().add((Object)new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeatureID(ProjectRegistry.class) == 1) {
                        registry.eResource().setModified(true);
                    }
                }
            });
        }
        resourceSet.eSetDeliver(false);
        return projectRegistry;
    }

    private static ProjectRegistry backwardsCompatibility(ProjectRegistry projectRegistry, IPath registrypath, URI uri) {
        IPath oldregistrypath = ProjectPlugin.getPlugin().getStateLocation().append("ProjectRegistry");
        URI olduri = URI.createURI((String)("file://" + oldregistrypath.toOSString()));
        if (oldregistrypath.toFile().exists()) {
            resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.getResource(olduri, true);
            resourceSet.eSetDeliver(false);
            projectRegistry = (ProjectRegistry)resource.getContents().get(0);
            if (projectRegistry != null) {
                resourceSet = new ResourceSetImpl();
                resource = resourceSet.createResource(uri);
                resource.getContents().add((Object)projectRegistry);
                oldregistrypath.toFile().deleteOnExit();
            }
        }
        return projectRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectRegistry getProjectRegistry() {
        Class<ProjectRegistry> clazz = ProjectRegistry.class;
        synchronized (ProjectRegistry.class) {
            if (projectRegistry == null) {
                projectRegistry = ProjectRegistryImpl.load();
            }
            if (projectRegistry.eResource() == null || projectRegistry.eResource().getResourceSet() != resourceSet || resourceSet == null) {
                throw new AssertionError();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return projectRegistry;
        }
    }

    public EList<Adapter> eAdapters() {
        return SynchronizedEList.create(super.eAdapters());
    }
}

