/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.CommandManager;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.ProjectElement;
import net.refractions.udig.project.internal.ProjectPackage;
import net.refractions.udig.project.internal.commands.DefaultErrorHandler;
import net.refractions.udig.project.internal.impl.SynchronizedEObjectWithInverseResolvingEList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.InternalEList;

public class ProjectImpl
extends EObjectImpl
implements Project {
    protected static final String NAME_EDEFAULT = "";
    protected String name = "";
    protected EList<ProjectElement> elementsInternal;
    private Adapter projectPersistenceListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            switch (msg.getFeatureID(Project.class)) {
                case 0: 
                case 1: {
                    if (ProjectImpl.this.eResource() == null) break;
                    ProjectImpl.this.eResource().setModified(true);
                }
            }
        }
    };
    CommandManager commandManager;

    protected ProjectImpl() {
        this.eAdapters().add((Object)this.projectPersistenceListener);
    }

    protected EClass eStaticClass() {
        return ProjectPackage.Literals.PROJECT;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public List<ProjectElement> getElementsInternal() {
        if (this.elementsInternal == null) {
            this.elementsInternal = new SynchronizedEObjectWithInverseResolvingEList<ProjectElement>(ProjectElement.class, (InternalEObject)this, 1, 1){
                private static final long serialVersionUID = 3978658123285628492L;

                protected void didAdd(int index, ProjectElement newObject) {
                    ProjectImpl.this.createResourceAndAddElement(ProjectImpl.this, newObject);
                    super.didAdd(index, (Object)newObject);
                }

                protected void didSet(int index, ProjectElement newObject, ProjectElement oldObject) {
                    ProjectImpl.this.createResourceAndAddElement(ProjectImpl.this, newObject);
                    super.didSet(index, (Object)newObject, (Object)oldObject);
                }
            };
        }
        return this.elementsInternal;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getElementsInternal()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getElementsInternal()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getElementsInternal();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setName((String)newValue);
                return;
            }
            case 1: {
                this.getElementsInternal().clear();
                this.getElementsInternal().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.getElementsInternal().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 1: {
                return this.elementsInternal != null && !this.elementsInternal.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public List getElements(Class type) {
        ArrayList<ProjectElement> lists = new ArrayList<ProjectElement>();
        for (ProjectElement obj : this.getElementsInternal()) {
            if (!type.isAssignableFrom(obj.getClass())) continue;
            lists.add(obj);
        }
        return lists;
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }

    public List getElements() {
        return Collections.unmodifiableList(this.getElementsInternal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCommandManager() {
        Class<CommandManager> clazz = CommandManager.class;
        synchronized (CommandManager.class) {
            if (this.commandManager == null) {
                this.commandManager = new CommandManager(Messages.ProjectImpl_commandManagerName, new DefaultErrorHandler());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void sendASync(Command command) {
        this.initCommandManager();
        this.commandManager.aSyncExecute(command);
    }

    @Override
    public void sendSync(Command command) {
        this.initCommandManager();
        this.commandManager.syncExecute(command);
    }

    private void createResourceAndAddElement(Project value, ProjectElement projectElement) {
        if (projectElement == null || projectElement.eIsProxy()) {
            return;
        }
        Resource projectResource = this.eResource();
        if (projectResource != null) {
            URI projectURI = projectResource.getURI();
            String elementPath = null;
            elementPath = this.findElementResourcePath(projectElement, elementPath);
            String projectPath = ProjectImpl.findProjectResourcePath(projectURI);
            if (!projectPath.equals(elementPath)) {
                ProjectImpl.doCreation(projectElement, projectResource, elementPath, projectPath);
            }
        }
    }

    private static void doCreation(ProjectElement projectElement, Resource projectResource, String elementPath, String projectPath) {
        Resource resource = null;
        URI uri = ProjectImpl.createNewResource(projectResource, projectPath, projectElement);
        resource = projectResource.getResourceSet().createResource(uri);
        resource.getContents().add((Object)projectElement);
        resource.setTrackingModification(true);
        resource.setModified(true);
    }

    private static String findProjectResourcePath(URI projectURI) {
        String projectPath = projectURI.toFileString();
        projectPath = projectPath.substring(0, projectPath.lastIndexOf(File.separatorChar));
        while (projectPath.startsWith(String.valueOf(File.separator) + File.separator)) {
            projectPath = projectPath.substring(1);
        }
        if (Platform.getOS().equals("win32") && projectPath.startsWith(File.separator)) {
            projectPath = projectPath.substring(1);
        }
        return projectPath;
    }

    private String findElementResourcePath(ProjectElement projectElement, String elementPath2) {
        String elementPath = elementPath2;
        if (projectElement.eResource() != null) {
            elementPath = projectElement.eResource().getURI().toFileString();
            elementPath = elementPath.substring(0, elementPath.lastIndexOf(File.separatorChar));
            while (elementPath.startsWith(String.valueOf(File.separator) + File.separator)) {
                elementPath = elementPath.substring(1);
            }
            if (Platform.getOS().equals("win32") && elementPath.startsWith(File.separator)) {
                elementPath = elementPath.substring(1);
            }
        }
        return elementPath;
    }

    private static URI createNewResource(Resource projectResource, String projectPath, ProjectElement projectElement) {
        int i = 0;
        EList list = projectResource.getResourceSet().getResources();
        URIConverter uriConverter = projectResource.getResourceSet().getURIConverter();
        URI uri = null;
        boolean found = false;
        do {
            File file;
            found = false;
            uri = ProjectImpl.generateResourceName(projectPath, projectElement, ++i);
            URI normalizedURI = uriConverter.normalize(uri);
            for (Resource resource2 : list) {
                if (!uriConverter.normalize(resource2.getURI()).equals((Object)normalizedURI)) continue;
                found = true;
                break;
            }
            if (found || !(file = new File(uri.toFileString())).exists()) continue;
            found = true;
        } while (found);
        uri.deresolve(projectResource.getURI(), true, true, true);
        return uri;
    }

    private static URI generateResourceName(String projectPath, ProjectElement projectElement, int i) {
        String resourceName = String.valueOf(projectElement.getName() == null ? "element" : projectElement.getName()) + i;
        resourceName = resourceName.replaceAll("[/\\\\]", NAME_EDEFAULT);
        resourceName = resourceName.replaceAll("\\s", "_");
        resourceName = resourceName.replaceAll("_+", "_");
        resourceName = resourceName.replaceAll(":", "_");
        String extension = projectElement.getFileExtension();
        if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        String tempPath = "file://" + projectPath + File.separator + resourceName + extension;
        URI uri = URI.createURI((String)tempPath);
        return uri;
    }

    @Override
    public URI getID() {
        if (this.eResource() == null) {
            return URI.createFileURI((String)this.getName());
        }
        return this.eResource().getURI();
    }
}

