/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.impl;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.core.internal.CorePlugin;
import net.refractions.udig.core.internal.ExtensionPointList;
import net.refractions.udig.project.Interaction;
import net.refractions.udig.project.command.CommandStack;
import net.refractions.udig.project.command.EditCommand;
import net.refractions.udig.project.command.EditManagerControlCommand;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.NavCommand;
import net.refractions.udig.project.command.NavCommandStack;
import net.refractions.udig.project.interceptor.MapInterceptor;
import net.refractions.udig.project.internal.Blackboard;
import net.refractions.udig.project.internal.BlackboardEntry;
import net.refractions.udig.project.internal.CatalogRef;
import net.refractions.udig.project.internal.ContextModel;
import net.refractions.udig.project.internal.EditManager;
import net.refractions.udig.project.internal.Folder;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.LayerFactory;
import net.refractions.udig.project.internal.LayerLegendItem;
import net.refractions.udig.project.internal.LegendItem;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.ProjectFactory;
import net.refractions.udig.project.internal.ProjectPackage;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.ProjectRegistry;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.project.internal.StyleEntry;
import net.refractions.udig.project.internal.impl.BlackboardEntryImpl;
import net.refractions.udig.project.internal.impl.BlackboardImpl;
import net.refractions.udig.project.internal.impl.ContextModelImpl;
import net.refractions.udig.project.internal.impl.EditManagerImpl;
import net.refractions.udig.project.internal.impl.FolderImpl;
import net.refractions.udig.project.internal.impl.InteractionToEBooleanObjectMapEntryImpl;
import net.refractions.udig.project.internal.impl.LayerFactoryImpl;
import net.refractions.udig.project.internal.impl.LayerImpl;
import net.refractions.udig.project.internal.impl.LayerLegendItemImpl;
import net.refractions.udig.project.internal.impl.LegendItemImpl;
import net.refractions.udig.project.internal.impl.MapImpl;
import net.refractions.udig.project.internal.impl.ProjectImpl;
import net.refractions.udig.project.internal.impl.ProjectRegistryImpl;
import net.refractions.udig.project.internal.impl.StyleBlackboardImpl;
import net.refractions.udig.project.internal.impl.StyleEntryImpl;
import net.refractions.udig.project.internal.render.RenderFactory;
import net.refractions.udig.project.internal.render.impl.ViewportModelImpl;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.palette.ColourScheme;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.geotools.brewer.color.BrewerPalette;
import org.geotools.data.FeatureEvent;
import org.geotools.data.Query;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.SLD;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.picocontainer.MutablePicoContainer;

public class ProjectFactoryImpl
extends EFactoryImpl
implements ProjectFactory {
    private static final String CARTESIAN_2D = "CARTESIAN_2D";
    private static final String CARTESIAN_3D = "CARTESIAN_3D";
    private static final String GENERIC_2D = "GENERIC_2D";
    private static final String GENERIC_3D = "GENERIC_3D";

    public static ProjectFactory init() {
        try {
            ProjectFactory theProjectFactory = (ProjectFactory)EPackage.Registry.INSTANCE.getEFactory("http:///net/refractions/udig/project/internal.ecore");
            if (theProjectFactory != null) {
                return theProjectFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ProjectFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 10: {
                return this.createContextModel();
            }
            case 11: {
                return this.createEditManager();
            }
            case 12: {
                return this.createLayer();
            }
            case 13: {
                return this.createMap();
            }
            case 14: {
                return this.createProject();
            }
            case 16: {
                return this.createProjectRegistry();
            }
            case 17: {
                return this.createStyleBlackboard();
            }
            case 18: {
                return this.createStyleEntry();
            }
            case 20: {
                return this.createLayerFactory();
            }
            case 23: {
                return this.createBlackboard();
            }
            case 24: {
                return this.createBlackboardEntry();
            }
            case 27: {
                return (EObject)this.createInteractionToEBooleanObjectMapEntry();
            }
            case 29: {
                return this.createFolder();
            }
            case 31: {
                return this.createLegendItem();
            }
            case 33: {
                return this.createLayerLegendItem();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 34: {
                return this.createCoordinateFromString(eDataType, initialValue);
            }
            case 35: {
                return this.createMapDisplayFromString(eDataType, initialValue);
            }
            case 36: {
                return this.createListFromString(eDataType, initialValue);
            }
            case 37: {
                return this.createAffineTransformFromString(eDataType, initialValue);
            }
            case 38: {
                return this.createNavCommandStackFromString(eDataType, initialValue);
            }
            case 39: {
                return this.createIGeoResourceFromString(eDataType, initialValue);
            }
            case 40: {
                return this.createFilterFromString(eDataType, initialValue);
            }
            case 41: {
                return this.createCoordinateReferenceSystemFromString(eDataType, initialValue);
            }
            case 42: {
                return this.createCommandStackFromString(eDataType, initialValue);
            }
            case 43: {
                return this.createPointFromString(eDataType, initialValue);
            }
            case 44: {
                return this.createAdapterFromString(eDataType, initialValue);
            }
            case 45: {
                return this.createIProgressMonitorFromString(eDataType, initialValue);
            }
            case 46: {
                return this.createQueryFromString(eDataType, initialValue);
            }
            case 47: {
                return this.createURLFromString(eDataType, initialValue);
            }
            case 48: {
                return this.createImageDescriptorFromString(eDataType, initialValue);
            }
            case 49: {
                return this.createEditCommandFromString(eDataType, initialValue);
            }
            case 50: {
                return this.createNavCommandFromString(eDataType, initialValue);
            }
            case 51: {
                return this.createEnvelopeFromString(eDataType, initialValue);
            }
            case 52: {
                return this.createEditManagerControlCommandFromString(eDataType, initialValue);
            }
            case 53: {
                return this.createCommandFromString(eDataType, initialValue);
            }
            case 54: {
                return this.createURIFromString(eDataType, initialValue);
            }
            case 55: {
                return this.createCatalogRefFromString(eDataType, initialValue);
            }
            case 56: {
                return this.createColourPaletteFromString(eDataType, initialValue);
            }
            case 57: {
                return this.createColourSchemeFromString(eDataType, initialValue);
            }
            case 58: {
                return this.createMutablePicoContainerFromString(eDataType, initialValue);
            }
            case 59: {
                return this.createReferencedEnvelopeFromString(eDataType, initialValue);
            }
            case 60: {
                return this.createFeatureEventFromString(eDataType, initialValue);
            }
            case 61: {
                return this.createSimpleFeatureFromString(eDataType, initialValue);
            }
            case 62: {
                return this.createIllegalArgumentExceptionFromString(eDataType, initialValue);
            }
            case 63: {
                return this.createIOExceptionFromString(eDataType, initialValue);
            }
            case 64: {
                return this.createColorFromString(eDataType, initialValue);
            }
            case 65: {
                return this.createBrewerPaletteFromString(eDataType, initialValue);
            }
            case 66: {
                return this.createInteractionFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 34: {
                return this.convertCoordinateToString(eDataType, instanceValue);
            }
            case 35: {
                return this.convertMapDisplayToString(eDataType, instanceValue);
            }
            case 36: {
                return this.convertListToString(eDataType, instanceValue);
            }
            case 37: {
                return this.convertAffineTransformToString(eDataType, instanceValue);
            }
            case 38: {
                return this.convertNavCommandStackToString(eDataType, instanceValue);
            }
            case 39: {
                return this.convertIGeoResourceToString(eDataType, instanceValue);
            }
            case 40: {
                return this.convertFilterToString(eDataType, instanceValue);
            }
            case 41: {
                return this.convertCoordinateReferenceSystemToString(eDataType, instanceValue);
            }
            case 42: {
                return this.convertCommandStackToString(eDataType, instanceValue);
            }
            case 43: {
                return this.convertPointToString(eDataType, instanceValue);
            }
            case 44: {
                return this.convertAdapterToString(eDataType, instanceValue);
            }
            case 45: {
                return this.convertIProgressMonitorToString(eDataType, instanceValue);
            }
            case 46: {
                return this.convertQueryToString(eDataType, instanceValue);
            }
            case 47: {
                return this.convertURLToString(eDataType, instanceValue);
            }
            case 48: {
                return this.convertImageDescriptorToString(eDataType, instanceValue);
            }
            case 49: {
                return this.convertEditCommandToString(eDataType, instanceValue);
            }
            case 50: {
                return this.convertNavCommandToString(eDataType, instanceValue);
            }
            case 51: {
                return this.convertEnvelopeToString(eDataType, instanceValue);
            }
            case 52: {
                return this.convertEditManagerControlCommandToString(eDataType, instanceValue);
            }
            case 53: {
                return this.convertCommandToString(eDataType, instanceValue);
            }
            case 54: {
                return this.convertURIToString(eDataType, instanceValue);
            }
            case 55: {
                return this.convertCatalogRefToString(eDataType, instanceValue);
            }
            case 56: {
                return this.convertColourPaletteToString(eDataType, instanceValue);
            }
            case 57: {
                return this.convertColourSchemeToString(eDataType, instanceValue);
            }
            case 58: {
                return this.convertMutablePicoContainerToString(eDataType, instanceValue);
            }
            case 59: {
                return this.convertReferencedEnvelopeToString(eDataType, instanceValue);
            }
            case 60: {
                return this.convertFeatureEventToString(eDataType, instanceValue);
            }
            case 61: {
                return this.convertSimpleFeatureToString(eDataType, instanceValue);
            }
            case 62: {
                return this.convertIllegalArgumentExceptionToString(eDataType, instanceValue);
            }
            case 63: {
                return this.convertIOExceptionToString(eDataType, instanceValue);
            }
            case 64: {
                return this.convertColorToString(eDataType, instanceValue);
            }
            case 65: {
                return this.convertBrewerPaletteToString(eDataType, instanceValue);
            }
            case 66: {
                return this.convertInteractionToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public ContextModel createContextModel() {
        ContextModelImpl contextModel = new ContextModelImpl();
        return contextModel;
    }

    @Override
    public Layer createLayer() {
        LayerImpl layer = new LayerImpl();
        return layer;
    }

    @Override
    public Project createProject() {
        ProjectImpl project = new ProjectImpl();
        return project;
    }

    @Override
    public ProjectRegistry createProjectRegistry() {
        ProjectRegistryImpl projectRegistry = new ProjectRegistryImpl();
        return projectRegistry;
    }

    @Override
    public StyleBlackboard createStyleBlackboard() {
        StyleBlackboardImpl styleBlackboard = new StyleBlackboardImpl();
        return styleBlackboard;
    }

    @Override
    public StyleEntry createStyleEntry() {
        StyleEntryImpl styleEntry = new StyleEntryImpl();
        return styleEntry;
    }

    @Override
    public LayerFactory createLayerFactory() {
        LayerFactoryImpl layerFactory = new LayerFactoryImpl();
        return layerFactory;
    }

    @Override
    public Blackboard createBlackboard() {
        BlackboardImpl blackboard = new BlackboardImpl();
        return blackboard;
    }

    @Override
    public BlackboardEntry createBlackboardEntry() {
        BlackboardEntryImpl blackboardEntry = new BlackboardEntryImpl();
        return blackboardEntry;
    }

    public Map.Entry<Interaction, Boolean> createInteractionToEBooleanObjectMapEntry() {
        InteractionToEBooleanObjectMapEntryImpl interactionToEBooleanObjectMapEntry = new InteractionToEBooleanObjectMapEntryImpl();
        return interactionToEBooleanObjectMapEntry;
    }

    @Override
    public Folder createFolder() {
        FolderImpl folder = new FolderImpl();
        return folder;
    }

    @Override
    public LegendItem createLegendItem() {
        LegendItemImpl legendItem = new LegendItemImpl();
        return legendItem;
    }

    @Override
    public LayerLegendItem createLayerLegendItem() {
        LayerLegendItemImpl layerLegendItem = new LayerLegendItemImpl();
        return layerLegendItem;
    }

    @Override
    public EditManager createEditManager() {
        EditManagerImpl editManager = new EditManagerImpl();
        return editManager;
    }

    public Query createQueryFromString(EDataType eDataType, String initialValue) {
        return (Query)super.createFromString(eDataType, initialValue);
    }

    public String convertQueryToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public Envelope createEnvelopeFromString(EDataType eDataType, String initialValue) {
        return this.createReferencedEnvelopeFromString(eDataType, initialValue);
    }

    public String convertEnvelopeToString(EDataType eDataType, Object instanceValue) {
        return this.convertReferencedEnvelopeToString(eDataType, instanceValue);
    }

    public EditManagerControlCommand createEditManagerControlCommandFromString(EDataType eDataType, String initialValue) {
        return (EditManagerControlCommand)super.createFromString(eDataType, initialValue);
    }

    public Coordinate createCoordinateFromString(EDataType eDataType, String initialValue) {
        return (Coordinate)super.createFromString(eDataType, initialValue);
    }

    public String convertCoordinateToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public NavCommand createNavCommandFromString(EDataType eDataType, String initialValue) {
        return (NavCommand)super.createFromString(eDataType, initialValue);
    }

    public String convertNavCommandToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public ImageDescriptor createImageDescriptorFromString(EDataType eDataType, String initialValue) {
        return (ImageDescriptor)super.createFromString(eDataType, initialValue);
    }

    public String convertImageDescriptorToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public AffineTransform createAffineTransformFromString(EDataType eDataType, String initialValue) {
        return (AffineTransform)super.createFromString(eDataType, initialValue);
    }

    public String convertAffineTransformToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public NavCommandStack createNavCommandStackFromString(EDataType eDataType, String initialValue) {
        return (NavCommandStack)super.createFromString(eDataType, initialValue);
    }

    public String convertNavCommandStackToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public CoordinateReferenceSystem createCoordinateReferenceSystemFromString(EDataType eDataType, String initialValue) {
        if (initialValue.equals(CARTESIAN_2D)) {
            return DefaultEngineeringCRS.CARTESIAN_2D;
        }
        if (initialValue.equals(CARTESIAN_3D)) {
            return DefaultEngineeringCRS.CARTESIAN_3D;
        }
        if (initialValue.equals(GENERIC_2D)) {
            return DefaultEngineeringCRS.GENERIC_2D;
        }
        if (initialValue.equals(GENERIC_3D)) {
            return DefaultEngineeringCRS.GENERIC_3D;
        }
        try {
            return ReferencingFactoryFinder.getCRSFactory(null).createFromWKT(initialValue);
        }
        catch (Exception exception) {
            return ViewportModelImpl.getDefaultCRS();
        }
    }

    public String convertCoordinateReferenceSystemToString(EDataType eDataType, Object instanceValue) {
        block9: {
            block8: {
                block7: {
                    block6: {
                        try {
                            if (instanceValue != DefaultEngineeringCRS.CARTESIAN_2D) break block6;
                            return CARTESIAN_2D;
                        }
                        catch (Exception exception) {
                            ProjectPlugin.log("Couldn't write crs");
                            return DefaultGeographicCRS.WGS84.toWKT().replace("\n", " ");
                        }
                    }
                    if (instanceValue != DefaultEngineeringCRS.CARTESIAN_3D) break block7;
                    return CARTESIAN_3D;
                }
                if (instanceValue != DefaultEngineeringCRS.GENERIC_2D) break block8;
                return GENERIC_2D;
            }
            if (instanceValue != DefaultEngineeringCRS.GENERIC_3D) break block9;
            return GENERIC_3D;
        }
        return ((CoordinateReferenceSystem)instanceValue).toWKT().replace("\n", " ");
    }

    public CommandStack createCommandStackFromString(EDataType eDataType, String initialValue) {
        return (CommandStack)super.createFromString(eDataType, initialValue);
    }

    public String convertCommandStackToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public Point createPointFromString(EDataType eDataType, String initialValue) {
        return (Point)super.createFromString(eDataType, initialValue);
    }

    public String convertPointToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public Adapter createAdapterFromString(EDataType eDataType, String initialValue) {
        return (Adapter)super.createFromString(eDataType, initialValue);
    }

    public String convertAdapterToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public URL createURLFromString(EDataType eDataType, String initialValue) {
        try {
            return new URL(null, initialValue, CorePlugin.RELAXED_HANDLER);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public String convertURLToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public EditCommand createEditCommandFromString(EDataType eDataType, String initialValue) {
        return (EditCommand)super.createFromString(eDataType, initialValue);
    }

    public String convertEditCommandToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public URI createURIFromString(EDataType eDataType, String initialValue) {
        return (URI)super.createFromString(eDataType, initialValue);
    }

    public String convertURIToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public MapCommand createCommandFromString(EDataType eDataType, String initialValue) {
        return (MapCommand)super.createFromString(eDataType, initialValue);
    }

    public String convertCommandToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public IMapDisplay createMapDisplayFromString(EDataType eDataType, String initialValue) {
        return (IMapDisplay)super.createFromString(eDataType, initialValue);
    }

    public String convertMapDisplayToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public List createListFromString(EDataType eDataType, String initialValue) {
        return (List)super.createFromString(eDataType, initialValue);
    }

    public String convertListToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public IGeoResource createIGeoResourceFromString(EDataType eDataType, String initialValue) {
        return (IGeoResource)super.createFromString(eDataType, initialValue);
    }

    public String convertIGeoResourceToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public CatalogRef createCatalogRefFromString(EDataType eDataType, String initialValue) {
        CatalogRef ref = new CatalogRef();
        try {
            ref.parseResourceParameters(initialValue);
            return ref;
        }
        catch (Exception exception) {
            return ref;
        }
    }

    public String convertCatalogRefToString(EDataType eDataType, Object instanceValue) {
        try {
            return ((CatalogRef)instanceValue).marshalConnectionParameters();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public BrewerPalette createBrewerPaletteFromString(EDataType eDataType, String initialValue) {
        return PlatformGIS.getColorBrewer().getPalette(initialValue);
    }

    public String convertBrewerPaletteToString(EDataType eDataType, Object instanceValue) {
        return ((BrewerPalette)instanceValue).getName();
    }

    public Interaction createInteractionFromString(EDataType eDataType, String initialValue) {
        return (Interaction)((Object)super.createFromString(eDataType, initialValue));
    }

    public String convertInteractionToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public BrewerPalette createColourPaletteFromString(EDataType eDataType, String initialValue) {
        return PlatformGIS.getColorBrewer().getPalette(initialValue);
    }

    public String convertColourPaletteToString(EDataType eDataType, Object instanceValue) {
        return ((BrewerPalette)instanceValue).getName();
    }

    public ColourScheme createColourSchemeFromString(EDataType eDataType, String initialValue) {
        String[] parts = initialValue.split(";");
        if (parts.length != 4) {
            BrewerPalette palette = PlatformGIS.getColorBrewer().getPalette("Dark2");
            return new ColourScheme(palette, 0);
        }
        String[] strap = parts[2].split(",");
        BrewerPalette palette = PlatformGIS.getColorBrewer().getPalette(parts[0]);
        HashMap<Integer, Integer> colourMapping = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < strap.length) {
            colourMapping.put(i, Integer.parseInt(strap[i]));
            ++i;
        }
        String[] strap2 = parts[3].split(",");
        HashMap<String, Integer> idMapping = new HashMap<String, Integer>();
        int i2 = 0;
        while (i2 < strap2.length) {
            idMapping.put(strap2[i2], Integer.parseInt(strap2[++i2]));
            ++i2;
        }
        ColourScheme scheme = new ColourScheme(palette, colourMapping, idMapping, strap.length, Integer.parseInt(parts[1]));
        return scheme;
    }

    public String convertColourSchemeToString(EDataType eDataType, Object instanceValue) {
        ColourScheme instance = (ColourScheme)instanceValue;
        String value = String.valueOf(instance.getColourPalette().getName()) + ";";
        int numItems = instance.getSizeScheme();
        int numColours = instance.getSizePalette();
        value = String.valueOf(value) + numColours + ";";
        HashMap colourMap = instance.getColourMap();
        int i = 0;
        while (i < numItems) {
            if (i > 0) {
                value = String.valueOf(value) + ",";
            }
            value = String.valueOf(value) + colourMap.get(i);
            ++i;
        }
        value = String.valueOf(value) + ";";
        HashMap idMap = instance.getIdMap();
        Iterator it = idMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            value = String.valueOf(value) + (String)entry.getKey() + "," + entry.getValue();
            if (!it.hasNext()) continue;
            value = String.valueOf(value) + ",";
        }
        return value;
    }

    public Color createDefaultColorFromString(EDataType eDataType, String initialValue) {
        return SLD.toColor((String)initialValue);
    }

    public String convertDefaultColorToString(EDataType eDataType, Object instanceValue) {
        Color instance = (Color)instanceValue;
        return SLD.toHTMLColor((Color)instance);
    }

    public Color createColorFromString(EDataType eDataType, String initialValue) {
        return SLD.toColor((String)initialValue);
    }

    public String convertColorToString(EDataType eDataType, Object instanceValue) {
        Color instance = (Color)instanceValue;
        return SLD.toHTMLColor((Color)instance);
    }

    public MutablePicoContainer createMutablePicoContainerFromString(EDataType eDataType, String initialValue) {
        return (MutablePicoContainer)super.createFromString(eDataType, initialValue);
    }

    public String convertMutablePicoContainerToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    private Envelope createEnvelope(String initialValue) {
        if (initialValue.equals("")) {
            return new Envelope();
        }
        String[] coords = initialValue.split(",");
        return new Envelope(new Envelope(Double.parseDouble(coords[0]), Double.parseDouble(coords[1]), Double.parseDouble(coords[2]), Double.parseDouble(coords[3])));
    }

    public ReferencedEnvelope createReferencedEnvelopeFromString(EDataType eDataType, String initialValue) {
        String[] parts = initialValue.split("@", 2);
        Envelope env = this.createEnvelope(parts[0]);
        if (parts.length == 2) {
            CoordinateReferenceSystem crs = this.createCoordinateReferenceSystemFromString(ProjectPackage.eINSTANCE.getCoordinateReferenceSystem(), parts[1]);
            return new ReferencedEnvelope(env, crs);
        }
        return new ReferencedEnvelope(env, (CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D);
    }

    public String convertReferencedEnvelopeToString(EDataType eDataType, Object instanceValue) {
        Envelope env = (Envelope)instanceValue;
        if (env.isNull()) {
            return "";
        }
        String envString = String.valueOf(env.getMinX()) + "," + env.getMaxX() + "," + env.getMinY() + "," + env.getMaxY();
        if (env instanceof ReferencedEnvelope) {
            String crs = this.convertCoordinateReferenceSystemToString(ProjectPackage.eINSTANCE.getCoordinateReferenceSystem(), ((ReferencedEnvelope)instanceValue).getCoordinateReferenceSystem());
            return String.valueOf(envString) + "@" + crs;
        }
        return envString;
    }

    public FeatureEvent createFeatureEventFromString(EDataType eDataType, String initialValue) {
        return (FeatureEvent)super.createFromString(eDataType, initialValue);
    }

    public String convertFeatureEventToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public SimpleFeature createSimpleFeatureFromString(EDataType eDataType, String initialValue) {
        return (SimpleFeature)super.createFromString(eDataType, initialValue);
    }

    public String convertSimpleFeatureToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public IllegalArgumentException createIllegalArgumentExceptionFromString(EDataType eDataType, String initialValue) {
        return (IllegalArgumentException)super.createFromString(eDataType, initialValue);
    }

    public String convertIllegalArgumentExceptionToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public IOException createIOExceptionFromString(EDataType eDataType, String initialValue) {
        return (IOException)super.createFromString(eDataType, initialValue);
    }

    public String convertIOExceptionToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public Filter createFilterFromString(EDataType eDataType, String initialValue) {
        return (Filter)super.createFromString(eDataType, initialValue);
    }

    public String convertFilterToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public IProgressMonitor createIProgressMonitorFromString(EDataType eDataType, String initialValue) {
        return (IProgressMonitor)super.createFromString(eDataType, initialValue);
    }

    public String convertIProgressMonitorToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public String convertEditManagerControlCommandToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public ProjectPackage getProjectPackage() {
        return (ProjectPackage)this.getEPackage();
    }

    @Deprecated
    public static ProjectPackage getPackage() {
        return ProjectPackage.eINSTANCE;
    }

    @Override
    public Map createMap() {
        MapImpl map = new MapImpl();
        map.setLayerFactory(this.createLayerFactory());
        map.setBlackBoardInternal(this.createBlackboard());
        return map;
    }

    private void runMapCreationInterceptors(Map map) {
        List interceptors = ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.project.mapInterceptor");
        for (IConfigurationElement element : interceptors) {
            if (!"mapCreation".equals(element.getName())) continue;
            try {
                MapInterceptor interceptor = (MapInterceptor)element.createExecutableExtension("class");
                interceptor.run(map);
            }
            catch (Exception e) {
                ProjectPlugin.log("", e);
            }
        }
    }

    @Override
    public Map createMap(Project owner, String name, List layers) {
        Map map = this.createMap();
        map.setName(name);
        map.setProjectInternal(owner);
        map.setViewportModelInternal(RenderFactory.eINSTANCE.createViewportModel());
        this.runMapCreationInterceptors(map);
        if (!layers.isEmpty()) {
            map.getLayersInternal().addAll(layers);
        }
        return map;
    }
}

