/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.core.internal.ExtensionPointList;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.interceptor.LayerInterceptor;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.impl.SynchronizedEObjectResolvingEList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.InternalEObject;

class LayersList3
extends SynchronizedEObjectResolvingEList<Layer> {
    private static final long serialVersionUID = 4584718175140573610L;
    private Collection<Adapter> deepAdapters = new CopyOnWriteArraySet<Adapter>();

    public LayersList3(Class<Layer> dataClass, InternalEObject owner, int featureID) {
        super(dataClass, owner, featureID);
    }

    public void addDeepAdapter(Adapter adapter) {
        this.deepAdapters.add(adapter);
        if (!this.owner.eAdapters().contains((Object)adapter)) {
            this.owner.eAdapters().add((Object)adapter);
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Layer layer = (Layer)object;
            if (layer.eAdapters().contains((Object)adapter)) continue;
            layer.eAdapters().add((Object)adapter);
        }
    }

    public void removeDeepAdapter(Adapter toRemove) {
        this.deepAdapters.remove(toRemove);
        this.owner.eAdapters().remove((Object)toRemove);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            ((Layer)object).eAdapters().remove((Object)toRemove);
        }
    }

    protected void didAdd(int index, Layer newObject) {
        super.didAdd(index, (Object)newObject);
    }

    public NotificationChain inverseAdd(Layer object, NotificationChain notifications) {
        NotificationChain notificationChain = super.inverseAdd((Object)object, notifications);
        if (ProjectPlugin.isDebugging("net.refractions.udig.project/debug/model/trace")) {
            ProjectPlugin.trace(((Object)((Object)this)).getClass(), "inverseAdd() = " + object.getID() + " to map " + this.getMap().getName(), null);
        }
        this.runAddInterceptors(object);
        return notificationChain;
    }

    @Override
    protected Layer assign(int index, Layer object) {
        if (!(object instanceof Layer)) {
            throw new AssertionError((Object)("Can only add " + Layer.class.getName() + " to a map.  Was: " + object.getClass().getName()));
        }
        if (ProjectPlugin.isDebugging("net.refractions.udig.project/debug/model/trace")) {
            ProjectPlugin.trace(((Object)((Object)this)).getClass(), "Adding " + object.getID() + " to map " + this.getMap().getName() + " at location: " + index, null);
        }
        Layer object2 = super.assign(index, object);
        if (ProjectPlugin.isDebugging("net.refractions.udig.project/debug/model/trace")) {
            ProjectPlugin.trace(((Object)((Object)this)).getClass(), "Resulting list=" + (Object)((Object)this), null);
        }
        return object2;
    }

    private IMap getMap() {
        if (this.owner instanceof IMap) {
            return (IMap)this.owner;
        }
        if (this.owner.eContainer() instanceof IMap) {
            return (IMap)this.owner.eContainer();
        }
        throw new IllegalStateException("Owner should be IMap or ContextModel");
    }

    @Override
    protected Layer doRemove(int index) {
        Object toRemove = this.get(index);
        this.runRemoveInterceptor(toRemove);
        if (ProjectPlugin.isDebugging("net.refractions.udig.project/debug/model/trace")) {
            ProjectPlugin.trace(((Object)((Object)this)).getClass(), "Removing " + ((Layer)toRemove).getID() + " from map " + this.getMap().getName(), null);
        }
        return (Layer)super.doRemove(index);
    }

    @Override
    protected void doClear() {
        Object[] toRemove = this.toArray();
        this.removeAllInterceptors(Arrays.asList(toRemove));
        if (ProjectPlugin.isDebugging("net.refractions.udig.project/debug/model/trace")) {
            ProjectPlugin.trace(((Object)((Object)this)).getClass(), "Removing all layers from map:" + this.getMap().getName(), null);
        }
        super.doClear();
    }

    private void removeAllInterceptors(Collection<?> c) {
        for (Layer element : c) {
            this.runLayerInterceptor(element, "layerRemoved");
            element.eAdapters().removeAll(this.deepAdapters);
        }
    }

    private void runAddInterceptors(Object element) {
        Layer layer = (Layer)element;
        for (Adapter deepAdapter : this.deepAdapters) {
            if (layer.eAdapters().contains((Object)deepAdapter)) continue;
            layer.eAdapters().add((Object)deepAdapter);
        }
        this.runLayerInterceptor(layer, "layerAdded");
    }

    private void runRemoveInterceptor(Object remove) {
        if (remove == null || !this.contains(remove)) {
            return;
        }
        Layer layer = (Layer)remove;
        this.runLayerInterceptor(layer, "layerRemoved");
        layer.eAdapters().removeAll(this.deepAdapters);
    }

    private void runLayerInterceptor(Layer layer, String configurationName) {
        this.runNonDeprecatedInterceptors(layer, configurationName);
        this.runDeprecatedInterceptors(layer, configurationName);
    }

    private void runNonDeprecatedInterceptors(Layer layer, String configurationName) {
        List list = ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.project.layerInterceptor");
        for (IConfigurationElement element : list) {
            if (!element.getName().equals(configurationName)) continue;
            String attribute = element.getAttribute("name");
            try {
                LayerInterceptor interceptor = (LayerInterceptor)element.createExecutableExtension("class");
                interceptor.run(layer);
            }
            catch (CoreException e) {
                ProjectPlugin.log("Error creating class: " + element.getAttribute("class") + " part of layer interceptor: " + attribute, e);
            }
            catch (Throwable t) {
                ProjectPlugin.log("error running interceptor: " + attribute, t);
            }
        }
    }

    private void runDeprecatedInterceptors(Layer layer, String configurationName) {
        List interceptors = ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.project.mapInterceptor");
        for (IConfigurationElement element : interceptors) {
            if (!configurationName.equals(element.getName())) continue;
            try {
                LayerInterceptor interceptor = (LayerInterceptor)element.createExecutableExtension("class");
                interceptor.run(layer);
            }
            catch (Throwable e) {
                ProjectPlugin.log("", e);
            }
        }
    }
}

