/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.impl;

import java.awt.Color;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.core.internal.ExtensionPointList;
import net.refractions.udig.project.interceptor.LayerInterceptor;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.LayerFactory;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.ProjectFactory;
import net.refractions.udig.project.internal.ProjectPackage;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.impl.LayerImpl;
import net.refractions.udig.project.internal.impl.LayerResource;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.ProgressManager;
import net.refractions.udig.ui.palette.ColourScheme;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.geotools.brewer.color.BrewerPalette;

public class LayerFactoryImpl
extends EObjectImpl
implements LayerFactory {
    public static final String copyright = "uDig - User Friendly Desktop Internet GIS client\nhttp://udig.refractions.net\n(C) 2004-2012, Refractions Research Inc.\n\n\nAll rights reserved. This program and the accompanying materials\nare made available under the terms of the Eclipse Public License v1.0\n(http://www.eclipse.org/legal/epl-v10.html), and the Refractions BSD\nLicense v1.0 (http://udig.refractions.net/files/bsd3-v10.html).\n";

    protected LayerFactoryImpl() {
    }

    protected EClass eStaticClass() {
        return ProjectPackage.Literals.LAYER_FACTORY;
    }

    @Override
    public Map getMap() {
        if (this.eContainerFeatureID() != 0) {
            return null;
        }
        return (Map)this.eContainer();
    }

    public NotificationChain basicSetMap(Map newMap, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newMap, 0, msgs);
        return msgs;
    }

    @Override
    public void setMap(Map newMap) {
        if (newMap != this.eInternalContainer() || this.eContainerFeatureID() != 0 && newMap != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newMap)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newMap != null) {
                msgs = ((InternalEObject)newMap).eInverseAdd((InternalEObject)this, 6, Map.class, msgs);
            }
            if ((msgs = this.basicSetMap(newMap, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)newMap, (Object)newMap));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetMap((Map)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return this.basicSetMap(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 0: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 6, Map.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getMap();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setMap((Map)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setMap(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.getMap() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public List<Layer> getLayers(List selection) throws IOException {
        LinkedList<Layer> layers = new LinkedList<Layer>();
        for (Object obj : selection) {
            IGeoResource entry;
            Layer ref;
            if (obj instanceof IService) {
                layers.addAll(this.getLayers((IService)obj));
                continue;
            }
            if (!(obj instanceof IGeoResource) || (ref = this.createLayer(entry = (IGeoResource)obj)) == null) continue;
            layers.add(ref);
        }
        return layers;
    }

    @Override
    public List<Layer> getLayers(IService service) throws IOException {
        Layer ref = null;
        LinkedList<Layer> layers = new LinkedList<Layer>();
        for (IGeoResource entry : service.resources(null)) {
            ref = this.createLayer(entry);
            if (ref == null) continue;
            layers.add(ref);
        }
        return layers;
    }

    public static LayerFactoryImpl create() {
        return new LayerFactoryImpl();
    }

    @Override
    public Layer createLayer(IGeoResource resource) throws IOException {
        LayerImpl layer;
        IService service = resource.service(ProgressManager.instance().get(new Object[0]));
        if (service == null) {
            return null;
        }
        ICatalog local = CatalogPlugin.getDefault().getLocalCatalog();
        if (local.getById(IService.class, service.getID(), (IProgressMonitor)new NullProgressMonitor()) == null) {
            local.add(resource.service(null));
        }
        if ((layer = (LayerImpl)ProjectFactory.eINSTANCE.createLayer()) == null) {
            throw new IOException("Unable to create layer from resource '" + resource.getIdentifier() + "'");
        }
        ID resourceID = resource.getID();
        layer.setResourceID(resourceID);
        LayerImpl theLayer = layer;
        ICatalog localCatalog = local;
        ID layerResourceID = layer.getResourceID();
        IProgressMonitor monitor = ProgressManager.instance().get(new Object[0]);
        List resolves = localCatalog.find(layerResourceID, monitor);
        if (resolves.isEmpty()) {
            throw new IOException("Could not find " + layerResourceID + " in local catalog");
        }
        EDataTypeUniqueEList resources = new EDataTypeUniqueEList(IGeoResource.class, (InternalEObject)this, 10);
        LayerResource preferredResource = null;
        for (IResolve resolve : resolves) {
            if (!(resolve instanceof IGeoResource)) continue;
            LayerResource layerResource = new LayerResource(layer, (IGeoResource)resolve);
            if (resolve.getID().equals((Object)layerResourceID)) {
                resources.add(0, (Object)layerResource);
            } else {
                resources.add((Object)layerResource);
            }
            if (resolve != resource) continue;
            preferredResource = layerResource;
        }
        layer.geoResources = resources;
        layer.setGeoResource(preferredResource);
        ColourScheme colourScheme = this.getColorScheme();
        Color colour = colourScheme.addItem(theLayer.getID().toString());
        theLayer.setDefaultColor(colour);
        this.runLayerCreatedInterceptor(layer);
        return layer;
    }

    private ColourScheme getColorScheme() {
        if (this.getMap() == null) {
            return ColourScheme.getDefault((BrewerPalette)PlatformGIS.getColorBrewer().getPalettes()[0]);
        }
        return this.getMap().getColourScheme();
    }

    private void runLayerCreatedInterceptor(Layer layer) {
        List list = ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.project.layerInterceptor");
        for (IConfigurationElement element : list) {
            if (!element.getName().equals("layerCreated")) continue;
            String attribute = element.getAttribute("name");
            try {
                LayerInterceptor interceptor = (LayerInterceptor)element.createExecutableExtension("class");
                interceptor.run(layer);
            }
            catch (CoreException e) {
                ProjectPlugin.log("Error creating class: " + element.getAttribute("class") + " part of layer interceptor: " + attribute, e);
            }
            catch (Throwable t) {
                ProjectPlugin.log("Error running interceptor: " + attribute, t);
            }
        }
    }
}

