/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.impl;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.core.internal.FeatureUtils;
import net.refractions.udig.project.AdaptableFeature;
import net.refractions.udig.project.EditManagerEvent;
import net.refractions.udig.project.IEditManagerListener;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.internal.EditManager;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.ProjectPackage;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.impl.UDIGStore;
import net.refractions.udig.project.internal.impl.UDIGTransaction;
import net.refractions.udig.project.internal.render.RenderManager;
import net.refractions.udig.ui.ProgressManager;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.AdaptorFeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;

public class EditManagerImpl
extends EObjectImpl
implements EditManager {
    protected static final SimpleFeature EDIT_FEATURE_EDEFAULT = null;
    protected SimpleFeature editFeature = EDIT_FEATURE_EDEFAULT;
    protected Layer editLayerInternal;
    protected static final boolean EDIT_LAYER_LOCKED_EDEFAULT = false;
    final UDIGTransaction transaction = new UDIGTransaction();
    private volatile boolean committing = false;
    Adapter eventCreator = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            switch (msg.getFeatureID(EditManager.class)) {
                case 0: {
                    EditManagerImpl.this.fireEvent(new EditManagerEvent(EditManagerImpl.this, 0, msg.getNewValue(), msg.getOldValue()));
                    break;
                }
                case 2: {
                    EditManagerImpl.this.fireEvent(new EditManagerEvent(EditManagerImpl.this, 2, msg.getNewValue(), msg.getOldValue()));
                    break;
                }
                case 5: {
                    EditManagerImpl.this.fireEvent(new EditManagerEvent(EditManagerImpl.this, 5, msg.getNewValue(), msg.getOldValue()));
                    break;
                }
            }
        }
    };
    Set<IEditManagerListener> listeners = new CopyOnWriteArraySet<IEditManagerListener>();
    private boolean editLayerLocked = false;
    Layer selectedLayer;

    protected EditManagerImpl() {
        this.eAdapters().add((Object)this.eventCreator);
    }

    protected EClass eStaticClass() {
        return ProjectPackage.Literals.EDIT_MANAGER;
    }

    @Override
    public Map getMapInternal() {
        if (this.eContainerFeatureID() != 1) {
            return null;
        }
        return (Map)this.eContainer();
    }

    public NotificationChain basicSetMapInternal(Map newMapInternal, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newMapInternal, 1, msgs);
        return msgs;
    }

    @Override
    public void setMapInternal(Map newMapInternal) {
        if (newMapInternal != this.eInternalContainer() || this.eContainerFeatureID() != 1 && newMapInternal != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newMapInternal)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newMapInternal != null) {
                msgs = ((InternalEObject)newMapInternal).eInverseAdd((InternalEObject)this, 9, Map.class, msgs);
            }
            if ((msgs = this.basicSetMapInternal(newMapInternal, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newMapInternal, (Object)newMapInternal));
        }
    }

    @Override
    public SimpleFeature getEditFeature() {
        return this.editFeature;
    }

    @Override
    public Layer getEditLayerInternal() {
        return this.editLayerInternal;
    }

    @Override
    public Class getTransactionType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public void setEditFeature(SimpleFeature feature, Layer layer) {
        if (layer == null && this.isEditLayerLocked()) {
            layer = this.editLayerInternal;
        }
        if (this.isEditLayerLocked() && layer != this.editLayerInternal && this.editLayerInternal != null) {
            throw new IllegalArgumentException("Edit Layer is locked so argument 'layer' should be not be changed.");
        }
        SimpleFeature value = this.getAdaptableFeature(feature, layer);
        SimpleFeature oldFeature = this.editFeature;
        if (this.editFeature != null) {
            this.editFeature = null;
        }
        if (value != null) {
            this.editFeature = value;
            this.editLayerInternal = layer;
        } else if (layer != null && !this.isEditLayerLocked()) {
            this.editLayerInternal = layer;
        }
        if (this.eNotificationRequired() && oldFeature == value) {
            return;
        }
        this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldFeature, (Object)value));
    }

    @Override
    public void startTransaction() {
        throw new UnsupportedOperationException();
    }

    private SimpleFeature getAdaptableFeature(SimpleFeature feature, Layer layer) {
        if (feature == null || feature instanceof IAdaptable) {
            return feature;
        }
        return new AdaptableFeature(feature, layer);
    }

    private void startCommitRollback(String dialogMessage) {
        List<Layer> layers = this.getMapInternal().getLayersInternal();
        for (Layer layer : layers) {
            layer.eSetDeliver(false);
        }
        RenderManager rm = this.getMapInternal().getRenderManagerInternal();
        if (rm != null) {
            rm.disableRendering();
        }
        this.showCommitDialog(dialogMessage);
    }

    private void showCommitDialog(final String message) {
        this.committing = true;
        final Display display = Display.getDefault();
        final IRunnableWithProgress progressRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(message, -1);
                while (EditManagerImpl.this.committing) {
                    if (display.readAndDispatch()) continue;
                    Thread.sleep(200L);
                }
            }
        };
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ProgressMonitorDialog dialog = new ProgressMonitorDialog(display.getActiveShell());
                        try {
                            dialog.run(false, false, progressRunnable);
                        }
                        catch (InvocationTargetException e) {
                            ProjectPlugin.log("", e);
                        }
                        catch (InterruptedException e) {
                            ProjectPlugin.log("", e);
                        }
                    }
                });
            }
        });
    }

    private void commitRollbackComplete() throws IOException {
        List<Layer> layers = this.getMapInternal().getLayersInternal();
        for (Layer layer1 : layers) {
            layer1.eSetDeliver(true);
        }
        RenderManager rm = this.getMapInternal().getRenderManagerInternal();
        if (rm != null) {
            rm.enableRendering();
        }
        for (Layer layer : this.getMapInternal().getLayersInternal()) {
            FeatureStore resource = (FeatureStore)layer.getResource(FeatureStore.class, ProgressManager.instance().get(new Object[0]));
            if (resource == null || !(resource instanceof UDIGStore)) continue;
            UDIGStore store = (UDIGStore)resource;
            store.editComplete();
        }
        this.committing = false;
    }

    @Override
    public void commitTransaction() throws IOException {
        block15: {
            this.fireEvent(new EditManagerEvent(this, -2, null, null));
            this.startCommitRollback("Comitting changes all layers in map");
            try {
                try {
                    this.transaction.commitInternal();
                    for (Layer layer : this.getMapInternal().getLayersInternal()) {
                        if (layer.getFeatureChanges().size() == 0) continue;
                        layer.getFeatureChanges().clear();
                    }
                }
                catch (IOException e) {
                    block14: {
                        e.printStackTrace();
                        FeatureIterator reader = null;
                        try {
                            try {
                                FeatureSource source = (FeatureSource)this.editLayerInternal.getResource(FeatureSource.class, null);
                                FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
                                FeatureCollection results = source.getFeatures((Filter)filterFactory.id(FeatureUtils.stringToId((FilterFactory)filterFactory, (String)this.editFeature.getID())));
                                reader = results.features();
                                this.setEditFeature((SimpleFeature)reader.next(), this.editLayerInternal);
                            }
                            catch (Exception exception) {
                                this.setEditFeature(null, null);
                                if (reader != null) {
                                    reader.close();
                                }
                                break block14;
                            }
                        }
                        catch (Throwable throwable) {
                            if (reader != null) {
                                reader.close();
                            }
                            throw throwable;
                        }
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    ProjectPlugin.getPlugin().log(e);
                    this.commitRollbackComplete();
                    break block15;
                }
            }
            catch (Throwable throwable) {
                this.commitRollbackComplete();
                throw throwable;
            }
            this.commitRollbackComplete();
        }
        this.fireEvent(new EditManagerEvent(this, -1, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackTransaction() throws IOException {
        this.fireEvent(new EditManagerEvent(this, -3, null, null));
        this.startCommitRollback("Rolling back to Previous checkpoint");
        HashMap<List<FeatureEvent>, FeatureEvent> modified = new HashMap<List<FeatureEvent>, FeatureEvent>();
        try {
            EditManagerImpl editManagerImpl = this;
            synchronized (editManagerImpl) {
                for (Layer layer : this.getMapInternal().getLayersInternal()) {
                    if (layer.getFeatureChanges().size() == 0) continue;
                    List<FeatureEvent> changes = layer.getFeatureChanges();
                    Envelope envelope = new Envelope();
                    for (FeatureEvent event : changes) {
                        envelope.expandToInclude((Envelope)event.getBounds());
                    }
                    FeatureSource source = (FeatureSource)layer.getResource(FeatureSource.class, null);
                    FeatureEvent event = new FeatureEvent(source, 0, envelope);
                    modified.put(changes, event);
                }
            }
            if (this.selectedLayer != null) {
                this.selectedLayer.setFilter((Filter)Filter.EXCLUDE);
            }
            this.transaction.rollbackInternal();
        }
        finally {
            this.commitRollbackComplete();
            this.triggerLayerEvents(modified);
            this.setEditFeature(null, null);
            this.fireEvent(new EditManagerEvent(this, -4, null, null));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetMapInternal((Map)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return this.basicSetMapInternal(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 1: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 9, Map.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getEditFeature();
            }
            case 1: {
                return this.getMapInternal();
            }
            case 2: {
                return this.getEditLayerInternal();
            }
            case 3: {
                return this.getTransactionType();
            }
            case 4: {
                return this.isEditLayerLocked();
            }
            case 5: {
                if (resolve) {
                    return this.getSelectedLayer();
                }
                return this.basicGetSelectedLayer();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setMapInternal((Map)newValue);
                return;
            }
            case 4: {
                this.setEditLayerLocked((Boolean)newValue);
                return;
            }
            case 5: {
                this.setSelectedLayer((Layer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setMapInternal(null);
                return;
            }
            case 4: {
                this.setEditLayerLocked(false);
                return;
            }
            case 5: {
                this.setSelectedLayer(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return EDIT_FEATURE_EDEFAULT == null ? this.editFeature != null : !EDIT_FEATURE_EDEFAULT.equals(this.editFeature);
            }
            case 1: {
                return this.getMapInternal() != null;
            }
            case 2: {
                return this.editLayerInternal != null;
            }
            case 3: {
                return this.getTransactionType() != null;
            }
            case 4: {
                return this.editLayerLocked;
            }
            case 5: {
                return this.selectedLayer != null;
            }
        }
        return super.eIsSet(featureID);
    }

    private void triggerLayerEvents(HashMap<List<FeatureEvent>, FeatureEvent> modified) {
        for (Map.Entry<List<FeatureEvent>, FeatureEvent> entry : modified.entrySet()) {
            entry.getKey().add(entry.getValue());
            entry.getKey().clear();
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (editFeature: ");
        result.append(this.editFeature);
        result.append(", editLayerLocked: ");
        result.append(this.editLayerLocked);
        result.append(')');
        return result.toString();
    }

    @Override
    public void addFeature(SimpleFeature feature, Layer layer) throws IOException {
        SimpleFeature adaptableFeature = feature;
        if (!(feature instanceof IAdaptable)) {
            adaptableFeature = new AdaptableFeature(feature, layer);
        }
        final SimpleFeature finalFeature = adaptableFeature;
        FeatureStore store = (FeatureStore)layer.getResource(FeatureStore.class, null);
        AdaptorFeatureCollection c = new AdaptorFeatureCollection("copyCollection", (SimpleFeatureType)store.getSchema()){

            public int size() {
                return 1;
            }

            protected Iterator openIterator() {
                return new Iterator(){
                    boolean more = true;

                    @Override
                    public boolean hasNext() {
                        return this.more;
                    }

                    public Object next() {
                        this.more = false;
                        return finalFeature;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            protected void closeIterator(Iterator close) {
            }
        };
        store.addFeatures((FeatureCollection)c);
    }

    @Override
    public void refreshEditFeature() {
        Layer editLayer = this.getEditLayerInternal();
        try {
            FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
            FeatureStore resource = (FeatureStore)editLayer.getResource(FeatureStore.class, null);
            Set fids = FeatureUtils.stringToId((FilterFactory)filterFactory, (String)this.getEditFeature().getID());
            Id filter = filterFactory.id(fids);
            FeatureIterator features = resource.getFeatures((Filter)filter).features();
            if (features.hasNext()) {
                SimpleFeature feature = (SimpleFeature)features.next();
                this.setEditFeature(feature, editLayer);
            } else {
                this.setEditFeature(null, editLayer);
            }
        }
        catch (Exception e) {
            ProjectPlugin.log(null, e);
            this.setEditFeature(null, editLayer);
        }
    }

    @Override
    public Layer getSelectedLayer() {
        List<Layer> layers;
        if (this.selectedLayer != null && !this.getMap().getMapLayers().contains(this.selectedLayer)) {
            this.selectedLayer = null;
        }
        if (this.selectedLayer == null && (layers = this.getMapInternal().getLayersInternal()).size() != 0) {
            this.setSelectedLayer(layers.get(layers.size() - 1));
        }
        return this.selectedLayer;
    }

    public Layer basicGetSelectedLayer() {
        return this.selectedLayer;
    }

    @Override
    public void setSelectedLayer(Layer selectedLayer) {
        if (!this.getMapInternal().getLayersInternal().contains(selectedLayer) || selectedLayer == this.selectedLayer) {
            return;
        }
        this.setSelectedLayerGen(selectedLayer);
    }

    public void setSelectedLayerGen(Layer newSelectedLayer) {
        Layer oldSelectedLayer = this.selectedLayer;
        this.selectedLayer = newSelectedLayer;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldSelectedLayer, (Object)this.selectedLayer));
        }
    }

    @Override
    public IMap getMap() {
        return this.getMapInternal();
    }

    @Override
    public ILayer getEditLayer() {
        return this.getEditLayerInternal();
    }

    @Override
    public boolean isEditing() {
        for (Layer layer : this.getMapInternal().getLayersInternal()) {
            if (layer.getFeatureChanges().size() == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addListener(IEditManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean containsListener(IEditManagerListener listener) {
        return this.listeners.contains(listener);
    }

    @Override
    public void removeListener(IEditManagerListener listener) {
        this.listeners.remove(listener);
    }

    void fireEvent(EditManagerEvent event) {
        this.listeners.remove(null);
        for (IEditManagerListener object : this.listeners) {
            try {
                if (object == null) continue;
                object.changed(event);
            }
            catch (Throwable e) {
                ProjectPlugin.log("Error while notifying listener of event: " + event.getType(), e);
            }
        }
    }

    @Override
    public boolean isEditLayerLocked() {
        return this.editLayerLocked;
    }

    @Override
    public void setEditLayerLocked(boolean newEditLayerLocked) {
        boolean oldEditLayerLocked = this.editLayerLocked;
        this.editLayerLocked = newEditLayerLocked;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldEditLayerLocked, this.editLayerLocked));
        }
    }
}

