/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.impl;

import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMapCompositionListener;
import net.refractions.udig.project.MapCompositionEvent;
import net.refractions.udig.project.internal.ContextModel;
import net.refractions.udig.project.internal.ContextModelListenerAdapter;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.impl.MapImpl;
import org.eclipse.emf.common.notify.Notification;

final class EMFCompositionEventToMapCompositionEventListener
extends ContextModelListenerAdapter {
    private final MapImpl map;

    EMFCompositionEventToMapCompositionEventListener(MapImpl mapImpl) {
        this.map = mapImpl;
    }

    @Override
    public void notifyChanged(Notification msg) {
        if (!(msg.getNotifier() instanceof ContextModel)) {
            throw new IllegalArgumentException("This listener should only be added to Context Models");
        }
        this.fireEventToCompositionListeners(msg);
        if (this.map.eResource() != null) {
            this.map.eResource().setModified(true);
        }
    }

    private void notifyCompositionListeners(MapCompositionEvent event) {
        for (IMapCompositionListener listener : this.map.compositionListeners) {
            try {
                listener.changed(event);
            }
            catch (Throwable t) {
                ProjectPlugin.log("", t);
            }
        }
    }

    private void fireEventToCompositionListeners(Notification msg) {
        if (msg.getFeatureID(ContextModel.class) == 0) {
            switch (msg.getEventType()) {
                case 3: {
                    this.notifyCompositionListeners(new MapCompositionEvent(this.map, MapCompositionEvent.EventType.ADDED, msg.getNewValue(), msg.getOldValue(), (ILayer)msg.getNewValue()));
                    break;
                }
                case 5: {
                    this.notifyCompositionListeners(new MapCompositionEvent(this.map, MapCompositionEvent.EventType.MANY_ADDED, msg.getNewValue(), msg.getOldValue(), null));
                    break;
                }
                case 4: {
                    this.notifyCompositionListeners(new MapCompositionEvent(this.map, MapCompositionEvent.EventType.REMOVED, msg.getNewValue(), msg.getOldValue(), (ILayer)msg.getOldValue()));
                    break;
                }
                case 6: {
                    this.notifyCompositionListeners(new MapCompositionEvent(this.map, MapCompositionEvent.EventType.MANY_REMOVED, msg.getNewValue(), msg.getOldValue(), null));
                    break;
                }
                case 7: {
                    this.notifyCompositionListeners(new MapCompositionEvent(this.map, MapCompositionEvent.EventType.REORDERED, msg.getPosition(), msg.getOldValue(), (ILayer)msg.getNewValue()));
                    break;
                }
            }
        }
    }
}

