/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.impl;

import com.vividsolutions.jts.geom.Envelope;
import java.util.Collection;
import java.util.List;
import net.refractions.udig.project.ILegendItem;
import net.refractions.udig.project.internal.ContextModel;
import net.refractions.udig.project.internal.Folder;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.LayerLegendItem;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.ProjectFactory;
import net.refractions.udig.project.internal.ProjectPackage;
import net.refractions.udig.project.internal.impl.LayersList2;
import net.refractions.udig.project.internal.impl.SynchronizedEList;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.opengis.filter.Filter;

public class ContextModelImpl
extends EObjectImpl
implements ContextModel {
    private LayersList2 layers = new LayersList2(Layer.class, (InternalEObject)this, 0, 0);
    private volatile EList eAdapters;

    protected ContextModelImpl() {
        this.setLegendItemSynchronizer();
    }

    private void setLegendItemSynchronizer() {
        this.layers.addDeepAdapter((Adapter)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                super.notifyChanged(msg);
                if (msg.getFeatureID(ContextModel.class) == 0) {
                    switch (msg.getEventType()) {
                        case 3: {
                            List<ILegendItem> legend;
                            Map map;
                            Object eventNewObj = msg.getNewValue();
                            if (!(eventNewObj instanceof Layer) || (map = ContextModelImpl.this.getMap()) == null || (legend = map.getLegend()) == null) break;
                            LayerLegendItem layerLegendItem = ProjectFactory.eINSTANCE.createLayerLegendItem();
                            layerLegendItem.setLayer((Layer)eventNewObj);
                            legend.add(layerLegendItem);
                            break;
                        }
                        case 4: {
                            Object eventOldObj = msg.getOldValue();
                            if (!(eventOldObj instanceof Layer)) break;
                            Layer layer = (Layer)eventOldObj;
                            ContextModelImpl.this.removeLayerLegendItem(layer);
                        }
                    }
                }
            }
        });
    }

    private boolean removeLayerLegendItem(Layer layer) {
        LayerLegendItem flaggedLayerItem = null;
        Map map = this.getMap();
        if (map == null) {
            return false;
        }
        for (ILegendItem item : map.getLegend()) {
            LayerLegendItem layerItem;
            if (item instanceof Folder) {
                boolean isRemoved = this.removeLayerLegendItem((Folder)item, layer);
                if (!isRemoved) continue;
                return true;
            }
            if (!(item instanceof LayerLegendItem) || layer != (layerItem = (LayerLegendItem)item).getLayer()) continue;
            flaggedLayerItem = layerItem;
            break;
        }
        if (flaggedLayerItem != null) {
            map.getLegend().remove(flaggedLayerItem);
            return true;
        }
        return false;
    }

    private boolean removeLayerLegendItem(Folder folder, Layer layer) {
        Folder flaggedFolder = null;
        LayerLegendItem flaggedLayerItem = null;
        for (ILegendItem item : folder.getItems()) {
            LayerLegendItem layerItem;
            if (item instanceof Folder) {
                boolean isRemoved = this.removeLayerLegendItem((Folder)item, layer);
                if (!isRemoved) continue;
                return true;
            }
            if (!(item instanceof LayerLegendItem) || layer != (layerItem = (LayerLegendItem)item).getLayer()) continue;
            flaggedFolder = folder;
            flaggedLayerItem = layerItem;
            break;
        }
        if (flaggedLayerItem != null) {
            flaggedFolder.getItems().remove(flaggedLayerItem);
            return true;
        }
        return false;
    }

    protected EClass eStaticClass() {
        return ProjectPackage.Literals.CONTEXT_MODEL;
    }

    @Override
    public List<Layer> getLayers() {
        return this.layers;
    }

    @Override
    public List<Layer> layers() {
        return this.getLayers();
    }

    @Override
    public Map getMap() {
        if (this.eContainerFeatureID() != 1) {
            return null;
        }
        return (Map)this.eContainer();
    }

    public NotificationChain basicSetMap(Map newMap, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newMap, 1, msgs);
        return msgs;
    }

    @Override
    public void setMap(Map newMap) {
        if (newMap != this.eInternalContainer() || this.eContainerFeatureID() != 1 && newMap != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newMap)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newMap != null) {
                msgs = ((InternalEObject)newMap).eInverseAdd((InternalEObject)this, 2, Map.class, msgs);
            }
            if ((msgs = this.basicSetMap(newMap, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newMap, (Object)newMap));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getLayers()).basicAdd((Object)otherEnd, msgs);
            }
            case 1: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetMap((Map)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getLayers()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return this.basicSetMap(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 1: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 2, Map.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getLayers();
            }
            case 1: {
                return this.getMap();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getLayers().clear();
                this.getLayers().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setMap((Map)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getLayers().clear();
                return;
            }
            case 1: {
                this.setMap(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.layers != null && !this.layers.isEmpty();
            }
            case 1: {
                return this.getMap() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public void addDeepAdapter(Adapter adapter) {
        this.getMap().addDeepAdapter(adapter);
    }

    @Override
    public void removeDeepAdapter(Adapter adapter) {
        this.getMap().removeDeepAdapter(adapter);
    }

    @Override
    public void lowerLayer(Layer layer) {
        this.getMap().lowerLayer(layer);
    }

    @Override
    public void raiseLayer(Layer layer) {
        this.getMap().raiseLayer(layer);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getLayers() != null && !this.getLayers().isEmpty();
            }
            case 1: {
                return this.getMap() != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public void setNotification(boolean notify) {
        this.eFlags = notify ? (this.eFlags |= 1) : (this.eFlags &= 0xFFFFFFFE);
    }

    @Override
    public void select(Envelope boundingBox) {
        this.getMap().select(boundingBox);
    }

    @Override
    public void select(Envelope boundingBox, boolean and) {
        this.getMap().select(boundingBox, and);
    }

    @Override
    public void select(Filter filter) {
        this.getMap().select(filter);
    }

    @Override
    public void select(Filter filter, boolean and) {
        this.getMap().select(filter, and);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList eAdapters() {
        if (this.eAdapters == null) {
            ContextModelImpl contextModelImpl = this;
            synchronized (contextModelImpl) {
                if (this.eAdapters == null) {
                    this.eAdapters = new SynchronizedEList(super.eAdapters());
                }
            }
        }
        return this.eAdapters;
    }
}

