/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.commands.edit;

import java.util.Collections;
import net.refractions.udig.core.IBlockingProvider;
import net.refractions.udig.core.StaticFeatureCollection;
import net.refractions.udig.core.internal.FeatureUtils;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.command.provider.EditFeatureProvider;
import net.refractions.udig.project.command.provider.EditLayerFeatureStoreProvider;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.commands.edit.AbstractEditCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.geotools.data.FeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;

public class WriteFeatureChangesCommand
extends AbstractEditCommand
implements UndoableMapCommand {
    private IBlockingProvider<SimpleFeature> featureProvider;
    private IBlockingProvider<FeatureStore<SimpleFeatureType, SimpleFeature>> storeProvider;
    private FeatureStore<SimpleFeatureType, SimpleFeature> store;
    private Id filter;
    private boolean added = false;
    private boolean noChange = false;
    private SimpleFeature editFeature;

    public WriteFeatureChangesCommand() {
        this(null, null);
    }

    public WriteFeatureChangesCommand(IBlockingProvider<SimpleFeature> feature, IBlockingProvider<FeatureStore<SimpleFeatureType, SimpleFeature>> featureStore) {
        this.featureProvider = feature == null ? new EditFeatureProvider(this) : feature;
        this.storeProvider = featureStore == null ? new EditLayerFeatureStoreProvider(this) : featureStore;
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(Messages.WriteFeatureChangesCommand_runTask, 3);
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(monitor, 1);
        this.editFeature = (SimpleFeature)this.featureProvider.get((IProgressMonitor)subProgressMonitor, new Object[0]);
        subProgressMonitor.done();
        this.store = (FeatureStore)this.storeProvider.get((IProgressMonitor)subProgressMonitor, new Object[0]);
        if (this.editFeature == null || this.store == null) {
            this.noChange = true;
            return;
        }
        SimpleFeatureType featureType = this.editFeature.getFeatureType();
        FilterFactory factory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        subProgressMonitor = new SubProgressMonitor(monitor, 1);
        subProgressMonitor.done();
        this.filter = factory.id(FeatureUtils.stringToId((FilterFactory)factory, (String)this.editFeature.getID()));
        FeatureCollection results = this.store.getFeatures((Filter)this.filter);
        FeatureIterator reader = results.features();
        try {
            if (reader.hasNext()) {
                try {
                    this.store.modifyFeatures(featureType.getAttributeDescriptors().toArray(new AttributeDescriptor[0]), this.editFeature.getAttributes().toArray(), (Filter)this.filter);
                }
                catch (Exception e) {
                    ProjectPlugin.log("", e);
                    this.noChange = true;
                }
            } else {
                this.added = true;
                this.store.addFeatures((FeatureCollection)new StaticFeatureCollection(Collections.singleton(this.editFeature), featureType));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Override
    public MapCommand copy() {
        return new WriteFeatureChangesCommand();
    }

    @Override
    public String getName() {
        return Messages.WriteFeatureChangesCommand_commandName;
    }

    @Override
    public void rollback(IProgressMonitor monitor) throws Exception {
        if (this.noChange) {
            return;
        }
        monitor.beginTask(Messages.WriteFeatureChangesCommand_rollbackTask, -1);
        if (this.added) {
            this.store.removeFeatures((Filter)this.filter);
        } else {
            SimpleFeatureType featureType = this.editFeature.getFeatureType();
            this.store.modifyFeatures(featureType.getAttributeDescriptors().toArray(new AttributeDescriptor[0]), this.editFeature.getAttributes().toArray(), (Filter)this.filter);
        }
    }
}

