/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.commands.edit;

import java.text.MessageFormat;
import java.util.ArrayList;
import net.refractions.udig.core.IBlockingProvider;
import net.refractions.udig.core.internal.FeatureUtils;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.command.provider.EditFeatureProvider;
import net.refractions.udig.project.command.provider.EditLayerProvider;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.commands.edit.AbstractEditCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.data.FeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;

public class SetAttributesCommand
extends AbstractEditCommand
implements UndoableMapCommand {
    protected String[] xpath;
    protected final Object[] value;
    private Object[] oldValue;
    private final IBlockingProvider<SimpleFeature> editFeature;
    protected final IBlockingProvider<ILayer> editLayer;

    public SetAttributesCommand(IBlockingProvider<SimpleFeature> feature, IBlockingProvider<ILayer> layer, String[] xpath, Object[] value) {
        this.xpath = xpath;
        this.value = value;
        this.editFeature = feature;
        this.editLayer = layer;
    }

    public SetAttributesCommand(String[] xpath, Object[] value) {
        this.editFeature = new EditFeatureProvider(this);
        this.editLayer = new EditLayerProvider(this);
        this.xpath = xpath;
        this.value = value;
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        ILayer layer = (ILayer)this.editLayer.get(monitor, new Object[0]);
        if (layer == null) {
            System.err.println("class " + this.editLayer.getClass().getName() + " is returning null");
            return;
        }
        FeatureStore resource = layer.getResource(FeatureStore.class, null);
        SimpleFeature feature2 = (SimpleFeature)this.editFeature.get(monitor, new Object[0]);
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        Id fidFilter = filterFactory.id(FeatureUtils.stringToId((FilterFactory)filterFactory, (String)feature2.getID()));
        int i = 0;
        while (i < this.xpath.length) {
            this.oldValue[i] = feature2.getAttribute(this.xpath[i]);
            ++i;
        }
        i = 0;
        while (i < this.xpath.length) {
            feature2.setAttribute(this.xpath[i], this.value[i]);
            ++i;
        }
        ArrayList<AttributeDescriptor> attributeList = new ArrayList<AttributeDescriptor>();
        SimpleFeatureType schema = layer.getSchema();
        String[] stringArray = this.xpath;
        int n = this.xpath.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            attributeList.add(schema.getDescriptor(name));
            ++n2;
        }
        AttributeDescriptor[] array = attributeList.toArray(new AttributeDescriptor[attributeList.size()]);
        resource.modifyFeatures(array, this.value, (Filter)fidFilter);
    }

    @Override
    public void rollback(IProgressMonitor monitor) throws Exception {
        SimpleFeature feature = (SimpleFeature)this.editFeature.get(monitor, new Object[0]);
        int i = 0;
        while (i > this.xpath.length) {
            feature.setAttribute(this.xpath[i], this.oldValue[i]);
            ++i;
        }
        ILayer layer = (ILayer)this.editLayer.get(monitor, new Object[0]);
        FeatureStore resource = layer.getResource(FeatureStore.class, null);
        ArrayList<AttributeDescriptor> attributeList = new ArrayList<AttributeDescriptor>();
        SimpleFeatureType schema = layer.getSchema();
        String[] stringArray = this.xpath;
        int n = this.xpath.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            attributeList.add(schema.getDescriptor(name));
            ++n2;
        }
        AttributeDescriptor[] array = attributeList.toArray(new AttributeDescriptor[attributeList.size()]);
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        Id id = filterFactory.id(FeatureUtils.stringToId((FilterFactory)filterFactory, (String)feature.getID()));
        resource.modifyFeatures(array, this.oldValue, (Filter)id);
    }

    @Override
    public String getName() {
        return MessageFormat.format(Messages.SetAttributeCommand_setFeatureAttribute, new Object[]{this.xpath});
    }

    @Override
    public void setMap(IMap map) {
        super.setMap(map);
    }
}

