/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.commands.edit;

import com.vividsolutions.jts.geom.Envelope;
import java.util.List;
import net.refractions.udig.project.IEditManager;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureStore;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;

public class DeleteManyFeaturesCommand
extends AbstractCommand {
    private ILayer ilayer;
    private Filter filter;

    public DeleteManyFeaturesCommand(ILayer layer, Filter filter) {
        this.ilayer = layer;
        this.filter = filter;
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        FeatureStore fs = this.ilayer.getResource(FeatureStore.class, monitor);
        Layer layer = null;
        if (this.ilayer instanceof Layer) {
            layer = (Layer)this.ilayer;
        }
        int events = 0;
        try {
            if (layer != null) {
                layer.eSetDeliver(false);
                events = layer.getFeatureChanges().size();
            }
            fs.removeFeatures(this.filter);
            IEditManager editManager = this.getMap().getEditManager();
            SimpleFeature editFeature = editManager.getEditFeature();
            if (editFeature != null && editManager.getEditLayer() == this.ilayer && this.filter.evaluate((Object)editFeature)) {
                this.getMap().getEditManagerInternal().setEditFeature(null, null);
            }
        }
        finally {
            this.fireFeatureChangeEvent(layer, events);
        }
    }

    private void fireFeatureChangeEvent(Layer layer, int events) {
        if (layer != null) {
            layer.eSetDeliver(true);
            List<FeatureEvent> tmp = layer.getFeatureChanges();
            List<FeatureEvent> eventList = tmp.subList(events, tmp.size());
            Envelope bounds = new Envelope();
            for (FeatureEvent event : eventList) {
                if (bounds.isNull()) {
                    bounds.init((Envelope)event.getBounds());
                    continue;
                }
                bounds.expandToInclude((Envelope)event.getBounds());
            }
            if (!eventList.isEmpty()) {
                FeatureEvent event;
                event = eventList.get(0);
                tmp.add(new FeatureEvent(event.getFeatureSource(), event.getEventType(), bounds));
            }
        }
    }

    @Override
    public String getName() {
        return Messages.DeleteManyFeaturesCommand_name;
    }
}

