/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.commands;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.EditManager;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;

public class DeleteLayerCommand
extends AbstractCommand
implements UndoableMapCommand {
    private Layer layer;
    private int index;
    private Map map;
    private boolean wasSelected;

    public DeleteLayerCommand(Layer layer) {
        this.map = layer.getMapInternal();
        this.layer = layer;
    }

    @Override
    public void rollback(IProgressMonitor monitor) throws Exception {
        if (this.layer == null) {
            return;
        }
        this.map.getLayersInternal().add(this.index, this.layer);
        if (this.wasSelected) {
            this.map.getEditManagerInternal().setSelectedLayer(this.layer);
        }
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        if (!this.map.getLayersInternal().contains(this.layer)) {
            this.layer = null;
            return;
        }
        List<Layer> layers = this.map.getLayersInternal();
        this.index = layers.indexOf(this.layer);
        this.wasSelected = DeleteLayerCommand.selectNewLayer(this.map, Collections.singleton(this.layer));
        layers.remove(this.layer);
        this.map.getColourScheme().removeItem(this.layer.getID().toString(), this.layer.getDefaultColor());
    }

    static boolean selectNewLayer(Map map, Collection<? extends ILayer> toRemove) {
        Layer layer;
        EditManager editManager = map.getEditManagerInternal();
        List<Layer> layers = map.getLayersInternal();
        Layer selectedLayer = editManager.getSelectedLayer();
        if (!toRemove.contains(selectedLayer)) {
            return false;
        }
        int i = layers.indexOf(selectedLayer) + 1;
        while (i < layers.size()) {
            layer = layers.get(i);
            if (!toRemove.contains(layer)) {
                editManager.setSelectedLayer(layer);
                return true;
            }
            ++i;
        }
        i = layers.indexOf(selectedLayer) - 1;
        while (i >= 0) {
            layer = layers.get(i);
            if (!toRemove.contains(layer)) {
                editManager.setSelectedLayer(layer);
                return true;
            }
            --i;
        }
        editManager.setSelectedLayer(null);
        return true;
    }

    @Override
    public String getName() {
        return MessageFormat.format(Messages.DeleteLayerCommand_deleteLayer, this.layer.getName());
    }
}

