/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.LayerFactory;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.ProjectPlugin;
import org.eclipse.core.runtime.IProgressMonitor;

public class AddLayersCommand
extends AbstractCommand
implements UndoableMapCommand {
    Collection<?> resources;
    List<Layer> layers;
    private int index;
    private Layer selection;

    public AddLayersCommand(Collection<?> resources) {
        this(resources, -1);
    }

    public AddLayersCommand(Collection<?> resources, int i) {
        this.resources = resources;
        this.index = i;
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        Map map = this.getMap();
        if (this.layers == null) {
            this.layers = new ArrayList<Layer>();
            LayerFactory layerFactory = map.getLayerFactory();
            this.selection = (Layer)map.getEditManager().getSelectedLayer();
            for (Object o : this.resources) {
                try {
                    Layer layer = null;
                    if (o instanceof IGeoResource) {
                        IGeoResource resource = (IGeoResource)o;
                        layer = layerFactory.createLayer(resource);
                    }
                    if (o instanceof Layer) {
                        layer = (Layer)o;
                    }
                    if (layer == null) continue;
                    this.layers.add(layer);
                }
                catch (Throwable t) {
                    ProjectPlugin.log("Unable to add " + o, t);
                }
            }
        }
        if (!this.layers.isEmpty()) {
            if (this.index < 0) {
                this.index = map.getLayersInternal().size();
            }
            this.trace();
            map.getLayersInternal().addAll(this.index, this.layers);
            map.getEditManagerInternal().setSelectedLayer(this.layers.get(0));
        }
    }

    private void trace() {
        if (ProjectPlugin.isDebugging("net.refractions.udig.project/debug/commands/trace")) {
            ArrayList<String> ids = new ArrayList<String>();
            for (Layer layer : this.layers) {
                ids.add(layer.getID().toString());
            }
            ProjectPlugin.trace(this.getClass(), "Adding " + this.layers.size() + " layers to map:" + this.getMap().getName() + ".  IDs=" + ids, null);
        }
    }

    @Override
    public String getName() {
        return Messages.AddLayersCommand_name;
    }

    @Override
    public void rollback(IProgressMonitor monitor) throws Exception {
        this.getMap().getLayersInternal().removeAll(this.layers);
        this.getMap().getEditManagerInternal().setSelectedLayer(this.selection);
        this.layers.clear();
    }

    public List<Layer> getLayers() {
        return this.layers;
    }
}

