/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.commands;

import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;

public class AddLayerItemCommand
extends AbstractCommand
implements UndoableMapCommand {
    private Layer layer;
    private IGeoResource geoResource;
    private int index = -1;

    public AddLayerItemCommand(Layer layer) {
        this(layer, -1);
    }

    public AddLayerItemCommand(Layer layer, int index) {
        this.layer = layer;
        this.index = index;
    }

    public AddLayerItemCommand(IGeoResource geoResource) {
        this(geoResource, -1);
    }

    public AddLayerItemCommand(IGeoResource geoResource, int index) {
        this.geoResource = geoResource;
        this.index = index;
    }

    @Override
    public String getName() {
        if (this.layer == null) {
            return Messages.AddLayerItemCommand_Name;
        }
        return String.valueOf(Messages.AddLayerItemCommand_Name) + this.layer.getName();
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        Map map = this.getMap();
        if (this.layer == null) {
            if (this.geoResource instanceof IGeoResource) {
                this.layer = map.getLayerFactory().createLayer(this.geoResource);
            }
            if (this.geoResource instanceof Layer) {
                this.layer = (Layer)this.geoResource;
            }
        }
        if (this.layer != null) {
            if (this.index < 0 || this.index > this.getMap().getLegend().size()) {
                map.getLegend().add(this.layer);
            } else {
                map.getLegend().add(this.index, this.layer);
            }
        }
    }

    @Override
    public void rollback(IProgressMonitor monitor) throws Exception {
        if (this.layer != null) {
            this.getMap().getLegend().remove(this.layer);
        }
    }
}

