/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.commands;

import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;

public class AddLayerCommand
extends AbstractCommand
implements UndoableMapCommand {
    private Layer layer;
    private int index = -1;
    private ILayer selectedLayer;

    public AddLayerCommand(Layer layer) {
        this(layer, -1);
    }

    public AddLayerCommand(Layer layer, int index) {
        this.layer = layer;
        this.index = index;
    }

    @Override
    public void rollback(IProgressMonitor monitor) throws Exception {
        this.getMap().getLayersInternal().remove(this.layer);
        this.getMap().getEditManagerInternal().setSelectedLayer((Layer)this.selectedLayer);
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        this.selectedLayer = this.getMap().getEditManager().getSelectedLayer();
        if (this.index < 0 || this.index > this.getMap().getLayersInternal().size()) {
            this.getMap().getLayersInternal().add(this.layer);
        } else {
            this.getMap().getLayersInternal().add(this.index, this.layer);
        }
    }

    @Override
    public String getName() {
        return String.valueOf(Messages.AddLayerCommand_Name) + this.layer.getName();
    }
}

