/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.command.navigation;

import com.vividsolutions.jts.geom.Coordinate;
import java.text.MessageFormat;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.NavCommand;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.command.navigation.AbstractNavCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class SetViewportCenterCommand
extends AbstractNavCommand
implements NavCommand {
    private Coordinate center;
    private CoordinateReferenceSystem crs;

    public SetViewportCenterCommand(Coordinate center) {
        this(center, null);
    }

    public SetViewportCenterCommand(Coordinate coordinate, CoordinateReferenceSystem crs) {
        this.center = coordinate;
        this.crs = crs;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        Coordinate newCenter = this.center;
        if (this.crs != null) {
            newCenter = this.transform();
        }
        this.model.setCenter(newCenter);
    }

    private Coordinate transform() {
        try {
            return JTS.transform((Coordinate)this.center, (Coordinate)new Coordinate(), (MathTransform)CRS.findMathTransform((CoordinateReferenceSystem)this.crs, (CoordinateReferenceSystem)this.model.getCRS(), (boolean)true));
        }
        catch (Exception e) {
            ProjectPlugin.log("", e);
            return null;
        }
    }

    @Override
    public MapCommand copy() {
        return new SetViewportCenterCommand(this.center);
    }

    @Override
    public String getName() {
        return MessageFormat.format(Messages.SetViewportCenterCommand_setViewCenter, this.center);
    }
}

