/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.command.navigation;

import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.NavCommand;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.command.navigation.AbstractNavCommand;
import org.eclipse.core.runtime.IProgressMonitor;

public class PanCommand
extends AbstractNavCommand
implements NavCommand {
    double worldx;
    double worldy;
    int pixelx;
    int pixely;
    boolean inPixel;

    public PanCommand(int pixelx, int pixely) {
        this.pixelx = pixelx;
        this.pixely = pixely;
        this.inPixel = true;
    }

    public PanCommand(double worldx, double worldy) {
        this.worldx = worldx;
        this.worldy = worldy;
        this.inPixel = false;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        if (this.inPixel) {
            this.model.panUsingScreenCoords(this.pixelx, this.pixely);
        } else {
            this.model.panUsingWorldCoords(this.worldx, this.worldy);
        }
    }

    @Override
    public MapCommand copy() {
        if (this.inPixel) {
            return new PanCommand(this.pixelx, this.pixely);
        }
        return new PanCommand(this.worldx, this.worldy);
    }

    @Override
    public String getName() {
        return Messages.PanCommand_pan;
    }
}

