/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.command.navigation;

import com.vividsolutions.jts.geom.Envelope;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.NavCommand;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.render.ViewportModel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class AbstractNavCommand
implements NavCommand {
    private Envelope oldbbox = null;
    protected ViewportModel model = null;
    private Map map;
    private CoordinateReferenceSystem oldCRS;

    @Override
    public void rollback(IProgressMonitor monitor) throws Exception {
        if (this.model == null) {
            return;
        }
        boolean oldDeliver = this.model.eDeliver();
        try {
            this.model.eSetDeliver(false);
            if (!CRS.equalsIgnoreMetadata((Object)this.model.getCRS(), (Object)this.oldCRS)) {
                this.model.setCRS(this.oldCRS);
            }
        }
        finally {
            this.model.eSetDeliver(oldDeliver);
        }
        this.model.zoomToBox(this.oldbbox);
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        if (this.model == null) {
            this.getMap().sendCommandASync(this);
            return;
        }
        this.oldbbox = this.model.getBounds();
        this.oldCRS = this.model.getCRS();
        this.runImpl(monitor);
    }

    protected abstract void runImpl(IProgressMonitor var1) throws Exception;

    @Override
    public void setViewportModel(ViewportModel model) {
        this.model = model;
    }

    @Override
    public void setMap(IMap map) {
        this.map = (Map)map;
    }

    @Override
    public Map getMap() {
        return this.map;
    }
}

