/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal;

import java.awt.Color;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.core.internal.ExtensionPointProcessor;
import net.refractions.udig.core.internal.ExtensionPointUtil;
import net.refractions.udig.project.StyleContent;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.ProjectPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Plugin;

public final class SetDefaultStyleProcessor
implements ExtensionPointProcessor {
    private final IGeoResource theResource;
    private final Layer theLayer;

    public SetDefaultStyleProcessor(IGeoResource theResource, Layer theLayer) {
        if (theResource == null) {
            throw new NullPointerException("Resource required to create default styles");
        }
        this.theResource = theResource;
        if (theLayer == null) {
            throw new NullPointerException("Layer is required to create default styles");
        }
        this.theLayer = theLayer;
    }

    public void process(IExtension extension, IConfigurationElement element) throws Exception {
        Color defaultColor;
        StyleContent styleContent = (StyleContent)element.createExecutableExtension("class");
        Object style = styleContent.createDefaultStyle(this.theResource, defaultColor = this.theLayer.getDefaultColor(), null);
        if (style != null) {
            this.theLayer.getStyleBlackboard().put(styleContent.getId(), style);
        }
    }

    public void run() {
        ExtensionPointUtil.process((Plugin)ProjectPlugin.getPlugin(), (String)"net.refractions.udig.project.style", (ExtensionPointProcessor)this);
    }
}

