/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.ProjectElement;
import net.refractions.udig.project.internal.ProjectRegistry;
import net.refractions.udig.project.internal.impl.ProjectRegistryImpl;
import net.refractions.udig.ui.PostShutdownTask;
import net.refractions.udig.ui.ShutdownTaskList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;

public final class ProjectPlugin
extends EMFPlugin {
    public static final String ID = "net.refractions.udig.project";
    public static final ProjectPlugin INSTANCE = new ProjectPlugin();
    static Implementation plugin;

    public ProjectPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Collection<String> saveProjects(Collection<Project> projects) {
        ArrayList<String> errors = new ArrayList<String>();
        for (Project project : projects) {
            try {
                Resource eResource = project.eResource();
                Map<String, String> saveOptions = ProjectPlugin.getPlugin().saveOptions;
                eResource.save(saveOptions);
                List<ProjectElement> elementsInternal = project.getElementsInternal();
                for (ProjectElement projectElement : elementsInternal) {
                    projectElement.eResource().save(saveOptions);
                }
            }
            catch (Exception e) {
                ProjectPlugin.log("Error while saving resource", e);
                String msg = "Error occurred while saving project: " + project.getID().toString();
                errors.add(msg);
            }
        }
        return errors;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static void log(String message) {
        ProjectPlugin.log(message, null);
    }

    public static void log(String message, Throwable e) {
        ProjectPlugin.getPlugin().getLog().log((IStatus)new Status(1, ID, 0, message == null ? "" : message, e));
    }

    private static void trace(String message, Throwable e) {
        if (ProjectPlugin.getPlugin().isDebugging()) {
            if (message != null) {
                System.out.println(message);
            }
            if (e != null) {
                e.printStackTrace(System.out);
            }
        }
    }

    public static void trace(String traceID, Class caller, String message, Throwable e) {
        if (ProjectPlugin.isDebugging(traceID)) {
            ProjectPlugin.trace(caller, message, e);
        }
    }

    public static void trace(Class caller, String message, Throwable e) {
        ProjectPlugin.trace(String.valueOf(caller.getSimpleName()) + ": " + message, e);
    }

    public static boolean isDebugging(String trace) {
        return ProjectPlugin.getPlugin().isDebugging() && "true".equalsIgnoreCase(Platform.getDebugOption((String)trace));
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public boolean undoableCommandWarning = true;
        protected static final String ENCODING = "UTF-8";
        public Map<String, String> saveOptions = new HashMap<String, String>();
        private ScopedPreferenceStore preferenceStore;

        public Implementation() {
            this.saveOptions.put("ENCODING", ENCODING);
            plugin = this;
        }

        public void setUndoableCommandWarning(boolean value) {
            this.undoableCommandWarning = value;
        }

        public boolean getUndoableCommandWarning() {
            return this.undoableCommandWarning;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            ShutdownTaskList.instance().addPostShutdownTask(new PostShutdownTask(){

                public int getProgressMonitorSteps() {
                    EList resources = Implementation.this.getProjectRegistry().eResource().getResourceSet().getResources();
                    return resources.size();
                }

                public void handlePostShutdownException(Throwable t) {
                    ProjectPlugin.log("", t);
                }

                public void postShutdown(IProgressMonitor monitor, IWorkbench workbench) throws Exception {
                    monitor.beginTask(Messages.ProjectPlugin_saving_task_name, 0);
                    Implementation.this.turnOffEvents();
                    EList resources = Implementation.this.getProjectRegistry().eResource().getResourceSet().getResources();
                    for (Resource resource : resources) {
                        if (resource.getContents().isEmpty()) {
                            ProjectPlugin.log("Not saving " + resource.getURI() + " empty contents");
                            continue;
                        }
                        Object next = resource.getAllContents().next();
                        if (resource.isModified() && next != null && !((EObject)next).eIsProxy()) {
                            try {
                                resource.save(Implementation.this.saveOptions);
                            }
                            catch (Exception e) {
                                ProjectPlugin.log("Error saving " + resource.getURI(), e);
                            }
                        }
                        monitor.worked(1);
                    }
                }
            });
            this.undoableCommandWarning = "true".equals(this.getString("net.refractions.udig.project.undoableCommandWarning"));
        }

        public void stop(BundleContext context) throws Exception {
            super.stop(context);
        }

        public ProjectRegistry getProjectRegistry() {
            return ProjectRegistryImpl.getProjectRegistry();
        }

        public void turnOffEvents() {
            TreeIterator allIter = this.getProjectRegistry().eResource().getResourceSet().getAllContents();
            while (allIter.hasNext()) {
                Object tmp = allIter.next();
                Notifier obj = (Notifier)tmp;
                if (obj == null) continue;
                obj.eSetDeliver(false);
            }
        }

        public synchronized ScopedPreferenceStore getPreferenceStore() {
            if (this.preferenceStore == null) {
                this.preferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), this.getBundle().getSymbolicName());
            }
            return this.preferenceStore;
        }
    }
}

