/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.command.factory;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.net.URL;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.core.IBlockingProvider;
import net.refractions.udig.core.StaticBlockingProvider;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.commands.DeleteLayersCommand;
import net.refractions.udig.project.internal.commands.edit.AddFeatureCommand;
import net.refractions.udig.project.internal.commands.edit.CopyFeaturesCommand;
import net.refractions.udig.project.internal.commands.edit.CreateFeatureCommand;
import net.refractions.udig.project.internal.commands.edit.CreateLayerCommand;
import net.refractions.udig.project.internal.commands.edit.DeleteFeatureCommand;
import net.refractions.udig.project.internal.commands.edit.DeleteManyFeaturesCommand;
import net.refractions.udig.project.internal.commands.edit.ResetEditFeatureCommand;
import net.refractions.udig.project.internal.commands.edit.RollbackCommand;
import net.refractions.udig.project.internal.commands.edit.SetAttributeCommand;
import net.refractions.udig.project.internal.commands.edit.SetEditFeatureCommand;
import net.refractions.udig.project.internal.commands.edit.SetGeometryCommand;
import net.refractions.udig.project.internal.commands.edit.WriteEditFeatureCommand;
import net.refractions.udig.project.internal.commands.selection.CommitCommand;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;

public class EditCommandFactory
extends net.refractions.udig.project.command.EditCommandFactory {
    private static final EditCommandFactory instance = new EditCommandFactory();

    public static EditCommandFactory getInstance() {
        return instance;
    }

    protected EditCommandFactory() {
    }

    @Override
    public UndoableMapCommand createSetAttributeCommand(String xpath, Object value) {
        return new SetAttributeCommand(xpath, value);
    }

    @Override
    public UndoableMapCommand createSetGeometryCommand(String xpath, Geometry geom) {
        return new SetGeometryCommand(xpath, geom);
    }

    @Override
    public UndoableMapCommand createSetGeometryCommand(Geometry geom) {
        return new SetGeometryCommand("DEFAULT_GEOMETRY", geom);
    }

    public UndoableMapCommand createSetAttributeCommand(SimpleFeature feature, ILayer layer, String xpath, Object value) {
        return new SetAttributeCommand((IBlockingProvider<SimpleFeature>)new StaticBlockingProvider((Object)feature), (IBlockingProvider<ILayer>)new StaticBlockingProvider((Object)layer), xpath, value);
    }

    public UndoableMapCommand createSetGeomteryCommand(SimpleFeature feature, ILayer layer, String xpath, Geometry geom) {
        return new SetGeometryCommand((IBlockingProvider<SimpleFeature>)new StaticBlockingProvider((Object)feature), (IBlockingProvider<ILayer>)new StaticBlockingProvider((Object)layer), xpath, geom);
    }

    public UndoableMapCommand createSetGeomteryCommand(SimpleFeature feature, ILayer layer, Geometry geom) {
        return new SetGeometryCommand((IBlockingProvider<SimpleFeature>)new StaticBlockingProvider((Object)feature), (IBlockingProvider<ILayer>)new StaticBlockingProvider((Object)layer), "DEFAULT_GEOMETRY", geom);
    }

    public UndoableMapCommand createSetGeomteryCommand(String featureID, ILayer layer, Geometry geom) {
        return new SetGeometryCommand(featureID, (IBlockingProvider<ILayer>)new StaticBlockingProvider((Object)layer), "DEFAULT_GEOMETRY", geom);
    }

    @Override
    public UndoableMapCommand createSetEditFeatureCommand(SimpleFeature feature, ILayer layer) {
        return new SetEditFeatureCommand(feature, layer);
    }

    @Override
    public MapCommand createCommitCommand() {
        return new CommitCommand();
    }

    @Override
    public MapCommand createRollbackCommand() {
        return new RollbackCommand();
    }

    @Override
    public UndoableMapCommand createSetEditFeatureCommand(SimpleFeature feature) {
        return new SetEditFeatureCommand(feature);
    }

    @Override
    public UndoableMapCommand createNullEditFeatureCommand() {
        return new SetEditFeatureCommand(null, null);
    }

    @Override
    public UndoableMapCommand createFeature(Coordinate[] coordinates) {
        return new CreateFeatureCommand(coordinates);
    }

    public UndoableMapCommand createDeleteLayers(ILayer[] layers) {
        return new DeleteLayersCommand(layers);
    }

    public UndoableMapCommand createDeleteLayer(ILayer layer) {
        return new DeleteLayersCommand(new ILayer[]{layer});
    }

    @Override
    public UndoableMapCommand createDeleteFeature(SimpleFeature feature, ILayer layer) {
        return new DeleteFeatureCommand((IBlockingProvider<SimpleFeature>)new StaticBlockingProvider((Object)feature), (IBlockingProvider<ILayer>)new StaticBlockingProvider((Object)layer));
    }

    public UndoableMapCommand createDeleteFeature(IBlockingProvider<SimpleFeature> provider, IBlockingProvider<ILayer> layerProvider) {
        return new DeleteFeatureCommand(provider, layerProvider);
    }

    @Override
    public UndoableMapCommand createWriteEditFeatureCommand() {
        return new WriteEditFeatureCommand();
    }

    @Override
    public UndoableMapCommand createCreateLayerCommand(URL resourceId) {
        return new CreateLayerCommand(resourceId);
    }

    @Override
    public UndoableMapCommand createCreateLayerCommand(IGeoResource resource) {
        return new CreateLayerCommand(resource);
    }

    @Override
    public UndoableMapCommand createResetEditFeatureCommand() {
        return new ResetEditFeatureCommand();
    }

    public MapCommand createDeleteFeatures(ILayer selectedLayer, Filter filter) {
        return new DeleteManyFeaturesCommand(selectedLayer, filter);
    }

    public UndoableMapCommand createCopyFeaturesCommand(ILayer sourceLayer, Filter filter, ILayer destinationLayer) {
        return new CopyFeaturesCommand(sourceLayer, filter, (Layer)destinationLayer);
    }

    public UndoableMapCommand createAddFeatureCommand(SimpleFeature feature, ILayer layer) {
        return new AddFeatureCommand(feature, layer);
    }

    public static /* bridge */ /* synthetic */ net.refractions.udig.project.command.EditCommandFactory getInstance() {
        return EditCommandFactory.getInstance();
    }
}

