/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.command;

import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import org.eclipse.core.runtime.IProgressMonitor;

public class SetLayersVisibilityCommand
extends AbstractCommand
implements UndoableMapCommand {
    private final List<ILayer> layers;
    private final boolean newValue;
    private List<Boolean> oldvalues;

    public SetLayersVisibilityCommand(List<ILayer> list, boolean isVisible) {
        this.layers = list;
        this.newValue = isVisible;
    }

    @Override
    public String getName() {
        return "Set Layer Visibility";
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        if (this.layers.isEmpty()) {
            return;
        }
        if (this.oldvalues == null) {
            this.oldvalues = new ArrayList<Boolean>(this.layers.size());
            for (ILayer layer : this.layers) {
                this.oldvalues.add(layer.isVisible());
            }
        }
        for (ILayer layer : this.layers) {
            ((Layer)layer).setVisible(this.newValue);
        }
    }

    @Override
    public void rollback(IProgressMonitor monitor) throws Exception {
        if (this.layers.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.layers.size()) {
            Layer layer = (Layer)this.layers.get(i);
            layer.setVisible(this.oldvalues.get(i));
            ++i;
        }
        this.oldvalues = null;
    }
}

