/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.command;

import com.vividsolutions.jts.geom.Envelope;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.CompositeCommand;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.commands.selection.BBoxSelectionCommand;
import net.refractions.udig.project.internal.commands.selection.FIDSelectCommand;
import net.refractions.udig.project.internal.commands.selection.NoSelectCommand;
import net.refractions.udig.project.internal.commands.selection.SelectCommand;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;

public class SelectionCommandFactory {
    private static final SelectionCommandFactory instance = new SelectionCommandFactory();

    public static SelectionCommandFactory getInstance() {
        return instance;
    }

    protected SelectionCommandFactory() {
    }

    public MapCommand createBBoxSelectionCommand(Envelope bbox, int modifiers) {
        return new BBoxSelectionCommand(bbox, modifiers);
    }

    public MapCommand createBBoxSelectionCommand(Envelope boundingBox) {
        return new BBoxSelectionCommand(boundingBox, 0);
    }

    public MapCommand createNoSelectCommand() {
        return new NoSelectCommand();
    }

    public MapCommand createFIDSelectCommand(ILayer layer, String fid) {
        return new FIDSelectCommand(layer, fid);
    }

    public MapCommand createFIDSelectCommand(ILayer layer, SimpleFeature feature) {
        return new FIDSelectCommand(layer, feature.getID());
    }

    public MapCommand createSelectCommand(ILayer layer, Filter filter) {
        return new SelectCommand(layer, filter);
    }

    public MapCommand createCompositeCommand(List<? extends MapCommand> commands) {
        return new CompositeCommand(commands);
    }

    public MapCommand createUndoableCompositeCommand(List<? extends UndoableMapCommand> commands) {
        return new UndoableComposite(commands);
    }
}

