/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.command;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.net.URL;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.core.IBlockingProvider;
import net.refractions.udig.core.StaticBlockingProvider;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.commands.DeleteLayerCommand;
import net.refractions.udig.project.internal.commands.edit.CreateFeatureCommand;
import net.refractions.udig.project.internal.commands.edit.CreateLayerCommand;
import net.refractions.udig.project.internal.commands.edit.DeleteFeatureCommand;
import net.refractions.udig.project.internal.commands.edit.ResetEditFeatureCommand;
import net.refractions.udig.project.internal.commands.edit.RollbackCommand;
import net.refractions.udig.project.internal.commands.edit.SetAttributeCommand;
import net.refractions.udig.project.internal.commands.edit.SetEditFeatureCommand;
import net.refractions.udig.project.internal.commands.edit.SetGeometryCommand;
import net.refractions.udig.project.internal.commands.edit.WriteEditFeatureCommand;
import net.refractions.udig.project.internal.commands.selection.CommitCommand;
import org.opengis.feature.simple.SimpleFeature;

public class EditCommandFactory {
    private static final EditCommandFactory instance = new EditCommandFactory();

    public static EditCommandFactory getInstance() {
        return instance;
    }

    protected EditCommandFactory() {
    }

    public UndoableMapCommand createSetAttributeCommand(String xpath, Object value) {
        return new SetAttributeCommand(xpath, value);
    }

    public UndoableMapCommand createSetGeometryCommand(String xpath, Geometry geom) {
        return new SetGeometryCommand(xpath, geom);
    }

    public UndoableMapCommand createSetGeometryCommand(Geometry geom) {
        return new SetGeometryCommand("DEFAULT_GEOMETRY", geom);
    }

    public UndoableMapCommand createSetEditFeatureCommand(SimpleFeature feature, ILayer layer) {
        return new SetEditFeatureCommand(feature, layer);
    }

    public MapCommand createCommitCommand() {
        return new CommitCommand();
    }

    public MapCommand createRollbackCommand() {
        return new RollbackCommand();
    }

    public UndoableMapCommand createSetEditFeatureCommand(SimpleFeature feature) {
        return new SetEditFeatureCommand(feature);
    }

    public UndoableMapCommand createNullEditFeatureCommand() {
        return new SetEditFeatureCommand(null, null);
    }

    public UndoableMapCommand createFeature(Coordinate[] coordinates) {
        return new CreateFeatureCommand(coordinates);
    }

    public UndoableMapCommand createDeleteLayer(Layer layer) {
        return new DeleteLayerCommand(layer);
    }

    public UndoableMapCommand createDeleteFeature(SimpleFeature feature, ILayer layer) {
        return new DeleteFeatureCommand((IBlockingProvider<SimpleFeature>)new StaticBlockingProvider((Object)feature), (IBlockingProvider<ILayer>)new StaticBlockingProvider((Object)layer));
    }

    public UndoableMapCommand createWriteEditFeatureCommand() {
        return new WriteEditFeatureCommand();
    }

    public UndoableMapCommand createCreateLayerCommand(URL resourceId) {
        return new CreateLayerCommand(resourceId);
    }

    public UndoableMapCommand createCreateLayerCommand(IGeoResource resource) {
        return new CreateLayerCommand(resource);
    }

    public UndoableMapCommand createResetEditFeatureCommand() {
        return new ResetEditFeatureCommand();
    }
}

