/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.raster.info;

import java.awt.Point;
import java.awt.image.IndexColorModel;
import org.geotools.arcsde.raster.info.CompressionType;
import org.geotools.arcsde.raster.info.InterleaveType;
import org.geotools.arcsde.raster.info.InterpolationType;
import org.geotools.arcsde.raster.info.RasterCellType;

public class RasterBandInfo {
    long bandId;
    String bandName;
    int bandNumber;
    IndexColorModel nativeColorMap;
    IndexColorModel colorMap;
    Number noDataValue;
    CompressionType compressionType;
    RasterCellType cellType;
    InterleaveType interleaveType;
    InterpolationType interpolationType;
    boolean hasStats;
    Point tileOrigin;
    double statsMin;
    double statsMax;
    double statsMean;
    double statsStdDev;

    public RasterBandInfo() {
    }

    public RasterBandInfo(long bandId, RasterCellType nativeType, Number noDataValue, double statsMin, double statsMax) {
        this.bandId = bandId;
        this.cellType = nativeType;
        this.noDataValue = noDataValue;
        this.statsMin = statsMin;
        this.statsMax = statsMax;
    }

    public long getBandId() {
        return this.bandId;
    }

    public String getBandName() {
        return this.bandName;
    }

    public int getBandNumber() {
        return this.bandNumber;
    }

    public boolean isColorMapped() {
        return this.nativeColorMap != null;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public RasterCellType getCellType() {
        return this.cellType;
    }

    public InterleaveType getInterleaveType() {
        return this.interleaveType;
    }

    public InterpolationType getInterpolationType() {
        return this.interpolationType;
    }

    public boolean isHasStats() {
        return this.hasStats;
    }

    public Point getTileOrigin() {
        return this.tileOrigin;
    }

    public IndexColorModel getNativeColorMap() {
        return this.nativeColorMap;
    }

    public IndexColorModel getColorMap() {
        return this.colorMap;
    }

    public double getStatsMin() {
        return this.statsMin;
    }

    public double getStatsMax() {
        return this.statsMax;
    }

    public double getStatsMean() {
        return this.statsMean;
    }

    public double getStatsStdDev() {
        return this.statsStdDev;
    }

    public Number getNoDataValue() {
        return this.noDataValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBandName());
        sb.append("[ id:").append(this.getBandId());
        sb.append(", type:").append((Object)this.getCellType());
        sb.append(", samples: nodata=").append(this.getNoDataValue()).append(" min=").append(this.getStatsMin()).append(" max=").append(this.getStatsMax()).append(" mean=").append(this.getStatsMean()).append(" stddev=").append(this.getStatsStdDev());
        sb.append(", compression:").append((Object)this.getCompressionType());
        sb.append(", interpolation:").append((Object)this.getInterpolationType());
        sb.append(", Color Map: ").append(this.isColorMapped() ? "YES" : "NO");
        return sb.toString();
    }
}

