/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.raster.gce;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.jndi.SharedSessionPool;
import org.geotools.arcsde.raster.gce.ArcSDEGridCoverage2DReaderJAI;
import org.geotools.arcsde.raster.info.GatherCoverageMetadataCommand;
import org.geotools.arcsde.raster.info.RasterDatasetInfo;
import org.geotools.arcsde.raster.io.RasterReaderFactory;
import org.geotools.arcsde.session.ArcSDEConnectionConfig;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.session.ISessionPool;
import org.geotools.arcsde.session.SessionPoolFactory;
import org.geotools.arcsde.session.UnavailableConnectionException;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.data.DataSourceException;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

public final class ArcSDERasterFormat
extends AbstractGridFormat
implements Format {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.gce");
    private final Map<String, ArcSDEConnectionConfig> connectionConfigs = new WeakHashMap<String, ArcSDEConnectionConfig>();
    private static final ArcSDERasterFormat instance = new ArcSDERasterFormat();
    private boolean statisticsMandatory = true;
    private static final WeakHashMap<String, ArcSDEGridCoverage2DReaderJAI> readerCache = new WeakHashMap();
    private static final ReadWriteLock readersLock = new ReentrantReadWriteLock();

    private ArcSDERasterFormat() {
        this.setInfo();
    }

    public static ArcSDERasterFormat getInstance() {
        return instance;
    }

    private void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "ArcSDE Raster");
        info.put("description", "ArcSDE Raster Format");
        info.put("vendor", "Geotools ");
        info.put("docURL", "");
        info.put("version", GeoTools.getVersion().toString());
        this.mInfo = info;
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D, OVERVIEW_POLICY}));
    }

    public AbstractGridCoverage2DReader getReader(Object source) {
        return this.getReader(source, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractGridCoverage2DReader getReader(Object source, Hints hints) {
        try {
            if (source == null) {
                throw new DataSourceException("No source set to read this coverage.");
            }
            String coverageUrl = this.parseCoverageUrl(source);
            readersLock.readLock().lock();
            ArcSDEGridCoverage2DReaderJAI reader = readerCache.get(coverageUrl);
            readersLock.readLock().unlock();
            if (reader == null) {
                readersLock.writeLock().lock();
                try {
                    reader = readerCache.get(coverageUrl);
                    if (reader == null) {
                        ArcSDEConnectionConfig connectionConfig = this.getConnectionConfig(coverageUrl);
                        ISessionPool sessionPool = this.setupConnectionPool(connectionConfig);
                        RasterDatasetInfo rasterInfo = this.loadRasterInfo(coverageUrl, sessionPool);
                        RasterReaderFactory rasterReaderFactory = new RasterReaderFactory(sessionPool);
                        reader = new ArcSDEGridCoverage2DReaderJAI(this, rasterReaderFactory, rasterInfo, hints);
                        readerCache.put(coverageUrl, reader);
                    }
                }
                finally {
                    readersLock.writeLock().unlock();
                }
            }
            return reader;
        }
        catch (IOException dse) {
            LOGGER.log(Level.SEVERE, "Unable to creata ArcSDERasterReader for " + source + ".", dse);
            throw new RuntimeException(dse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RasterDatasetInfo loadRasterInfo(String coverageUrl, ISessionPool connectionPool) throws IOException {
        RasterDatasetInfo rasterInfo;
        ISession scon;
        String sdeUrl = coverageUrl;
        if (sdeUrl.indexOf(";") != -1) {
            sdeUrl = sdeUrl.substring(0, sdeUrl.indexOf(";"));
        }
        String rasterTable = sdeUrl.substring(sdeUrl.indexOf("#") + 1);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Building ArcSDEGridCoverageReader2D for " + rasterTable);
        }
        try {
            scon = connectionPool.getSession(false);
        }
        catch (UnavailableConnectionException e) {
            throw new RuntimeException(e);
        }
        try {
            GatherCoverageMetadataCommand command = new GatherCoverageMetadataCommand(rasterTable, this.statisticsMandatory);
            rasterInfo = scon.issue(command);
        }
        finally {
            scon.dispose();
        }
        return rasterInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArcSDEConnectionConfig getConnectionConfig(String coverageUrl) {
        ArcSDEConnectionConfig sdeConfig = this.connectionConfigs.get(coverageUrl);
        if (sdeConfig == null) {
            Map<String, ArcSDEConnectionConfig> map = this.connectionConfigs;
            synchronized (map) {
                sdeConfig = this.connectionConfigs.get(coverageUrl);
                if (sdeConfig == null) {
                    sdeConfig = ArcSDERasterFormat.sdeURLToConnectionConfig(new StringBuffer(coverageUrl));
                    this.connectionConfigs.put(coverageUrl, sdeConfig);
                }
            }
        }
        return sdeConfig;
    }

    public GridCoverageWriter getWriter(Object destination) {
        return null;
    }

    public boolean accepts(Object input, Hints hints) {
        StringBuffer url;
        if (input instanceof File) {
            url = new StringBuffer(((File)input).getPath());
        } else if (input instanceof String) {
            url = new StringBuffer((String)input);
        } else {
            return false;
        }
        try {
            ArcSDERasterFormat.sdeURLToConnectionConfig(url);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getName() {
        return (String)this.mInfo.get("name");
    }

    public String getDescription() {
        return (String)this.mInfo.get("description");
    }

    public String getVendor() {
        return (String)this.mInfo.get("vendor");
    }

    public String getDocURL() {
        return (String)this.mInfo.get("docURL");
    }

    public String getVersion() {
        return (String)this.mInfo.get("version");
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException("ArcSDE Rasters are read only for now.");
    }

    private String parseCoverageUrl(Object input) {
        String coverageUrl;
        if (input instanceof String) {
            coverageUrl = (String)input;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("connecting to ArcSDE Raster: " + coverageUrl);
            }
        } else if (input instanceof File) {
            URI uri;
            String path = ((File)input).getPath();
            while (path.indexOf(92) > -1) {
                path = path.replace('\\', '/');
            }
            try {
                uri = new URI(path);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(path);
            }
            coverageUrl = uri.toString();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("connectiong via file-hack to ArcSDE Raster: " + coverageUrl);
            }
        } else {
            throw new IllegalArgumentException("Unsupported input type: " + input.getClass());
        }
        return coverageUrl;
    }

    private ISessionPool setupConnectionPool(ArcSDEConnectionConfig sdeConfig) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Getting ArcSDE connection pool for " + sdeConfig);
        }
        ISessionPool sessionPool = SharedSessionPool.getInstance(sdeConfig, SessionPoolFactory.getInstance());
        return sessionPool;
    }

    public static String createRasterURL(ArcSDEConnectionConfig config, String rasterName) {
        StringBuilder sb = new StringBuilder("sde://");
        sb.append(config.getUserName()).append(":").append(config.getPassword()).append("@");
        sb.append(config.getServerName()).append(":");
        sb.append(config.getPortNumber()).append("/");
        sb.append(config.getDatabaseName() == null ? "" : config.getDatabaseName());
        sb.append("#").append(rasterName);
        sb.append(";pool.minConnections=").append(config.getMinConnections());
        sb.append(";pool.maxConnections=").append(config.getMaxConnections());
        return sb.toString();
    }

    public static ArcSDEConnectionConfig sdeURLToConnectionConfig(StringBuffer sdeUrl) {
        String sdeHost;
        int sdePort;
        if (sdeUrl.indexOf("sde:/") == -1) {
            throw new IllegalArgumentException("ArcSDE Raster URL must be of the form sde://user:pass@sdehost:port/[dbname]#rasterTableName -- Got " + sdeUrl);
        }
        if (sdeUrl.indexOf("sde://") == -1) {
            sdeUrl.delete(0, 5);
        } else {
            sdeUrl.delete(0, 6);
        }
        int idx = sdeUrl.indexOf(":");
        if (idx == -1) {
            throw new IllegalArgumentException("ArcSDE Raster URL must be of the form sde://user:pass@sdehost:port/[dbname]#rasterTableName[;pool.minConnections=<int>][;pool.maxConnections=<int>]");
        }
        String sdeUser = sdeUrl.substring(0, idx);
        sdeUrl.delete(0, idx);
        idx = sdeUrl.indexOf("@");
        if (idx == -1) {
            throw new IllegalArgumentException("ArcSDE Raster URL must be of the form sde://user:pass@sdehost:port/[dbname]#rasterTableName[;pool.minConnections=<int>][;pool.maxConnections=<int>]");
        }
        String sdePass = sdeUrl.substring(1, idx);
        sdeUrl.delete(0, idx);
        idx = sdeUrl.indexOf(":");
        if (idx == -1) {
            sdePort = 5151;
            idx = sdeUrl.indexOf("/");
            if (idx == -1) {
                throw new IllegalArgumentException("ArcSDE Raster URL must be of the form sde://user:pass@sdehost:port/[dbname]#rasterTableName");
            }
            sdeHost = sdeUrl.substring(1, idx).toString();
            sdeUrl.delete(0, idx);
        } else {
            sdeHost = sdeUrl.substring(1, idx).toString();
            sdeUrl.delete(0, idx);
            idx = sdeUrl.indexOf("/");
            if (idx == -1) {
                throw new IllegalArgumentException("ArcSDE Raster URL must be of the form sde://user:pass@sdehost:port/[dbname]#rasterTableName");
            }
            sdePort = Integer.parseInt(sdeUrl.substring(1, idx).toString());
            sdeUrl.delete(0, idx);
        }
        idx = sdeUrl.indexOf("#");
        if (idx == -1) {
            throw new IllegalArgumentException("ArcSDE Raster URL must be of the form sde://user:pass@sdehost:port/[dbname]#rasterTableName");
        }
        String sdeDBName = sdeUrl.substring(1, idx).toString();
        sdeUrl.delete(0, idx);
        String minConnections = "1";
        String maxConnections = "10";
        if (sdeUrl.indexOf(";") > 0) {
            String[] options;
            String optionals = sdeUrl.substring(sdeUrl.indexOf(";") + 1);
            for (String option : options = optionals.split(";")) {
                String[] pair = option.split("=");
                if (pair.length != 2) {
                    LOGGER.info("Ignoring malformed optional param '" + option + "'");
                    continue;
                }
                String name = pair[0];
                String value = pair[1];
                if ("pool.minConnections".equals(name)) {
                    try {
                        minConnections = Integer.valueOf(value).toString();
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warning("Wrong pool.minConnections parameter: " + value);
                    }
                    continue;
                }
                if ("pool.maxConnections".equals(name)) {
                    try {
                        maxConnections = Integer.valueOf(value).toString();
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warning("Wrong pool.maxConnections parameter: " + value);
                    }
                    continue;
                }
                LOGGER.info("Ignoring unrecognized optional parameter '" + option + "'. Must be one of [pool.minConnections, pool.maxConnections]");
            }
        }
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("server", (Serializable)((Object)sdeHost));
        params.put("port", (Serializable)((Object)String.valueOf(sdePort)));
        params.put("instance", (Serializable)((Object)sdeDBName));
        params.put("user", (Serializable)((Object)sdeUser));
        params.put("password", (Serializable)((Object)sdePass));
        params.put("pool.minConnections", (Serializable)((Object)minConnections));
        params.put("pool.maxConnections", (Serializable)((Object)maxConnections));
        params.put("pool.timeOut", (Serializable)((Object)"-1"));
        ArcSDEConnectionConfig config = ArcSDEConnectionConfig.fromMap(params);
        return config;
    }

    void setStatisticsMandatory(boolean statisticsMandatory) {
        this.statisticsMandatory = statisticsMandatory;
    }

    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        return null;
    }
}

