/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.raster.gce;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.media.jai.ImageLayout;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.MosaicDescriptor;
import org.geotools.arcsde.raster.gce.ArcSDERasterFormat;
import org.geotools.arcsde.raster.info.RasterDatasetInfo;
import org.geotools.arcsde.raster.info.RasterQueryInfo;
import org.geotools.arcsde.raster.info.RasterUtils;
import org.geotools.arcsde.raster.io.RasterReaderFactory;
import org.geotools.arcsde.raster.io.TiledRasterReader;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class ArcSDEGridCoverage2DReaderJAI
extends AbstractGridCoverage2DReader {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.gce");
    private static final boolean DEBUG_TO_DISK = Boolean.getBoolean("org.geotools.arcsde.gce.debug");
    private final ArcSDERasterFormat parent;
    private final RasterDatasetInfo rasterInfo;
    private DefaultServiceInfo serviceInfo;
    private RasterReaderFactory rasterReaderFactory;

    public ArcSDEGridCoverage2DReaderJAI(ArcSDERasterFormat parent, RasterReaderFactory rasterReaderFactory, RasterDatasetInfo rasterInfo, Hints hints) throws IOException {
        GridEnvelope gridRange;
        int bitsPerSample = rasterInfo.getBand(0, 0).getCellType().getBitsPerSample();
        if (rasterInfo.getNumBands() > 1 && (bitsPerSample == 1 || bitsPerSample == 4)) {
            throw new IllegalArgumentException(bitsPerSample + "-bit rasters with more than one band are not supported");
        }
        this.parent = parent;
        this.rasterReaderFactory = rasterReaderFactory;
        this.rasterInfo = rasterInfo;
        this.hints = hints;
        this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints);
        this.crs = rasterInfo.getCoverageCrs();
        this.originalEnvelope = rasterInfo.getOriginalEnvelope(PixelInCell.CELL_CENTER);
        this.originalGridRange = gridRange = rasterInfo.getOriginalGridRange();
        this.coverageName = rasterInfo.getRasterTable();
        int numLevels = rasterInfo.getNumPyramidLevels(0);
        this.numOverviews = numLevels - 1;
        this.highestRes = AbstractGridCoverage2DReader.getResolution((GeneralEnvelope)this.originalEnvelope, (Rectangle2D)new Rectangle(this.originalGridRange.getLow(0), this.originalGridRange.getLow(1), this.originalGridRange.getSpan(0), this.originalGridRange.getSpan(1)), (CoordinateReferenceSystem)this.crs);
        if (this.numOverviews > 0) {
            this.overViewResolutions = new double[this.numOverviews][2];
            for (int pyramidLevel = 1; pyramidLevel <= this.numOverviews; ++pyramidLevel) {
                GridEnvelope levelGridRange = rasterInfo.getGridRange(0, pyramidLevel);
                GeneralEnvelope levelEnvelope = rasterInfo.getGridEnvelope(0, pyramidLevel);
                Rectangle2D.Double levelGridRangeRect = new Rectangle2D.Double(levelGridRange.getLow(0), levelGridRange.getLow(1), levelGridRange.getSpan(0), levelGridRange.getSpan(1));
                this.overViewResolutions[pyramidLevel - 1] = AbstractGridCoverage2DReader.getResolution((GeneralEnvelope)levelEnvelope, (Rectangle2D)levelGridRangeRect, (CoordinateReferenceSystem)this.crs);
            }
        } else {
            this.overViewResolutions = null;
        }
    }

    public Format getFormat() {
        return this.parent;
    }

    public ServiceInfo getInfo() {
        if (this.serviceInfo == null) {
            this.serviceInfo = new DefaultServiceInfo();
            this.serviceInfo.setTitle(this.rasterInfo.getRasterTable());
            this.serviceInfo.setDescription(this.rasterInfo.toString());
            HashSet<String> keywords = new HashSet<String>();
            keywords.add("ArcSDE");
            this.serviceInfo.setKeywords(keywords);
        }
        return this.serviceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridCoverage2D read(GeneralParameterValue[] params) throws IOException {
        ReadParameters opParams = this.parseReadParams(params);
        GeneralEnvelope requestedEnvelope = opParams.requestedEnvelope;
        GridEnvelope requestedDim = opParams.dim;
        OverviewPolicy overviewPolicy = opParams.overviewPolicy;
        List<RasterQueryInfo> queries = this.findMatchingRasters(requestedEnvelope, requestedDim, overviewPolicy);
        if (queries.isEmpty()) {
            if (requestedEnvelope.intersects((Envelope)this.getOriginalEnvelope(), true)) {
                ImageTypeSpecifier imageTypeSpecifier = RasterUtils.createFullImageTypeSpecifier(this.rasterInfo, 0);
                SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
                Point location = new Point(0, 0);
                WritableRaster raster = Raster.createWritableRaster(sampleModel, location);
                GridCoverage2D emptyCoverage = this.coverageFactory.create((CharSequence)this.coverageName, raster, (Envelope)requestedEnvelope);
                return emptyCoverage;
            }
            return null;
        }
        LoggingHelper log = new LoggingHelper();
        GridEnvelope mosaicGeometry = RasterUtils.setMosaicLocations(this.rasterInfo, queries);
        if (mosaicGeometry.getSpan(0) == 0 || mosaicGeometry.getSpan(1) == 0) {
            LOGGER.finer("Mosaic geometry width or height is zero, returning fake coverage for pixels " + mosaicGeometry);
            return null;
        }
        TiledRasterReader rasterReader = this.rasterReaderFactory.create(this.rasterInfo);
        this.readAllTiledRasters(queries, rasterReader, log);
        log.log(LoggingHelper.REQ_ENV);
        log.log(LoggingHelper.RES_ENV);
        log.log(LoggingHelper.MOSAIC_ENV);
        log.log(LoggingHelper.MOSAIC_EXPECTED);
        RenderedImage coverageRaster = this.createMosaic(queries, mosaicGeometry, log);
        assert (mosaicGeometry.getSpan(0) == coverageRaster.getWidth());
        assert (mosaicGeometry.getSpan(1) == coverageRaster.getHeight());
        GridSampleDimension[] bands = this.getSampleDimensions(coverageRaster);
        GeneralEnvelope resultEnvelope = this.getResultEnvelope(queries, mosaicGeometry);
        log.appendLoggingGeometries(LoggingHelper.REQ_ENV, requestedEnvelope);
        log.appendLoggingGeometries(LoggingHelper.RES_ENV, resultEnvelope);
        GridCoverage2D resultCoverage = this.coverageFactory.create((CharSequence)this.coverageName, coverageRaster, (Envelope)resultEnvelope, bands, null, null);
        return resultCoverage;
    }

    private GeneralEnvelope toPixelCenter(double[] resolution, GeneralEnvelope pixelCornerEnv) {
        double deltaX = resolution[0] / 2.0;
        double deltaY = resolution[1] / 2.0;
        GeneralEnvelope env = new GeneralEnvelope(pixelCornerEnv.getCoordinateReferenceSystem());
        env.setEnvelope(new double[]{pixelCornerEnv.getMinimum(0) + deltaX, pixelCornerEnv.getMinimum(1) + deltaY, pixelCornerEnv.getMaximum(0) - deltaX, pixelCornerEnv.getMaximum(1) - deltaY});
        return env;
    }

    private GridSampleDimension[] getSampleDimensions(RenderedImage coverageRaster) throws IOException {
        GridSampleDimension[] bands = this.rasterInfo.getGridSampleDimensions();
        int imageBands = coverageRaster.getSampleModel().getNumBands();
        if (bands.length == 1 && imageBands > 1) {
            LOGGER.fine(this.coverageName + " was promoted from 1 to " + coverageRaster.getSampleModel().getNumBands() + " bands, returning an appropriate set of GridSampleDimension");
            ColorModel cm = coverageRaster.getColorModel();
            bands = new GridSampleDimension[imageBands];
            for (int i = 0; i < imageBands; ++i) {
                ColorInterpretation colorInterpretation = TypeMap.getColorInterpretation((ColorModel)cm, (int)i);
                if (colorInterpretation == null) {
                    throw new IOException("Unrecognized sample dimension type");
                }
                bands[i] = new GridSampleDimension((CharSequence)colorInterpretation.name()).geophysics(true);
            }
        }
        return bands;
    }

    private void readAllTiledRasters(List<RasterQueryInfo> queries, TiledRasterReader rasterReader, LoggingHelper log) throws IOException {
        for (RasterQueryInfo queryInfo : queries) {
            RenderedImage rasterImage;
            Long rasterId = queryInfo.getRasterId();
            try {
                int pyramidLevel = queryInfo.getPyramidLevel();
                GridEnvelope matchingTiles = queryInfo.getMatchingTiles();
                rasterImage = rasterReader.read(rasterId, pyramidLevel, matchingTiles);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Fetching data for " + queryInfo.toString(), e);
                throw e;
            }
            queryInfo.setResultImage(rasterImage);
            LOGGER.finer(queryInfo.toString());
            log.appendLoggingGeometries(LoggingHelper.MOSAIC_EXPECTED, queryInfo.getMosaicLocation());
            log.appendLoggingGeometries(LoggingHelper.MOSAIC_ENV, queryInfo.getResultEnvelope());
        }
    }

    private List<RasterQueryInfo> findMatchingRasters(GeneralEnvelope requestedEnvelope, GridEnvelope requestedDim, OverviewPolicy overviewPolicy) {
        List<RasterQueryInfo> matchingQueries = RasterUtils.findMatchingRasters(this.rasterInfo, requestedEnvelope, requestedDim, overviewPolicy);
        if (matchingQueries.isEmpty()) {
            return matchingQueries;
        }
        for (RasterQueryInfo match : matchingQueries) {
            RasterUtils.fitRequestToRaster(requestedEnvelope, this.rasterInfo, match);
        }
        return matchingQueries;
    }

    private GeneralEnvelope getResultEnvelope(List<RasterQueryInfo> queryInfos, GridEnvelope mosaicGeometry) {
        RasterQueryInfo baseQueryInfo = RasterUtils.findLowestResolution(queryInfos);
        GeneralEnvelope finalEnvelope = null;
        int rasterIndex = baseQueryInfo.getRasterIndex();
        int pyramidLevel = baseQueryInfo.getPyramidLevel();
        MathTransform rasterToModel = this.rasterInfo.getRasterToModel(rasterIndex, pyramidLevel);
        CoordinateReferenceSystem coverageCrs = this.rasterInfo.getCoverageCrs();
        GeneralEnvelope mosaicGeometryEnv = new GeneralEnvelope(coverageCrs);
        mosaicGeometryEnv.setEnvelope(new double[]{mosaicGeometry.getLow(0), mosaicGeometry.getLow(1), 1 + mosaicGeometry.getHigh(0), 1 + mosaicGeometry.getHigh(1)});
        try {
            finalEnvelope = CRS.transform((MathTransform)rasterToModel, (Envelope)mosaicGeometryEnv);
            finalEnvelope.setCoordinateReferenceSystem(coverageCrs);
        }
        catch (TransformException e) {
            throw new RuntimeException(e);
        }
        return finalEnvelope;
    }

    private RenderedImage createMosaic(List<RasterQueryInfo> queries, GridEnvelope mosaicGeometry, LoggingHelper log) throws IOException {
        RenderedImage mosaic;
        boolean expandCM;
        ArrayList<RenderedImage> transformed = new ArrayList<RenderedImage>(queries.size());
        boolean bl = expandCM = queries.size() > 1 && this.rasterInfo.isColorMapped();
        if (expandCM) {
            LOGGER.fine("Creating mosaic out of " + queries.size() + " colormapped rasters. The mosaic tiles will be expanded to " + "\nRGB space and the resulting mosaic reduced to a new IndexColorModel");
        }
        for (RasterQueryInfo query : queries) {
            ParameterBlock pb;
            RenderedImage image = query.getResultImage();
            log.log(image, query.getRasterId(), "01_original");
            if (expandCM) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Creating color expanded version of tile for raster #" + query.getRasterId());
                }
                image = FormatDescriptor.create((RenderedImage)image, (Integer)0, null);
                log.log(image, query.getRasterId(), "04_1_colorExpanded");
            }
            image = this.cropToRequiredDimension(image, query.getResultGridRange());
            log.log(image, query.getRasterId(), "02_crop");
            if (queries.size() == 1) {
                return image;
            }
            GridEnvelope mosaicLocation = query.getMosaicLocation();
            Float scaleX = Float.valueOf((float)mosaicLocation.getSpan(0) / (float)image.getWidth());
            Float scaleY = Float.valueOf((float)mosaicLocation.getSpan(1) / (float)image.getHeight());
            Float translateX = Float.valueOf(0.0f);
            Float translateY = Float.valueOf(0.0f);
            if (!Float.valueOf(1.0f).equals(scaleX) || !Float.valueOf(1.0f).equals(scaleY)) {
                pb = new ParameterBlock();
                pb.addSource(image);
                pb.add(scaleX);
                pb.add(scaleY);
                pb.add(translateX);
                pb.add(translateY);
                pb.add(new InterpolationNearest());
                image = JAI.create((String)"scale", (ParameterBlock)pb);
                log.log(image, query.getRasterId(), "03_scale");
                int width = image.getWidth();
                int height = image.getHeight();
                assert (mosaicLocation.getSpan(0) == width);
                assert (mosaicLocation.getSpan(1) == height);
            }
            if (image.getMinX() != mosaicLocation.getLow(0) || image.getMinY() != mosaicLocation.getLow(1)) {
                pb = new ParameterBlock();
                pb.addSource(image);
                pb.add(Float.valueOf(mosaicLocation.getLow(0) - image.getMinX()));
                pb.add(Float.valueOf(mosaicLocation.getLow(1) - image.getMinY()));
                pb.add(null);
                image = JAI.create((String)"translate", (ParameterBlock)pb);
                log.log(image, query.getRasterId(), "04_translate");
                assert (image.getMinX() == mosaicLocation.getLow(0)) : image.getMinX() + " != " + mosaicLocation.getLow(0);
                assert (image.getMinY() == mosaicLocation.getLow(1)) : image.getMinY() + " != " + mosaicLocation.getLow(1);
                assert (image.getWidth() == mosaicLocation.getSpan(0)) : image.getWidth() + " != " + mosaicLocation.getSpan(0);
                assert (image.getHeight() == mosaicLocation.getSpan(1)) : image.getHeight() + " != " + mosaicLocation.getSpan(1);
            }
            transformed.add(image);
        }
        if (queries.size() == 1) {
            mosaic = (RenderedImage)transformed.get(0);
        } else {
            double[] backgroundValues;
            ParameterBlockJAI mosaicParams = new ParameterBlockJAI("Mosaic");
            mosaicParams.setParameter("mosaicType", (Object)MosaicDescriptor.MOSAIC_TYPE_OVERLAY);
            if (expandCM) {
                backgroundValues = new double[]{0.0, 0.0, 0.0, 0.0};
            } else {
                int numBands = this.rasterInfo.getNumBands();
                backgroundValues = new double[numBands];
                boolean rasterIndex = false;
                for (int bn = 0; bn < numBands; ++bn) {
                    Number noDataValue = this.rasterInfo.getNoDataValue(0, bn);
                    backgroundValues[bn] = noDataValue.doubleValue();
                }
            }
            mosaicParams.setParameter("backgroundValues", (Object)backgroundValues);
            ImageLayout layout = new ImageLayout(mosaicGeometry.getLow(0), mosaicGeometry.getLow(1), mosaicGeometry.getSpan(0), mosaicGeometry.getSpan(1));
            int tileWidth = this.rasterInfo.getTileDimension((int)0).width;
            int tileHeight = this.rasterInfo.getTileDimension((int)0).height;
            layout.setTileWidth(tileWidth);
            layout.setTileHeight(tileHeight);
            RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
            for (RenderedImage img : transformed) {
                mosaicParams.addSource((Object)img);
                log.appendLoggingGeometries(LoggingHelper.MOSAIC_RESULT, img);
            }
            log.log(LoggingHelper.MOSAIC_RESULT);
            LOGGER.fine("Creating mosaic out of " + queries.size() + " raster tiles");
            mosaic = JAI.create((String)"Mosaic", (ParameterBlock)mosaicParams, (RenderingHints)hints);
            log.log(mosaic, 0L, "05_mosaic_result");
        }
        return mosaic;
    }

    private RenderedImage cropToRequiredDimension(RenderedImage fullTilesRaster, GridEnvelope cropTo) {
        GridEnvelope2D crop = new GridEnvelope2D(cropTo.getLow(0), cropTo.getLow(1), cropTo.getSpan(0), cropTo.getSpan(1));
        GridEnvelope2D origDim = new GridEnvelope2D(fullTilesRaster.getMinX(), fullTilesRaster.getMinY(), fullTilesRaster.getWidth(), fullTilesRaster.getHeight());
        if (!origDim.contains((Rectangle)crop)) {
            throw new IllegalArgumentException("Original image (" + origDim + ") does not contain desired dimension (" + crop + ")");
        }
        if (origDim.equals((Object)crop)) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("No need to crop image, full tiled dimension and target one do match: original: " + fullTilesRaster.getWidth() + "x" + fullTilesRaster.getHeight() + ", target: " + crop.getSpan(0) + "x" + crop.getSpan(1));
            }
            return fullTilesRaster;
        }
        ParameterBlock cropParams = new ParameterBlock();
        cropParams.addSource(fullTilesRaster);
        cropParams.add(Float.valueOf(crop.getLow(0)));
        cropParams.add(Float.valueOf(crop.getLow(1)));
        cropParams.add(Float.valueOf(crop.getSpan(0)));
        cropParams.add(Float.valueOf(crop.getSpan(1)));
        RenderingHints hints = new RenderingHints(JAI.KEY_OPERATION_BOUND, 3);
        RenderedOp image = JAI.create((String)"Crop", (ParameterBlock)cropParams, (RenderingHints)hints);
        assert (crop.getLow(0) == image.getMinX());
        assert (crop.getLow(1) == image.getMinY());
        assert (crop.getSpan(0) == image.getWidth());
        assert (crop.getSpan(1) == image.getHeight());
        return image;
    }

    private ReadParameters parseReadParams(GeneralParameterValue[] params) throws IllegalArgumentException {
        if (params == null) {
            throw new IllegalArgumentException("No GeneralParameterValue given to read operation");
        }
        GeneralEnvelope reqEnvelope = null;
        GridEnvelope dim = null;
        OverviewPolicy overviewPolicy = null;
        for (int i = 0; i < params.length; ++i) {
            ParameterValue param = (ParameterValue)params[i];
            String name = param.getDescriptor().getName().getCode();
            if (name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString())) {
                CoordinateReferenceSystem requestCrs;
                GridGeometry2D gg = (GridGeometry2D)param.getValue();
                reqEnvelope = new GeneralEnvelope((Envelope)gg.getEnvelope2D());
                GeneralEnvelope coverageEnvelope = this.getOriginalEnvelope();
                CoordinateReferenceSystem nativeCrs = coverageEnvelope.getCoordinateReferenceSystem();
                if (!CRS.equalsIgnoreMetadata((Object)nativeCrs, (Object)(requestCrs = reqEnvelope.getCoordinateReferenceSystem()))) {
                    LOGGER.fine("Request CRS and native CRS differ, reprojecting request envelope to native CRS");
                    ReferencedEnvelope nativeCrsEnv = ArcSDEGridCoverage2DReaderJAI.toNativeCrs(reqEnvelope, nativeCrs);
                    reqEnvelope = new GeneralEnvelope((Envelope)nativeCrsEnv);
                }
                dim = gg.getGridRange2D();
                continue;
            }
            if (!name.equals(AbstractGridFormat.OVERVIEW_POLICY.getName().toString())) continue;
            overviewPolicy = (OverviewPolicy)param.getValue();
        }
        if (reqEnvelope == null && dim == null) {
            reqEnvelope = this.getOriginalEnvelope();
            dim = this.getOriginalGridRange();
        }
        if (reqEnvelope == null) {
            reqEnvelope = this.getOriginalEnvelope();
        }
        if (dim == null) {
            GeneralEnvelope adjustedGRange;
            try {
                MathTransform gridToWorld = this.getOriginalGridToWorld(PixelInCell.CELL_CENTER);
                MathTransform worldToGrid = gridToWorld.inverse();
                adjustedGRange = CRS.transform((MathTransform)worldToGrid, (Envelope)reqEnvelope);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            int xmin = (int)Math.floor(adjustedGRange.getMinimum(0));
            int ymin = (int)Math.floor(adjustedGRange.getMinimum(1));
            int xmax = (int)Math.ceil(adjustedGRange.getMaximum(0));
            int ymax = (int)Math.ceil(adjustedGRange.getMaximum(1));
            dim = new GridEnvelope2D(xmin, ymin, xmax - xmin, ymax - ymin);
        }
        if (!reqEnvelope.intersects((Envelope)this.getOriginalEnvelope(), true)) {
            throw new IllegalArgumentException("The requested extend does not overlap the coverage extent: " + this.getOriginalEnvelope());
        }
        if (dim.getSpan(0) <= 0 || dim.getSpan(1) <= 0) {
            throw new IllegalArgumentException("The requested coverage dimension can't be null: " + dim);
        }
        if (overviewPolicy == null) {
            overviewPolicy = OverviewPolicy.NEAREST;
            LOGGER.finer("No overview policy requested, defaulting to " + overviewPolicy);
        }
        LOGGER.fine("Overview policy is " + overviewPolicy);
        ReadParameters parsedParams = new ReadParameters();
        parsedParams.requestedEnvelope = reqEnvelope;
        parsedParams.dim = dim;
        parsedParams.overviewPolicy = overviewPolicy;
        return parsedParams;
    }

    private static ReferencedEnvelope toNativeCrs(GeneralEnvelope requestedEnvelope, CoordinateReferenceSystem nativeCRS) throws IllegalArgumentException {
        ReferencedEnvelope reqEnv = ArcSDEGridCoverage2DReaderJAI.toReferencedEnvelope(requestedEnvelope);
        if (!CRS.equalsIgnoreMetadata((Object)nativeCRS, (Object)reqEnv.getCoordinateReferenceSystem())) {
            try {
                reqEnv = reqEnv.transform(nativeCRS, true);
            }
            catch (FactoryException fe) {
                throw new IllegalArgumentException("Unable to find a reprojection from requested coordsys to native coordsys for this request", fe);
            }
            catch (TransformException te) {
                throw new IllegalArgumentException("Unable to perform reprojection from requested coordsys to native coordsys for this request", te);
            }
        }
        return reqEnv;
    }

    private static ReferencedEnvelope toReferencedEnvelope(GeneralEnvelope envelope) {
        double minx = envelope.getMinimum(0);
        double maxx = envelope.getMaximum(0);
        double miny = envelope.getMinimum(1);
        double maxy = envelope.getMaximum(1);
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        ReferencedEnvelope refEnv = new ReferencedEnvelope(minx, maxx, miny, maxy, crs);
        return refEnv;
    }

    private static class LoggingHelper {
        private static final File debugDir = new File(System.getProperty("user.home") + File.separator + "arcsde_test");
        public Level GEOM_LEVEL = Level.FINER;
        public static String REQ_ENV;
        public static String RES_ENV;
        public static String MOSAIC_ENV;
        public static String MOSAIC_EXPECTED;
        public static String MOSAIC_RESULT;
        private Map<String, StringBuilder> geoms = null;

        LoggingHelper() {
        }

        private StringBuilder getGeom(String geomName) {
            StringBuilder sb;
            if (this.geoms == null) {
                this.geoms = new HashMap<String, StringBuilder>();
            }
            if ((sb = this.geoms.get(geomName)) == null) {
                sb = new StringBuilder("MULTIPOLYGON(\n");
                this.geoms.put(geomName, sb);
            }
            return sb;
        }

        public void appendLoggingGeometries(String geomName, RenderedImage img) {
            if (LOGGER.isLoggable(this.GEOM_LEVEL)) {
                this.appendLoggingGeometries(geomName, (GridEnvelope)new GridEnvelope2D(img.getMinX(), img.getMinY(), img.getWidth(), img.getHeight()));
            }
        }

        public void appendLoggingGeometries(String geomName, GridEnvelope env) {
            if (LOGGER.isLoggable(this.GEOM_LEVEL)) {
                this.appendLoggingGeometries(geomName, new GeneralEnvelope((Rectangle2D)new Rectangle2D.Double(env.getLow(0), env.getLow(1), env.getSpan(0), env.getSpan(1))));
            }
        }

        public void appendLoggingGeometries(String geomName, GeneralEnvelope env) {
            if (LOGGER.isLoggable(this.GEOM_LEVEL)) {
                StringBuilder sb = this.getGeom(geomName);
                sb.append("  ((" + env.getMinimum(0) + " " + env.getMinimum(1) + ", " + env.getMaximum(0) + " " + env.getMinimum(1) + ", " + env.getMaximum(0) + " " + env.getMaximum(1) + ", " + env.getMinimum(0) + " " + env.getMaximum(1) + ", " + env.getMinimum(0) + " " + env.getMinimum(1) + ")),");
            }
        }

        public void log(String geomName) {
            if (LOGGER.isLoggable(this.GEOM_LEVEL)) {
                StringBuilder sb = this.getGeom(geomName);
                sb.setLength(sb.length() - 1);
                sb.append("\n)");
                LOGGER.log(this.GEOM_LEVEL, geomName + ":\n" + sb.toString());
            }
        }

        public void log(RenderedImage image, Long rasterId, String fileName) {
            if (DEBUG_TO_DISK) {
                LOGGER.warning("BEWARE THE DEBUG FLAG IS TURNED ON! IF IN PRODUCTION THIS IS A SEVERE MISTAKE!!!");
                try {
                    ImageIO.write(image, "TIFF", new File(debugDir, rasterId + fileName + ".tiff"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        static {
            if (DEBUG_TO_DISK) {
                debugDir.mkdir();
            }
            REQ_ENV = "Requested envelope";
            RES_ENV = "Resulting envelope";
            MOSAIC_ENV = "Resulting mosaiced envelopes";
            MOSAIC_EXPECTED = "Expected mosaic layout (in pixels)";
            MOSAIC_RESULT = "Resulting image mosaic layout (in pixels)";
        }
    }

    static class ReadParameters {
        GeneralEnvelope requestedEnvelope;
        GridEnvelope dim;
        OverviewPolicy overviewPolicy;

        ReadParameters() {
        }
    }
}

